/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.h2.QueryParserCacheEntry;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCachelessQueriesSelfTest
extends GridCommonAbstractTest {
    private static final String SELECT = "select count(*) from \"pers\".Person p, \"org\".Organization o where p.orgId = o._key";
    private static final String ORG_CACHE_NAME = "org";
    private static final String PERSON_CAHE_NAME = "pers";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheKeyConfiguration keyCfg = new CacheKeyConfiguration("MyCache", "affKey");
        cfg.setCacheKeyConfiguration(new CacheKeyConfiguration[]{keyCfg});
        cfg.setPeerClassLoadingEnabled(false);
        return cfg;
    }

    private int nodesCount() {
        return 1;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrids(this.nodesCount());
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected <K, V> CacheConfiguration<K, V> cacheConfig(String name, TestCacheMode mode, Class<?> ... idxTypes) {
        return new CacheConfiguration().setName(name).setCacheMode(mode == TestCacheMode.REPLICATED ? CacheMode.REPLICATED : CacheMode.PARTITIONED).setQueryParallelism(mode == TestCacheMode.SEGMENTED ? 5 : 1).setAtomicityMode(CacheAtomicityMode.ATOMIC).setIndexedTypes((Class[])idxTypes);
    }

    @Test
    public void testDistributedQueryOnPartitionedCaches() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.PARTITIONED, false, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testDistributedQueryOnPartitionedAndReplicatedCache() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.REPLICATED, false, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testDistributedQueryOnReplicatedCaches() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.REPLICATED, false, false);
        this.assertLocalQuery();
    }

    @Test
    public void testDistributedQueryOnSegmentedCaches() {
        this.createCachesAndExecuteQuery(TestCacheMode.SEGMENTED, TestCacheMode.SEGMENTED, false, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testDistributedQueryOnReplicatedAndSegmentedCache() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.SEGMENTED, false, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testDistributedQueryOnPartitionedCachesWithReplicatedFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.PARTITIONED, true, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testDistributedQueryOnPartitionedAndReplicatedCacheWithReplicatedFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.REPLICATED, true, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testLocalQueryOnReplicatedCachesWithReplicatedFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.REPLICATED, true, false);
        this.assertLocalQuery();
    }

    @Test
    public void testDistributedQueryOnSegmentedCachesWithReplicatedFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.SEGMENTED, TestCacheMode.SEGMENTED, true, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testDistributedQueryOnReplicatedAndSegmentedCacheWithReplicatedFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.SEGMENTED, true, false);
        this.assertDistributedQuery();
    }

    @Test
    public void testLocalQueryOnPartitionedCachesWithLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.PARTITIONED, false, true);
        this.assertLocalQuery();
    }

    @Test
    public void testLocalQueryOnPartitionedAndReplicatedCacheWithLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.REPLICATED, false, true);
        this.assertLocalQuery();
    }

    @Test
    public void testLocalQueryOnReplicatedCachesWithLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.REPLICATED, false, true);
        this.assertLocalQuery();
    }

    @Test
    public void testLocalTwoStepQueryOnSegmentedCachesWithLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.SEGMENTED, TestCacheMode.SEGMENTED, false, true);
        this.assertLocalTwoStepQuery();
    }

    @Test
    public void testLocalTwoStepQueryOnReplicatedAndSegmentedCacheWithLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.SEGMENTED, false, true);
        this.assertLocalTwoStepQuery();
    }

    @Test
    public void testLocalQueryOnPartitionedCachesWithReplicatedAndLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.PARTITIONED, false, true);
        this.assertLocalQuery();
    }

    @Test
    public void testLocalQueryOnPartitionedAndReplicatedCacheWithReplicatedAndLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.PARTITIONED, TestCacheMode.REPLICATED, true, true);
        this.assertLocalQuery();
    }

    @Test
    public void testLocalQueryOnReplicatedCachesWithReplicatedAndLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.REPLICATED, true, true);
        this.assertLocalQuery();
    }

    @Test
    public void testLocalTwoStepQueryOnSegmentedCachesWithReplicatedAndLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.SEGMENTED, TestCacheMode.SEGMENTED, true, true);
        this.assertLocalTwoStepQuery();
    }

    @Test
    public void testLocalTwoStepQueryOnReplicatedAndSegmentedCacheWithReplicatedAndLocalFlag() {
        this.createCachesAndExecuteQuery(TestCacheMode.REPLICATED, TestCacheMode.SEGMENTED, true, true);
        this.assertLocalTwoStepQuery();
    }

    private void createCachesAndExecuteQuery(TestCacheMode firstCacheMode, TestCacheMode secondCacheMode, boolean replicatedOnly, boolean loc) {
        IgniteEx node = this.ignite(0);
        node.createCache(this.cacheConfig(PERSON_CAHE_NAME, firstCacheMode, Integer.class, Person.class));
        node.createCache(this.cacheConfig(ORG_CACHE_NAME, secondCacheMode, Integer.class, Organization.class));
        IgniteCache c = node.cache(PERSON_CAHE_NAME);
        c.query(new SqlFieldsQuery(SELECT).setReplicatedOnly(replicatedOnly).setLocal(loc)).getAll();
    }

    private GridCacheTwoStepQuery cachedTwoStepQuery() {
        GridQueryIndexing idx = this.grid(0).context().query().getIndexing();
        Map m = (Map)U.field((Object)U.field((Object)idx, (String)"parser"), (String)"cache");
        if (m.isEmpty()) {
            return null;
        }
        QueryParserCacheEntry q = (QueryParserCacheEntry)m.values().iterator().next();
        return q.select().twoStepQuery();
    }

    private void assertDistributedQuery() {
        GridCacheTwoStepQuery q = this.cachedTwoStepQuery();
        IgniteCachelessQueriesSelfTest.assertNotNull((Object)q);
        IgniteCachelessQueriesSelfTest.assertFalse((boolean)q.isLocal());
    }

    private void assertLocalTwoStepQuery() {
        GridCacheTwoStepQuery q = this.cachedTwoStepQuery();
        IgniteCachelessQueriesSelfTest.assertNotNull((Object)q);
        IgniteCachelessQueriesSelfTest.assertTrue((boolean)q.isLocal());
    }

    private void assertLocalQuery() {
        GridCacheTwoStepQuery q = this.cachedTwoStepQuery();
        IgniteCachelessQueriesSelfTest.assertNull((Object)q);
    }

    private static enum TestCacheMode {
        SEGMENTED,
        PARTITIONED,
        REPLICATED;

    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        String name;

        public Organization() {
        }

        public Organization(String name) {
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        Integer orgId;
        @QuerySqlField
        String name;

        public Person() {
        }

        public Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }
}

