/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.database.IgniteDbSingleNodePutGetTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.junit.Test;

public class IgniteDbSingleNodeWithIndexingPutGetTest
extends IgniteDbSingleNodePutGetTest {
    protected boolean indexingEnabled() {
        return true;
    }

    @Test
    public void testGroupIndexes() {
        IgniteEx ig = this.grid(0);
        IgniteCache cache = ig.cache("abc");
        long cnt = 50000L;
        int i = 0;
        while ((long)i < cnt) {
            cache.put((Object)i, (Object)new Abc(i, i % 10, i % 100));
            ++i;
        }
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((int)1, (int)IgniteDbSingleNodeWithIndexingPutGetTest.querySize(cache, "select count(*) from Abc"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)cnt, IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, "select count(*) from Abc"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((int)((int)cnt), (int)IgniteDbSingleNodeWithIndexingPutGetTest.querySize(cache, "select count(*) from Abc group by a"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)1L, IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, "select count(*) from Abc group by a"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)1L, IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, "select count(*) from Abc where a = 1"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((int)10, (int)IgniteDbSingleNodeWithIndexingPutGetTest.querySize(cache, "select count(*) from Abc group by b"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)(cnt / 10L), IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, "select count(*) from Abc group by b"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)(cnt / 10L), IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, "select count(*) from Abc where b = 1"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((int)100, (int)IgniteDbSingleNodeWithIndexingPutGetTest.querySize(cache, "select count(*) from Abc group by c"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)(cnt / 100L), IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, "select count(*) from Abc group by c"));
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)(cnt / 100L), IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, "select count(*) from Abc where c = 1"));
    }

    @Test
    public void testGroupIndexes2() {
        IgniteEx ig = this.grid(0);
        IgniteCache cache = ig.cache("abc");
        long cnt = 10000L;
        TreeMap<Integer, AtomicLong> as = new TreeMap<Integer, AtomicLong>();
        TreeMap<Integer, AtomicLong> bs = new TreeMap<Integer, AtomicLong>();
        TreeMap<Integer, AtomicLong> cs = new TreeMap<Integer, AtomicLong>();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int i = 0;
        while ((long)i < cnt) {
            Abc abc = new Abc(((Random)rnd).nextInt(2000), ((Random)rnd).nextInt(100), ((Random)rnd).nextInt(5));
            cache.put((Object)i, (Object)abc);
            IgniteDbSingleNodeWithIndexingPutGetTest.add(as, abc.a, true);
            IgniteDbSingleNodeWithIndexingPutGetTest.add(bs, abc.b, true);
            IgniteDbSingleNodeWithIndexingPutGetTest.add(cs, abc.c, true);
            if (((Random)rnd).nextInt(1000) == 0) {
                switch (((Random)rnd).nextInt(3)) {
                    case 0: {
                        IgniteDbSingleNodeWithIndexingPutGetTest.check(as, (IgniteCache<Integer, Abc>)cache, "a");
                        break;
                    }
                    case 1: {
                        IgniteDbSingleNodeWithIndexingPutGetTest.check(bs, (IgniteCache<Integer, Abc>)cache, "b");
                        break;
                    }
                    case 2: {
                        IgniteDbSingleNodeWithIndexingPutGetTest.check(cs, (IgniteCache<Integer, Abc>)cache, "c");
                        break;
                    }
                    default: {
                        IgniteDbSingleNodeWithIndexingPutGetTest.fail();
                    }
                }
            }
            ++i;
        }
        IgniteDbSingleNodeWithIndexingPutGetTest.check(as, (IgniteCache<Integer, Abc>)cache, "a");
        IgniteDbSingleNodeWithIndexingPutGetTest.check(bs, (IgniteCache<Integer, Abc>)cache, "b");
        IgniteDbSingleNodeWithIndexingPutGetTest.check(cs, (IgniteCache<Integer, Abc>)cache, "c");
    }

    private static void check(Map<Integer, AtomicLong> xs, IgniteCache<Integer, Abc> cache, String field) {
        String qry = "select " + field + ", count(*) from Abc group by " + field + " order by " + field;
        List res = cache.query(new SqlFieldsQuery(qry)).getAll();
        IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((int)xs.size(), (int)res.size());
        int i = 0;
        for (Map.Entry<Integer, AtomicLong> entry : xs.entrySet()) {
            int key = entry.getKey();
            long cnt = entry.getValue().get();
            IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)key, ((List)res.get(i)).get(0));
            IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)cnt, ((List)res.get(i)).get(1));
            qry = "select 1 from Abc where " + field + " = " + key;
            IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((long)cnt, (long)IgniteDbSingleNodeWithIndexingPutGetTest.querySize(cache, qry));
            qry = "select count(*) from Abc where " + field + " = " + key;
            IgniteDbSingleNodeWithIndexingPutGetTest.assertEquals((Object)cnt, IgniteDbSingleNodeWithIndexingPutGetTest.queryOne(cache, qry));
            ++i;
        }
    }

    private static void add(Map<Integer, AtomicLong> xs, int key, boolean inc) {
        AtomicLong cntr = xs.get(key);
        if (cntr == null) {
            if (!inc) {
                IgniteDbSingleNodeWithIndexingPutGetTest.fail((String)"Nothing to decrement.");
            }
            cntr = new AtomicLong();
            xs.put(key, cntr);
        }
        cntr.addAndGet(inc ? 1L : -1L);
    }

    private static <X> X queryOne(IgniteCache<?, ?> cache, String qry) {
        return (X)((List)cache.query(new SqlFieldsQuery(qry)).getAll().get(0)).get(0);
    }

    private static int querySize(IgniteCache<?, ?> cache, String qry) {
        return cache.query(new SqlFieldsQuery(qry)).getAll().size();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration ccfg = new CacheConfiguration("abc");
        if (this.indexingEnabled()) {
            ccfg.setIndexedTypes(new Class[]{Integer.class, Abc.class});
        }
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        cfg.setCacheConfiguration((CacheConfiguration[])F.concat((Object[])cfg.getCacheConfiguration(), (Object[])new CacheConfiguration[]{ccfg}));
        return cfg;
    }

    static class Abc {
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="abc", order=0)})
        private int a;
        @QuerySqlField(index=true, orderedGroups={@QuerySqlField.Group(name="abc", order=1), @QuerySqlField.Group(name="cb", order=1)})
        private int b;
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="abc", order=2), @QuerySqlField.Group(name="cb", order=0)})
        private int c;

        Abc(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public String toString() {
            return S.toString(Abc.class, (Object)this);
        }
    }
}

