/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.ttl;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ModifiedExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class CacheSizeTtlTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "TestCache";
    private static final Duration ENTRY_EXPIRY_DURATION = new Duration(TimeUnit.SECONDS, 1L);

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testCacheSizeWorksCorrectlyWithTtl() throws IgniteInterruptedCheckedException {
        CacheSizeTtlTest.startIgniteServer();
        Ignite client = CacheSizeTtlTest.startIgniteClient();
        try (IgniteDataStreamer dataStreamer = client.dataStreamer(CACHE_NAME);){
            IntStream.range(0, 100000).forEach(i -> dataStreamer.addData((Object)1, (Object)LocalDateTime.now()));
        }
        CacheSizeTtlTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> client.cache(CACHE_NAME).size(new CachePeekMode[]{CachePeekMode.PRIMARY}) == 0, (long)this.getTestTimeout()));
    }

    @Test
    public void testCachePutWorksCorrectlyWithTtl() throws Exception {
        CacheSizeTtlTest.startIgniteServer();
        Ignite client = CacheSizeTtlTest.startIgniteClient();
        this.multithreaded(() -> IntStream.range(0, 20000).forEach(i -> client.cache(CACHE_NAME).put((Object)1, (Object)LocalDateTime.now())), 8);
        CacheSizeTtlTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> client.cache(CACHE_NAME).size(new CachePeekMode[]{CachePeekMode.PRIMARY}) == 0, (long)this.getTestTimeout()));
    }

    private static Ignite startIgniteServer() {
        IgniteConfiguration configuration = new IgniteConfiguration().setClientMode(false).setIgniteInstanceName(UUID.randomUUID().toString()).setCacheConfiguration(new CacheConfiguration[]{CacheSizeTtlTest.cacheConfiguration()}).setDiscoverySpi((DiscoverySpi)CacheSizeTtlTest.discoveryConfiguration());
        return Ignition.start((IgniteConfiguration)configuration);
    }

    private static Ignite startIgniteClient() {
        IgniteConfiguration configuration = new IgniteConfiguration().setClientMode(true).setIgniteInstanceName(UUID.randomUUID().toString()).setDiscoverySpi((DiscoverySpi)CacheSizeTtlTest.discoveryConfiguration());
        return Ignition.start((IgniteConfiguration)configuration);
    }

    @NotNull
    private static CacheConfiguration<String, LocalDateTime> cacheConfiguration() {
        return new CacheConfiguration().setName(CACHE_NAME).setCacheMode(CacheMode.REPLICATED).setEagerTtl(true).setExpiryPolicyFactory(ModifiedExpiryPolicy.factoryOf((Duration)ENTRY_EXPIRY_DURATION));
    }

    private static TcpDiscoverySpi discoveryConfiguration() {
        TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder();
        ipFinder.setAddresses(Collections.singleton("127.0.0.1:48550..48551"));
        TcpDiscoverySpi tcpDiscoverySpi = new TcpDiscoverySpi();
        tcpDiscoverySpi.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
        tcpDiscoverySpi.setLocalPort(48550);
        tcpDiscoverySpi.setLocalPortRange(1);
        return tcpDiscoverySpi;
    }
}

