/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheUpdateSqlQuerySelfTest;
import org.apache.ignite.internal.processors.cache.persistence.IgnitePdsDefragmentationTest;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.DefragmentationFileUtils;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;

public class IgnitePdsIndexingDefragmentationTest
extends IgnitePdsDefragmentationTest {
    private static final String USE_MVCC = "USE_MVCC";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        dsCfg.setWalSegmentSize(0x400000);
        dsCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setInitialSize(0x6400000L).setMaxSize(0x40000000L).setPersistenceEnabled(true));
        cfg.setDataStorageConfiguration(dsCfg);
        CacheConfiguration cache1Cfg = new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setGroupName("group").setIndexedTypes(new Class[]{IgniteCacheUpdateSqlQuerySelfTest.AllTypes.class, byte[].class, Integer.class, byte[].class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 5));
        CacheConfiguration cache2Cfg = new CacheConfiguration("cache2").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setGroupName("group").setIndexedTypes(new Class[]{IgniteCacheUpdateSqlQuerySelfTest.AllTypes.class, byte[].class, Integer.class, byte[].class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 5));
        if (Boolean.TRUE.toString().equals(System.getProperty(USE_MVCC))) {
            cache1Cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
            cache2Cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
        } else {
            cache2Cfg.setExpiryPolicyFactory((Factory)new IgnitePdsDefragmentationTest.PolicyFactory());
        }
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache1Cfg, cache2Cfg});
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        GridQueryProcessor.idxCls = null;
    }

    private <T> void test(Function<Integer, T> keyMapper) throws Exception {
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        this.fillCache(keyMapper, ig.cache("default"));
        this.forceCheckpoint((Ignite)ig);
        IgnitePdsIndexingDefragmentationTest.createMaintenanceRecord((IgniteEx)this.grid(0), (String[])new String[0]);
        this.stopGrid(0);
        File dbWorkDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)false);
        File nodeWorkDir = new File(dbWorkDir, U.maskForFileName((CharSequence)ig.name()));
        File workDir = new File(nodeWorkDir, "cacheGroup-group");
        long oldIdxFileLen = new File(workDir, "index.bin").length();
        this.startGrid(0);
        IgnitePdsIndexingDefragmentationTest.waitForDefragmentation((IgniteEx)this.grid(0));
        long newIdxFileLen = new File(workDir, "index.bin").length();
        IgnitePdsIndexingDefragmentationTest.assertTrue((String)("newIdxFileLen=" + newIdxFileLen + ", oldIdxFileLen=" + oldIdxFileLen), (newIdxFileLen <= oldIdxFileLen ? 1 : 0) != 0);
        File completionMarkerFile = DefragmentationFileUtils.defragmentationCompletionMarkerFile((File)workDir);
        IgnitePdsIndexingDefragmentationTest.assertTrue((String)Arrays.toString(workDir.listFiles()), (boolean)completionMarkerFile.exists());
        this.stopGrid(0);
        GridQueryProcessor.idxCls = CaptureRebuildGridQueryIndexing.class;
        IgniteEx node = this.startGrid(0);
        this.awaitPartitionMapExchange();
        CaptureRebuildGridQueryIndexing indexing = (CaptureRebuildGridQueryIndexing)node.context().query().getIndexing();
        IgnitePdsIndexingDefragmentationTest.assertFalse((boolean)indexing.didRebuildIndexes());
        IgniteCache cache = node.cache("default");
        IgnitePdsIndexingDefragmentationTest.assertFalse((boolean)completionMarkerFile.exists());
        IgnitePdsIndexingDefragmentationTest.validateIndexes(node);
        for (int k = 0; k < 1500; ++k) {
            cache.get(keyMapper.apply(k));
        }
    }

    private static void validateIndexes(IgniteEx node) throws Exception {
        ValidateIndexesClosure clo = new ValidateIndexesClosure(() -> false, Collections.singleton("default"), 0, 0, false, true);
        node.context().resource().injectGeneric((Object)clo);
        VisorValidateIndexesJobResult call = clo.call();
        IgnitePdsIndexingDefragmentationTest.assertFalse((boolean)call.hasIssues());
    }

    @Test
    public void testIndexingWithIntegerKey() throws Exception {
        this.test(Function.identity());
    }

    @Test
    public void testIndexingWithComplexKey() throws Exception {
        this.test(integer -> new IgniteCacheUpdateSqlQuerySelfTest.AllTypes((long)integer));
    }

    @Test
    @WithSystemProperty(key="USE_MVCC", value="true")
    public void testIndexingWithIntegerKeyAndMVCC() throws Exception {
        this.test(Function.identity());
    }

    @Test
    @WithSystemProperty(key="USE_MVCC", value="true")
    public void testIndexingWithComplexKeyAndMVCC() throws Exception {
        this.test(integer -> new IgniteCacheUpdateSqlQuerySelfTest.AllTypes((long)integer));
    }

    @Test
    public void testMultipleIndexes() throws Exception {
        this.testMultipleIndexes(false);
    }

    @Test
    public void testMultipleIndexesWithParallelism() throws Exception {
        this.testMultipleIndexes(true);
    }

    private static String addParallelism(boolean addParallelism, String sql) {
        if (!addParallelism) {
            return sql;
        }
        return sql + " WITH \"PARALLELISM=2\"";
    }

    private void testMultipleIndexes(boolean parallelism) throws Exception {
        this.startGrid(0).cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = this.grid(0).cache("default");
        cache.query(new SqlFieldsQuery(IgnitePdsIndexingDefragmentationTest.addParallelism(parallelism, "CREATE TABLE TEST (ID INT PRIMARY KEY, VAL_INT INT, VAL_OBJ LONG)")));
        String cacheName = "SQL_default_TEST";
        cache.query(new SqlFieldsQuery("CREATE INDEX TEST_VAL_INT ON TEST(VAL_INT)"));
        cache.query(new SqlFieldsQuery("CREATE INDEX TEST_VAL_OBJ ON TEST(VAL_OBJ)"));
        for (int i = 0; i < 1500; ++i) {
            cache.query(new SqlFieldsQuery("INSERT INTO TEST VALUES (?, ?, ?)").setArgs(new Object[]{i, i, (long)i}));
        }
        cache.query(new SqlFieldsQuery("DELETE FROM TEST WHERE MOD(ID, 2) = 0"));
        IgnitePdsIndexingDefragmentationTest.createMaintenanceRecord((IgniteEx)this.grid(0), (String[])new String[]{"SQL_default_TEST"});
        CacheGroupContext grp = this.grid(0).context().cache().cacheGroup(CU.cacheId((String)"SQL_default_TEST"));
        this.forceCheckpoint();
        this.stopGrid(0);
        this.defragmentAndValidateSizesDecreasedAfterDefragmentation(0, new CacheGroupContext[]{grp});
        this.startGrid(0);
        cache = this.grid(0).cache("default");
        IgnitePdsIndexingDefragmentationTest.assertTrue((boolean)IgnitePdsIndexingDefragmentationTest.explainQuery(cache, "EXPLAIN SELECT * FROM TEST WHERE ID > 0").contains("_key_pk_proxy"));
        cache.query(new SqlFieldsQuery("SELECT * FROM TEST WHERE ID > 0")).getAll();
        IgnitePdsIndexingDefragmentationTest.assertTrue((boolean)IgnitePdsIndexingDefragmentationTest.explainQuery(cache, "EXPLAIN SELECT * FROM TEST WHERE VAL_INT > 0").contains("test_val_int"));
        cache.query(new SqlFieldsQuery("SELECT * FROM TEST WHERE VAL_INT > 0")).getAll();
        IgnitePdsIndexingDefragmentationTest.assertTrue((boolean)IgnitePdsIndexingDefragmentationTest.explainQuery(cache, "EXPLAIN SELECT * FROM TEST WHERE VAL_OBJ > 0").contains("test_val_obj"));
        cache.query(new SqlFieldsQuery("SELECT * FROM TEST WHERE VAL_OBJ > 0")).getAll();
    }

    @Test
    public void testDecimalIndex() throws Exception {
        this.testDecimalIndex(false);
    }

    @Test
    public void testDecimalIndexWithParallelism() throws Exception {
        this.testDecimalIndex(true);
    }

    private void testDecimalIndex(boolean parallelism) throws Exception {
        this.startGrid(0).cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = this.grid(0).cache("default");
        cache.query(new SqlFieldsQuery(IgnitePdsIndexingDefragmentationTest.addParallelism(parallelism, "CREATE TABLE TEST (ID INT PRIMARY KEY, VAL_INT INT, VAL_DEC DECIMAL)")));
        String cacheName = "SQL_default_TEST";
        cache.query(new SqlFieldsQuery("CREATE INDEX TEST_VAL_DEC ON TEST(VAL_DEC)"));
        for (int i = 0; i < 1500; ++i) {
            cache.query(new SqlFieldsQuery("INSERT INTO TEST VALUES (?, ?, ?)").setArgs(new Object[]{i, i, BigDecimal.valueOf(i)}));
        }
        cache.query(new SqlFieldsQuery("DELETE FROM TEST WHERE MOD(ID, 2) = 0"));
        IgnitePdsIndexingDefragmentationTest.createMaintenanceRecord((IgniteEx)this.grid(0), (String[])new String[]{"SQL_default_TEST"});
        CacheGroupContext grp = this.grid(0).context().cache().cacheGroup(CU.cacheId((String)"SQL_default_TEST"));
        this.forceCheckpoint();
        this.stopGrid(0);
        this.defragmentAndValidateSizesDecreasedAfterDefragmentation(0, new CacheGroupContext[]{grp});
        this.startGrid(0);
        cache = this.grid(0).cache("default");
        IgnitePdsIndexingDefragmentationTest.assertTrue((boolean)IgnitePdsIndexingDefragmentationTest.explainQuery(cache, "EXPLAIN SELECT * FROM TEST WHERE ID > 0").contains("_key_pk_proxy"));
        cache.query(new SqlFieldsQuery("SELECT * FROM TEST WHERE ID > 0")).getAll();
        IgnitePdsIndexingDefragmentationTest.assertTrue((boolean)IgnitePdsIndexingDefragmentationTest.explainQuery(cache, "EXPLAIN SELECT * FROM TEST WHERE VAL_DEC > 0").contains("test_val_dec"));
        cache.query(new SqlFieldsQuery("SELECT * FROM TEST WHERE VAL_DEC > 0")).getAll();
    }

    @Test
    public void testVarcharIndex() throws Exception {
        this.testVarcharIndex(false);
    }

    @Test
    public void testVarcharIndexWithParallelism() throws Exception {
        this.testVarcharIndex(true);
    }

    private void testVarcharIndex(boolean parallelism) throws Exception {
        String strPrefix = "AAAAAAAAAA";
        this.startGrid(0).cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = this.grid(0).cache("default");
        cache.query(new SqlFieldsQuery(IgnitePdsIndexingDefragmentationTest.addParallelism(parallelism, "CREATE TABLE TEST (ID INT PRIMARY KEY, VAL_INT INT, VAL_STR VARCHAR)")));
        String cacheName = "SQL_default_TEST";
        cache.query(new SqlFieldsQuery("CREATE INDEX TEST_VAL_STR ON TEST(VAL_STR)"));
        for (int i = 0; i < 1500; ++i) {
            cache.query(new SqlFieldsQuery("INSERT INTO TEST VALUES (?, ?, ?)").setArgs(new Object[]{i, i, "AAAAAAAAAA" + i}));
        }
        cache.query(new SqlFieldsQuery("DELETE FROM TEST WHERE MOD(ID, 2) = 0"));
        IgnitePdsIndexingDefragmentationTest.createMaintenanceRecord((IgniteEx)this.grid(0), (String[])new String[]{"SQL_default_TEST"});
        CacheGroupContext grp = this.grid(0).context().cache().cacheGroup(CU.cacheId((String)"SQL_default_TEST"));
        this.forceCheckpoint();
        this.stopGrid(0);
        this.defragmentAndValidateSizesDecreasedAfterDefragmentation(0, new CacheGroupContext[]{grp});
        this.startGrid(0);
        cache = this.grid(0).cache("default");
        IgnitePdsIndexingDefragmentationTest.assertTrue((boolean)IgnitePdsIndexingDefragmentationTest.explainQuery(cache, "EXPLAIN SELECT * FROM TEST WHERE VAL_STR = 'a'").contains("test_val_str"));
        List res = cache.query(new SqlFieldsQuery("SELECT * FROM TEST WHERE VAL_STR = ?").setArgs(new Object[]{"AAAAAAAAAA1"})).getAll();
        IgnitePdsIndexingDefragmentationTest.assertEquals((int)1, (int)res.size());
    }

    private static String explainQuery(IgniteCache<?, ?> cache, String qry) {
        return ((List)cache.query(new SqlFieldsQuery(qry)).getAll().get(0)).get(0).toString().toLowerCase();
    }

    public static class CaptureRebuildGridQueryIndexing
    extends IgniteH2Indexing {
        private volatile boolean rebuiltIndexes;

        public IgniteInternalFuture<?> rebuildIndexesFromHash(GridCacheContext cctx, boolean force) {
            IgniteInternalFuture future = super.rebuildIndexesFromHash(cctx, force);
            this.rebuiltIndexes = future != null;
            return future;
        }

        public boolean didRebuildIndexes() {
            return this.rebuiltIndexes;
        }
    }
}

