/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;

public class CacheMvccSqlConfigurationValidationTest
extends CacheMvccAbstractTest {
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    @Test
    public void testCacheGroupAtomicityModeMismatch1() throws Exception {
        IgniteEx node = this.startGrid();
        node.getOrCreateCache("default").query(new SqlFieldsQuery("CREATE TABLE City (id int primary key, name varchar, population int) WITH \"atomicity=transactional_snapshot,cache_group=group1,template=partitioned,backups=3,cache_name=City\"")).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>((Ignite)node){
            final /* synthetic */ Ignite val$node;
            {
                this.val$node = ignite;
            }

            @Override
            public Object call() throws Exception {
                this.val$node.cache("default").query(new SqlFieldsQuery("CREATE TABLE Person (id int primary key, name varchar) WITH \"atomicity=transactional,cache_group=group1,template=partitioned,backups=3,cache_name=Person\"")).getAll();
                return null;
            }
        }, CacheException.class, (String)"Atomicity mode mismatch for caches related to the same group");
    }

    @Test
    public void testCacheGroupAtomicityModeMismatch2() throws Exception {
        IgniteEx node = this.startGrid();
        node.getOrCreateCache("default").query(new SqlFieldsQuery("CREATE TABLE City (id int primary key, name varchar, population int) WITH \"atomicity=transactional,cache_group=group1,template=partitioned,backups=3,cache_name=City\""));
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>((Ignite)node){
            final /* synthetic */ Ignite val$node;
            {
                this.val$node = ignite;
            }

            @Override
            public Object call() throws Exception {
                this.val$node.cache("default").query(new SqlFieldsQuery("CREATE TABLE Person (id int primary key, name varchar) WITH \"atomicity=transactional_snapshot,cache_group=group1,template=partitioned,backups=3,cache_name=Person\"")).getAll();
                return null;
            }
        }, CacheException.class, (String)"Atomicity mode mismatch for caches related to the same group");
    }

    @Test
    public void testTxDifferentMvccSettingsTransactional() throws Exception {
        this.ccfg = CacheMvccSqlConfigurationValidationTest.defaultCacheConfiguration().setSqlSchema("PUBLIC");
        IgniteEx node = this.startGrid();
        IgniteCache cache = node.cache("default");
        cache.query(new SqlFieldsQuery("CREATE TABLE Person (id int primary key, name varchar) WITH \"atomicity=transactional_snapshot,template=partitioned,backups=1\"")).getAll();
        cache.query(new SqlFieldsQuery("CREATE TABLE City (id int primary key, name varchar, population int) WITH \"atomicity=transactional,template=partitioned,backups=3\"")).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>((Ignite)node, cache){
            final /* synthetic */ Ignite val$node;
            final /* synthetic */ IgniteCache val$cache;
            {
                this.val$node = ignite;
                this.val$cache = igniteCache;
            }

            @Override
            public Object call() throws Exception {
                try (Transaction tx = this.val$node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    this.val$cache.query(new SqlFieldsQuery("SELECT * FROM Person, City")).getAll();
                    tx.commit();
                }
                return null;
            }
        }, CacheException.class, (String)"Caches with transactional_snapshot atomicity mode cannot participate in the same transaction");
    }
}

