/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.sql.Connection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;

public class CacheMvccSelectForUpdateQueryTest
extends GridCommonAbstractTest {
    private static final int CACHE_SIZE = 10;

    protected void beforeTestsStarted() throws Exception {
        Ignite grid = this.startGridsMultiThreaded(2);
        try (Connection c = AbstractSchemaSelfTest.connect((IgniteEx)grid);){
            c.setAutoCommit(false);
            AbstractSchemaSelfTest.execute(c, "create table person (id int primary key, firstName varchar, lastName varchar) with \"atomicity=transactional_snapshot,cache_name=Person\"");
            AbstractSchemaSelfTest.execute(c, "create table person_nonMvcc (id int primary key, firstName varchar, lastName varchar) with \"atomicity=transactional,cache_name=Person_nonMvcc\"");
            try (Transaction tx = this.grid(0).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                for (int i = 1; i <= 10; ++i) {
                    AbstractSchemaSelfTest.execute(c, "insert into person(id, firstName, lastName) values(" + i + ",'firstName" + i + "','lastName" + i + "')");
                }
                tx.commit();
            }
        }
    }

    @Test
    public void testSelectForUpdateWithUnion() {
        this.assertQueryThrows("select id from person union select 1 for update", "SELECT UNION FOR UPDATE is not supported.");
    }

    @Test
    public void testSelectForUpdateWithMultipleStatements() {
        this.assertQueryThrows("select id from person for update; select firstName from person for update", "Multiple statements queries are not supported");
    }

    @Test
    public void testSelectForUpdateWithJoin() {
        this.assertQueryThrows("select p1.id from person p1 join person p2 on p1.id = p2.id for update", "SELECT FOR UPDATE with joins is not supported.");
    }

    @Test
    public void testSelectForUpdateWithLimit() {
        this.assertQueryThrows("select id from person limit 0,5 for update", "LIMIT/OFFSET clauses are not supported for SELECT FOR UPDATE.");
    }

    @Test
    public void testSelectForUpdateWithOffset() {
        this.assertQueryThrows("select id from person offset 10 for update", "LIMIT/OFFSET clauses are not supported for SELECT FOR UPDATE.");
    }

    @Test
    public void testSelectForUpdateWithDistinct() {
        this.assertQueryThrows("select distinct firstName from PERSON for update", "FOR UPDATE is not allowed in DISTINCT or grouped select;");
    }

    @Test
    public void testSelectForUpdateWithSubQuery() {
        this.assertQueryThrows("select id, firstName from PERSON where id = (SELECT COUNT(*) FROM person) for update", "Sub queries are not supported for SELECT FOR UPDATE.");
    }

    @Test
    public void testSelectForUpdateNonMvccCache() {
        this.assertQueryThrows("select id, firstName from person_nonMvcc for update", "SELECT FOR UPDATE query requires transactional cache with MVCC enabled.");
    }

    @Test
    public void testSelectForUpdateWithGroupings() {
        this.assertQueryThrows("select count(*) from person for update", "FOR UPDATE is not allowed in DISTINCT or grouped select;");
        this.assertQueryThrows("select lastName, count(*) from person group by lastName for update", "FOR UPDATE is not allowed in DISTINCT or grouped select;");
    }

    private void assertQueryThrows(String qry, String exMsg) {
        this.assertQueryThrows(qry, exMsg, false);
        this.assertQueryThrows(qry, exMsg, true);
    }

    private void assertQueryThrows(String qry, String exMsg, boolean loc) {
        IgniteEx node = this.grid(0);
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>((Ignite)node, qry, loc){
            final /* synthetic */ Ignite val$node;
            final /* synthetic */ String val$qry;
            final /* synthetic */ boolean val$loc;
            {
                this.val$node = ignite;
                this.val$qry = string;
                this.val$loc = bl;
            }

            @Override
            public Object call() {
                List r = this.val$node.cache("Person").query(new SqlFieldsQuery(this.val$qry).setLocal(this.val$loc)).getAll();
                return r;
            }
        }, IgniteSQLException.class, (String)exMsg);
    }
}

