/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.timeout.TimedQueryHelper;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheLocalQueryCancelOrTimeoutSelfTest
extends GridCommonAbstractTest {
    private static final int CACHE_SIZE = 1000;
    private static final String QUERY = "select a._val, b._val, longProcess(a._key, 5) from String a, String b";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, String.class}).setCacheMode(CacheMode.LOCAL).setSqlFunctionClasses(new Class[]{TimedQueryHelper.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("0"));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache("default");
        this.loadCache((IgniteCache<Integer, String>)cache);
    }

    private void loadCache(IgniteCache<Integer, String> cache) {
        int p = 1;
        HashMap<Integer, String> batch = new HashMap<Integer, String>();
        for (int i = 1; i <= 1000; ++i) {
            char[] tmp = new char[256];
            Arrays.fill(tmp, ' ');
            batch.put(i, new String(tmp));
            if (!((float)i / 1000.0f >= (float)p / 10.0f)) continue;
            cache.putAll(batch);
            batch.clear();
            this.log().info("Loaded " + i + " of " + 1000);
            ++p;
        }
        if (!F.isEmpty(batch)) {
            cache.putAll(batch);
        }
    }

    @Test
    public void testQueryCancel() {
        this.testQuery(false, 1, TimeUnit.SECONDS);
    }

    @Test
    public void testQueryCancelZeroTimeout() {
        this.testQuery(false, 1, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testQueryTimeout() {
        this.testQuery(true, 1, TimeUnit.SECONDS);
    }

    @Test
    public void testQueryCancelMultithreaded() throws Exception {
        GridTestUtils.runMultiThreaded(() -> {
            for (int i = 0; i < 20; ++i) {
                this.testQuery(false, 500, TimeUnit.MILLISECONDS);
            }
            return null;
        }, (int)20, (String)"local-cancel-test");
    }

    @Test
    public void testReadToEnd() throws Exception {
        FieldsQueryCursor cursor;
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache("default");
        SqlFieldsQueryEx qry = new SqlFieldsQueryEx("SELECT * FROM String AS A where A._key = 1", Boolean.valueOf(true));
        try (FieldsQueryCursor ignored = cursor = cache.query((SqlFieldsQuery)qry);){
            Iterator it = cursor.iterator();
            while (it.hasNext()) {
                it.next();
            }
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
                it.next();
                return null;
            }, NoSuchElementException.class, null);
        }
    }

    private void testQuery(boolean timeout, int timeoutUnits, TimeUnit timeUnit) {
        block17: {
            FieldsQueryCursor cursor;
            IgniteEx ignite = this.grid(0);
            IgniteCache cache = ignite.cache("default");
            SqlFieldsQueryEx qry = new SqlFieldsQueryEx(QUERY, Boolean.valueOf(true));
            if (timeout) {
                qry.setTimeout(timeoutUnits, timeUnit);
                cursor = cache.query((SqlFieldsQuery)qry);
            } else {
                cursor = cache.query((SqlFieldsQuery)qry);
                ignite.scheduler().runLocal(new Runnable((QueryCursor)cursor){
                    final /* synthetic */ QueryCursor val$cursor;
                    {
                        this.val$cursor = queryCursor;
                    }

                    @Override
                    public void run() {
                        this.val$cursor.close();
                    }
                }, (long)timeoutUnits, timeUnit);
            }
            try (FieldsQueryCursor ignored = cursor;){
                Iterator it = cursor.iterator();
                int cnt = 0;
                while (it.hasNext()) {
                    it.next();
                    ++cnt;
                }
                IgniteCacheLocalQueryCancelOrTimeoutSelfTest.fail((String)("Expecting timeout or cancel. Results size=" + cnt));
            }
            catch (Throwable e) {
                if (X.cause((Throwable)e, QueryCancelledException.class) != null) break block17;
                log.error("Unexpected exception", e);
                IgniteCacheLocalQueryCancelOrTimeoutSelfTest.fail((String)"Must throw correct exception");
            }
        }
    }
}

