/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GatewayProtectedCacheProxy;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionState;
import org.junit.Test;

public class SqlTransactionsSelfTest
extends AbstractSchemaSelfTest {
    private static final EntryProcessor<Integer, Integer, Object> ENTRY_PROC = new EntryProcessor<Integer, Integer, Object>(){

        public Object process(MutableEntry<Integer, Integer> entry, Object ... arguments) throws EntryProcessorException {
            return null;
        }
    };
    private static final CacheEntryProcessor<Integer, Integer, Object> CACHE_ENTRY_PROC = new CacheEntryProcessor<Integer, Integer, Object>(){

        public Object process(MutableEntry<Integer, Integer> entry, Object ... arguments) throws EntryProcessorException {
            return null;
        }
    };

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(this.commonConfiguration(0));
        super.execute((Ignite)this.node(), "CREATE TABLE INTS(k int primary key, v int) WITH \"wrap_value=false,cache_name=ints,atomicity=transactional_snapshot\"");
    }

    @Test
    public void testBegin() {
        this.execute((Ignite)this.node(), "BEGIN");
        this.assertTxPresent();
        SqlTransactionsSelfTest.assertTxState(this.tx(), TransactionState.ACTIVE);
    }

    @Test
    public void testCommit() {
        this.execute((Ignite)this.node(), "BEGIN WORK");
        this.assertTxPresent();
        Transaction tx = this.tx();
        SqlTransactionsSelfTest.assertTxState(tx, TransactionState.ACTIVE);
        this.execute((Ignite)this.node(), "COMMIT TRANSACTION");
        SqlTransactionsSelfTest.assertTxState(tx, TransactionState.COMMITTED);
        this.assertSqlTxNotPresent();
    }

    @Test
    public void testCommitNoTransaction() {
        this.execute((Ignite)this.node(), "COMMIT");
    }

    @Test
    public void testRollbackNoTransaction() {
        this.execute((Ignite)this.node(), "ROLLBACK");
    }

    @Test
    public void testRollback() {
        this.execute((Ignite)this.node(), "BEGIN TRANSACTION");
        this.assertTxPresent();
        Transaction tx = this.tx();
        SqlTransactionsSelfTest.assertTxState(tx, TransactionState.ACTIVE);
        this.execute((Ignite)this.node(), "ROLLBACK TRANSACTION");
        SqlTransactionsSelfTest.assertTxState(tx, TransactionState.ROLLED_BACK);
        this.assertSqlTxNotPresent();
    }

    @Test
    public void testSqlOperationsWithinNonSqlTransaction() {
        this.assertSqlOperationWithinNonSqlTransactionThrows("COMMIT");
        this.assertSqlOperationWithinNonSqlTransactionThrows("ROLLBACK");
        this.assertSqlOperationWithinNonSqlTransactionThrows("SELECT * from ints");
        this.assertSqlOperationWithinNonSqlTransactionThrows("DELETE from ints");
        this.assertSqlOperationWithinNonSqlTransactionThrows("INSERT INTO ints(k, v) values(10, 15)");
        this.assertSqlOperationWithinNonSqlTransactionThrows("MERGE INTO ints(k, v) values(10, 15)");
        this.assertSqlOperationWithinNonSqlTransactionThrows("UPDATE ints SET v = 100 WHERE k = 5");
        this.assertSqlOperationWithinNonSqlTransactionThrows("create index idx on ints(v)");
        this.assertSqlOperationWithinNonSqlTransactionThrows("CREATE TABLE T(k int primary key, v int)");
    }

    private void assertSqlOperationWithinNonSqlTransactionThrows(final String sql) {
        try (Transaction ignored = this.node().transactions().txStart();){
            this.node().cache("ints").put((Object)1, (Object)1);
            SqlTransactionsSelfTest.assertSqlException(new Runnable(){

                @Override
                public void run() {
                    SqlTransactionsSelfTest.this.execute((Ignite)SqlTransactionsSelfTest.this.node(), sql);
                }
            }, 5003);
        }
        ignored = this.node().transactions().txStart();
        var3_3 = null;
        try {
            this.node().cache("ints").put((Object)1, (Object)1);
            SqlTransactionsSelfTest.assertSqlException(new Runnable(){

                @Override
                public void run() {
                    SqlTransactionsSelfTest.this.node().cache("ints").query(new SqlFieldsQuery(sql).setLocal(true)).getAll();
                }
            }, 5003);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (var3_3 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCacheOperationThrows(final String opName, final Object ... args) {
        this.execute((Ignite)this.node(), "BEGIN");
        try {
            GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        Class[] types;
                        if (F.isEmpty((Object[])args)) {
                            types = (Class[])X.EMPTY_OBJECT_ARRAY;
                        } else {
                            types = new Class[args.length];
                            for (int i = 0; i < args.length; ++i) {
                                types[i] = SqlTransactionsSelfTest.argTypeForObject(args[i]);
                            }
                        }
                        Object res = U.invoke(GatewayProtectedCacheProxy.class, (Object)SqlTransactionsSelfTest.this.node().cache("ints"), (String)opName, (Class[])types, (Object[])args);
                        if (opName.endsWith("Async")) {
                            ((IgniteFuture)res).get();
                        }
                    }
                    catch (IgniteCheckedException e) {
                        if (e.getCause() != null) {
                            try {
                                if (e.getCause().getCause() != null) {
                                    throw (Exception)e.getCause().getCause();
                                }
                                SqlTransactionsSelfTest.fail();
                            }
                            catch (IgniteException e1) {
                                if (e1.getCause() != null) {
                                    throw (Exception)e1.getCause();
                                }
                                SqlTransactionsSelfTest.fail();
                            }
                        }
                        SqlTransactionsSelfTest.fail();
                    }
                    return null;
                }
            }, IgniteCheckedException.class, (String)"SQL queries and cache operations may not be used in the same transaction.");
        }
        finally {
            try {
                this.execute((Ignite)this.node(), "ROLLBACK");
            }
            catch (Throwable throwable) {}
        }
    }

    private static Class<?> argTypeForObject(Object arg) {
        if (arg instanceof Set) {
            return Set.class;
        }
        if (arg instanceof Map) {
            return Map.class;
        }
        if (arg.getClass().getName().startsWith("java.lang.")) {
            return Object.class;
        }
        if (arg instanceof CacheEntryProcessor) {
            return CacheEntryProcessor.class;
        }
        if (arg instanceof EntryProcessor) {
            return EntryProcessor.class;
        }
        return arg.getClass();
    }

    @Test
    public void testCacheOperationsFromSqlTransaction() {
        this.checkCacheOperationThrows("get", 1);
        this.checkCacheOperationThrows("getAsync", 1);
        this.checkCacheOperationThrows("getEntry", 1);
        this.checkCacheOperationThrows("getEntryAsync", 1);
        this.checkCacheOperationThrows("getAndPut", 1, 1);
        this.checkCacheOperationThrows("getAndPutAsync", 1, 1);
        this.checkCacheOperationThrows("getAndPutIfAbsent", 1, 1);
        this.checkCacheOperationThrows("getAndPutIfAbsentAsync", 1, 1);
        this.checkCacheOperationThrows("getAndReplace", 1, 1);
        this.checkCacheOperationThrows("getAndReplaceAsync", 1, 1);
        this.checkCacheOperationThrows("getAndRemove", 1);
        this.checkCacheOperationThrows("getAndRemoveAsync", 1);
        this.checkCacheOperationThrows("containsKey", 1);
        this.checkCacheOperationThrows("containsKeyAsync", 1);
        this.checkCacheOperationThrows("put", 1, 1);
        this.checkCacheOperationThrows("putAsync", 1, 1);
        this.checkCacheOperationThrows("putIfAbsent", 1, 1);
        this.checkCacheOperationThrows("putIfAbsentAsync", 1, 1);
        this.checkCacheOperationThrows("remove", 1);
        this.checkCacheOperationThrows("removeAsync", 1);
        this.checkCacheOperationThrows("remove", 1, 1);
        this.checkCacheOperationThrows("removeAsync", 1, 1);
        this.checkCacheOperationThrows("replace", 1, 1);
        this.checkCacheOperationThrows("replaceAsync", 1, 1);
        this.checkCacheOperationThrows("replace", 1, 1, 1);
        this.checkCacheOperationThrows("replaceAsync", 1, 1, 1);
        this.checkCacheOperationThrows("getAll", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("containsKeys", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("getEntries", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("putAll", Collections.singletonMap(1, 1));
        this.checkCacheOperationThrows("removeAll", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("getAllAsync", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("containsKeysAsync", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("getEntriesAsync", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("putAllAsync", Collections.singletonMap(1, 1));
        this.checkCacheOperationThrows("removeAllAsync", new HashSet<Integer>(Arrays.asList(1, 2)));
        this.checkCacheOperationThrows("invoke", 1, ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invoke", 1, CACHE_ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAsync", 1, ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAsync", 1, CACHE_ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAll", Collections.singletonMap(1, CACHE_ENTRY_PROC), X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAll", Collections.singleton(1), CACHE_ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAll", Collections.singleton(1), ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAllAsync", Collections.singletonMap(1, CACHE_ENTRY_PROC), X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAllAsync", Collections.singleton(1), CACHE_ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
        this.checkCacheOperationThrows("invokeAllAsync", Collections.singleton(1), ENTRY_PROC, X.EMPTY_OBJECT_ARRAY);
    }

    private IgniteEx node() {
        return this.grid(0);
    }

    private Transaction tx() {
        return this.node().transactions().tx();
    }

    private void assertTxPresent() {
        SqlTransactionsSelfTest.assertNotNull((Object)this.tx());
    }

    @Override
    protected List<List<?>> execute(Ignite node, String sql) {
        return node.cache("ints").query(new SqlFieldsQuery(sql).setSchema("PUBLIC")).getAll();
    }

    private void assertSqlTxNotPresent() {
        SqlTransactionsSelfTest.assertNull((Object)this.tx());
    }

    private static void assertTxState(Transaction tx, TransactionState state) {
        SqlTransactionsSelfTest.assertEquals((Object)state, (Object)tx.state());
    }
}

