/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.ArrayList;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.DynamicEnableIndexingAbstractTest;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DynamicEnableIndexingBasicSelfTest
extends DynamicEnableIndexingAbstractTest {
    @Parameterized.Parameter(value=0)
    public Boolean hasNear;
    @Parameterized.Parameter(value=1)
    public int nodeIdx;
    @Parameterized.Parameter(value=2)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=3)
    public CacheAtomicityMode atomicityMode;

    @Parameterized.Parameters(name="hasNear={0},nodeIdx={1},cacheMode={2},atomicityMode={3}")
    public static Iterable<Object[]> params() {
        int[] opNodes = new int[]{2, 0, 1, 3};
        CacheMode[] cacheModes = new CacheMode[]{CacheMode.PARTITIONED, CacheMode.REPLICATED};
        CacheAtomicityMode[] atomicityModes = new CacheAtomicityMode[]{CacheAtomicityMode.ATOMIC, CacheAtomicityMode.TRANSACTIONAL, CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT};
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        for (int node : opNodes) {
            for (CacheMode cacheMode : cacheModes) {
                for (CacheAtomicityMode atomicityMode : atomicityModes) {
                    res.add(new Object[]{true, node, cacheMode, atomicityMode});
                    if (atomicityMode == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
                    res.add(new Object[]{false, node, cacheMode, atomicityMode});
                }
            }
        }
        return res;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        for (IgniteConfiguration cfg : this.configurations()) {
            this.startGrid(cfg);
        }
        this.node().cluster().state(ClusterState.ACTIVE);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        CacheConfiguration<?, ?> ccfg = this.testCacheConfiguration("poi", this.cacheMode, this.atomicityMode);
        if (this.hasNear.booleanValue() && this.atomicityMode != CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            ccfg.setNearConfiguration(new NearCacheConfiguration());
        }
        this.node().getOrCreateCache(ccfg);
        this.awaitPartitionMapExchange();
        if (this.atomicityMode != CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            this.grid(4).getOrCreateNearCache("poi", new NearCacheConfiguration());
        }
    }

    protected void afterTest() throws Exception {
        this.node().destroyCache("poi");
        super.afterTest();
    }

    @Test
    public void testEnableDynamicIndexing() throws Exception {
        this.loadData(this.node(), 0, 500);
        this.createTable();
        this.grid(0).cache("poi").indexReadyFuture().get();
        this.loadData(this.node(), 500, 1000);
        for (Ignite ig : G.allGrids()) {
            DynamicEnableIndexingBasicSelfTest.assertEquals((int)1000, (int)this.query(ig, SELECT_ALL_QUERY).size());
            this.performQueryingIntegrityCheck(ig);
            this.checkQueryParallelism((IgniteEx)ig, this.cacheMode);
        }
    }

    private void createTable() {
        if (this.cacheMode == CacheMode.REPLICATED) {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.createTable(this.node().cache("poi"), 4), CacheException.class, (String)"Segmented indices are supported for PARTITIONED mode only.");
            this.createTable(this.node().cache("poi"), 1);
        } else {
            this.createTable(this.node().cache("poi"), 4);
        }
    }

    private IgniteEx node() {
        return this.grid(this.nodeIdx);
    }
}

