/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.util.CloseWatcher;

public class AbstractIndexingCommonTest
extends GridCommonAbstractTest {
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.checkAllConnectionAreClosed();
        super.afterTestsStopped();
    }

    void checkAllConnectionAreClosed() {
        Set refs = (Set)GridTestUtils.getFieldValue(CloseWatcher.class, (String[])new String[]{"refs"});
        if (!refs.isEmpty()) {
            for (Object o : refs) {
                if (!(o instanceof CloseWatcher) || !(((CloseWatcher)o).getCloseable() instanceof Session)) continue;
                log.error("Session: " + ((CloseWatcher)o).getCloseable() + ", open=" + !((Session)((CloseWatcher)o).getCloseable()).isClosed());
            }
            AbstractIndexingCommonTest.fail((String)"There are not closed connections. See the log above.");
        }
    }

    protected List<Path> getIndexBinPaths(String cacheName) {
        return G.allGrids().stream().map(grid -> (IgniteEx)grid).map(grid -> {
            IgniteInternalCache cachex = grid.cachex(cacheName);
            AbstractIndexingCommonTest.assertNotNull((Object)cachex);
            FilePageStoreManager pageStoreMgr = (FilePageStoreManager)cachex.context().shared().pageStore();
            AbstractIndexingCommonTest.assertNotNull((Object)pageStoreMgr);
            File cacheWorkDir = pageStoreMgr.cacheWorkDir(cachex.configuration());
            return cacheWorkDir.toPath().resolve("index.bin");
        }).collect(Collectors.toList());
    }

    protected void checkThereAreNotUsedConnections() throws Exception {
        boolean notLeak = GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                for (Ignite ign : G.allGrids()) {
                    if (AbstractIndexingCommonTest.this.usedConnections(ign).isEmpty()) continue;
                    return false;
                }
                return true;
            }
        }, (long)5000L);
        if (!notLeak) {
            for (Ignite ign : G.allGrids()) {
                Set<H2PooledConnection> usedConns = this.usedConnections(ign);
                if (this.usedConnections(ign).isEmpty()) continue;
                log.error("Not closed connections: " + usedConns);
            }
            AbstractIndexingCommonTest.fail((String)"H2 JDBC connections leak detected. See the log above.");
        }
    }

    private Set<H2PooledConnection> usedConnections(Ignite ign) {
        ConnectionManager connMgr = ((IgniteH2Indexing)((IgniteEx)ign).context().query().getIndexing()).connections();
        return (Set)GridTestUtils.getFieldValue((Object)connMgr, (String[])new String[]{"usedConns"});
    }

    public static class BlockingIndexing
    extends IgniteH2Indexing {
        private final Map<String, CountDownLatch> latches = new ConcurrentHashMap<String, CountDownLatch>();

        protected void rebuildIndexesFromHash0(final GridCacheContext cctx, SchemaIndexCacheVisitorClosure clo, GridFutureAdapter<Void> rebuildIdxFut, SchemaIndexOperationCancellationToken cancel) {
            CountDownLatch startThread = new CountDownLatch(1);
            new Thread(() -> {
                startThread.countDown();
                new SchemaIndexCacheVisitorImpl(cctx, cancel, rebuildIdxFut){

                    protected void beforeExecute() {
                        String cacheName = cctx.name();
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Before execute build idx for cache=" + cacheName);
                        }
                        IgniteUtils.awaitQuiet((CountDownLatch)latches.computeIfAbsent(cacheName, l -> new CountDownLatch(1)));
                    }
                }.visit(clo);
            }).start();
            IgniteUtils.awaitQuiet((CountDownLatch)startThread);
        }

        public boolean isBlock(String cacheName) {
            return this.latches.containsKey(cacheName) && this.latches.get(cacheName).getCount() != 0L;
        }

        public void stopBlock(String cacheName) {
            this.latches.computeIfAbsent(cacheName, l -> new CountDownLatch(1)).countDown();
        }
    }
}

