/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheAbstractSelfTest;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.junit.Test;

public class IgniteCacheQueryNodeRestartSelfTest
extends GridCacheAbstractSelfTest {
    private static final int GRID_CNT = 3;
    private static final int KEY_CNT = 1000;

    protected int gridCount() {
        return 3;
    }

    protected long getTestTimeout() {
        return 180000L;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        c.setConsistentId((Serializable)((Object)igniteInstanceName));
        CacheConfiguration cc = IgniteCacheQueryNodeRestartSelfTest.defaultCacheConfiguration();
        cc.setCacheMode(CacheMode.PARTITIONED);
        cc.setBackups(1);
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cc.setRebalanceMode(CacheRebalanceMode.SYNC);
        cc.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 15));
        cc.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        c.setCacheConfiguration(new CacheConfiguration[]{cc});
        c.setIncludeEventTypes(EventType.EVTS_ALL);
        return c;
    }

    @Test
    public void testRestarts() throws Exception {
        int duration = 60000;
        int qryThreadNum = 10;
        int logFreq = 50;
        final IgniteCache cache = this.grid(0).cache("default");
        this.grid(0).cluster().baselineAutoAdjustEnabled(false);
        assert (cache != null);
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        IgniteCacheQueryNodeRestartSelfTest.assertEquals((int)1000, (int)cache.size(new CachePeekMode[0]));
        final AtomicInteger qryCnt = new AtomicInteger();
        final AtomicBoolean done = new AtomicBoolean();
        IgniteInternalFuture fut1 = this.multithreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                while (!done.get()) {
                    List res = cache.query((Query)new SqlQuery(Integer.class, "true")).getAll();
                    HashSet<Object> keys = new HashSet<Object>();
                    for (Cache.Entry entry : res) {
                        keys.add(entry.getKey());
                    }
                    if (1000 > keys.size()) {
                        for (int i = 0; i < 1000; ++i) {
                            if (keys.contains(i)) continue;
                            IgniteCacheQueryNodeRestartSelfTest.assertEquals((Object)i, (Object)cache.get((Object)i));
                        }
                        IgniteCacheQueryNodeRestartSelfTest.fail((String)("res size: " + res.size()));
                    }
                    IgniteCacheQueryNodeRestartSelfTest.assertEquals((int)1000, (int)keys.size());
                    int c = qryCnt.incrementAndGet();
                    if (c % 50 != 0) continue;
                    IgniteCacheQueryNodeRestartSelfTest.this.info("Executed queries: " + c);
                }
            }
        }, qryThreadNum, "query-thread");
        AtomicInteger restartCnt = new AtomicInteger();
        CollectingEventListener lsnr = new CollectingEventListener();
        for (int i = 0; i < 3; ++i) {
            this.grid(i).events().localListen((IgnitePredicate)lsnr, new int[]{81});
        }
        IgniteInternalFuture fut2 = this.createRestartAction(done, restartCnt);
        Thread.sleep(duration);
        this.info("Stopping..");
        done.set(true);
        fut2.get();
        this.info("Restarts stopped.");
        fut1.get();
        this.info("Queries stopped.");
        this.info("Awaiting rebalance events [restartCnt=" + restartCnt.get() + ']');
        boolean success = lsnr.awaitEvents(this.countRebalances(3, restartCnt.get()), 15000L);
        for (int i = 0; i < 3; ++i) {
            this.grid(i).events().stopLocalListen((IgnitePredicate)lsnr, new int[]{81});
        }
        assert (success);
    }

    protected int countRebalances(int nodes, int restarts) {
        return nodes * restarts;
    }

    protected IgniteInternalFuture createRestartAction(final AtomicBoolean done, final AtomicInteger restartCnt) throws Exception {
        return this.multithreadedAsync(new Callable<Object>(){
            private final int logFreq = 50;

            @Override
            public Object call() throws Exception {
                while (!done.get()) {
                    int idx = 3;
                    IgniteCacheQueryNodeRestartSelfTest.this.startGrid(idx);
                    IgniteCacheQueryNodeRestartSelfTest.this.resetBaselineTopology();
                    IgniteCacheQueryNodeRestartSelfTest.this.stopGrid(idx);
                    IgniteCacheQueryNodeRestartSelfTest.this.resetBaselineTopology();
                    int c = restartCnt.incrementAndGet();
                    if (c % 50 != 0) continue;
                    IgniteCacheQueryNodeRestartSelfTest.this.info("Node restarts: " + c);
                }
                return true;
            }
        }, 1, "restart-thread");
    }

    private class CollectingEventListener
    implements IgnitePredicate<Event> {
        private int evtCnt;

        private CollectingEventListener() {
        }

        public synchronized boolean apply(Event evt) {
            ++this.evtCnt;
            IgniteCacheQueryNodeRestartSelfTest.this.info("Processed event [evt=" + evt + ", evtCnt=" + this.evtCnt + ']');
            this.notifyAll();
            return true;
        }

        public synchronized boolean awaitEvents(int cnt, long timeout) throws InterruptedException {
            long start;
            long now = start = U.currentTimeMillis();
            while (start + timeout > now) {
                if (this.evtCnt >= cnt) {
                    return true;
                }
                this.wait(start + timeout - now);
                now = U.currentTimeMillis();
            }
            return false;
        }
    }
}

