/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractQuerySelfTest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryRequest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryResponse;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.junit.Test;

public class IgniteCachePartitionedQuerySelfTest
extends IgniteCacheAbstractQuerySelfTest {
    @Override
    protected int gridCount() {
        return 3;
    }

    @Override
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setCommunicationSpi((CommunicationSpi)new TestTcpCommunicationSpi());
    }

    @Test
    public void testFieldsQuery() throws Exception {
        IgniteCacheAbstractQuerySelfTest.Person p1 = new IgniteCacheAbstractQuerySelfTest.Person("Jon", 1500);
        IgniteCacheAbstractQuerySelfTest.Person p2 = new IgniteCacheAbstractQuerySelfTest.Person("Jane", 2000);
        IgniteCacheAbstractQuerySelfTest.Person p3 = new IgniteCacheAbstractQuerySelfTest.Person("Mike", 1800);
        IgniteCacheAbstractQuerySelfTest.Person p4 = new IgniteCacheAbstractQuerySelfTest.Person("Bob", 1900);
        IgniteCache<UUID, IgniteCacheAbstractQuerySelfTest.Person> cache0 = this.jcache(UUID.class, IgniteCacheAbstractQuerySelfTest.Person.class);
        cache0.put((Object)p1.id(), (Object)p1);
        cache0.put((Object)p2.id(), (Object)p2);
        cache0.put((Object)p3.id(), (Object)p3);
        cache0.put((Object)p4.id(), (Object)p4);
        IgniteCachePartitionedQuerySelfTest.assertEquals((int)4, (int)cache0.localSize(new CachePeekMode[]{CachePeekMode.ALL}));
        FieldsQueryCursor qry = cache0.query(new SqlFieldsQuery("select name from Person where salary > ?").setArgs(new Object[]{1600}));
        List res = qry.getAll();
        IgniteCachePartitionedQuerySelfTest.assertEquals((int)3, (int)res.size());
        qry = cache0.query(new SqlFieldsQuery("select count(*) from Person"));
        res = qry.getAll();
        int cnt = 0;
        for (List row : res) {
            cnt = (int)((long)cnt + (Long)row.get(0));
        }
        IgniteCachePartitionedQuerySelfTest.assertEquals((int)4, (int)cnt);
    }

    @Test
    public void testMultipleNodesQuery() throws Exception {
        IgniteCacheAbstractQuerySelfTest.Person p1 = new IgniteCacheAbstractQuerySelfTest.Person("Jon", 1500);
        IgniteCacheAbstractQuerySelfTest.Person p2 = new IgniteCacheAbstractQuerySelfTest.Person("Jane", 2000);
        IgniteCacheAbstractQuerySelfTest.Person p3 = new IgniteCacheAbstractQuerySelfTest.Person("Mike", 1800);
        IgniteCacheAbstractQuerySelfTest.Person p4 = new IgniteCacheAbstractQuerySelfTest.Person("Bob", 1900);
        IgniteCache<UUID, IgniteCacheAbstractQuerySelfTest.Person> cache0 = this.jcache(UUID.class, IgniteCacheAbstractQuerySelfTest.Person.class);
        cache0.put((Object)p1.id(), (Object)p1);
        cache0.put((Object)p2.id(), (Object)p2);
        cache0.put((Object)p3.id(), (Object)p3);
        cache0.put((Object)p4.id(), (Object)p4);
        IgniteCachePartitionedQuerySelfTest.assertEquals((int)4, (int)cache0.localSize(new CachePeekMode[]{CachePeekMode.ALL}));
        assert (this.grid(0).cluster().nodes().size() == this.gridCount());
        QueryCursor qry = cache0.query((Query)new SqlQuery(IgniteCacheAbstractQuerySelfTest.Person.class, "salary < 2000"));
        List entries = qry.getAll();
        assert (entries != null);
        this.info("Queried entries: " + entries);
        IgniteCachePartitionedQuerySelfTest.assertEquals((int)this.gridCount(), (int)entries.size());
        this.checkResult(entries, p1, p3, p4);
    }

    private void checkResult(Iterable<Cache.Entry<UUID, IgniteCacheAbstractQuerySelfTest.Person>> entries, IgniteCacheAbstractQuerySelfTest.Person ... persons) {
        for (Cache.Entry<UUID, IgniteCacheAbstractQuerySelfTest.Person> entry : entries) {
            IgniteCachePartitionedQuerySelfTest.assertEquals((Object)entry.getKey(), (Object)((IgniteCacheAbstractQuerySelfTest.Person)entry.getValue()).id());
            assert (F.asList((Object[])persons).contains(entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanQueryPagination() throws Exception {
        int pageSize = 5;
        final AtomicInteger pages = new AtomicInteger(0);
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        for (int i = 0; i < 50; ++i) {
            cache.put((Object)i, (Object)i);
        }
        CommunicationSpi spi = this.ignite().configuration().getCommunicationSpi();
        assert (spi instanceof TestTcpCommunicationSpi);
        TestTcpCommunicationSpi commSpi = (TestTcpCommunicationSpi)spi;
        commSpi.filter = new IgniteInClosure<Message>(){

            public void apply(Message msg) {
                if (!(msg instanceof GridIoMessage)) {
                    return;
                }
                Message msg0 = ((GridIoMessage)msg).message();
                if (msg0 instanceof GridCacheQueryRequest) {
                    IgniteCachePartitionedQuerySelfTest.assertEquals((int)5, (int)((GridCacheQueryRequest)msg0).pageSize());
                    pages.incrementAndGet();
                } else if (msg0 instanceof GridCacheQueryResponse) {
                    IgniteCachePartitionedQuerySelfTest.assertTrue((boolean)(((GridCacheQueryResponse)msg0).data().size() <= 5));
                }
            }
        };
        try {
            ScanQuery qry = new ScanQuery();
            qry.setPageSize(5);
            List all = cache.query((Query)qry).getAll();
            IgniteCachePartitionedQuerySelfTest.assertTrue((pages.get() > this.ignite().cluster().forDataNodes("default").nodes().size() ? 1 : 0) != 0);
            IgniteCachePartitionedQuerySelfTest.assertEquals((int)50, (int)all.size());
        }
        finally {
            commSpi.filter = null;
        }
    }

    private static class TestTcpCommunicationSpi
    extends TcpCommunicationSpi {
        volatile IgniteInClosure<Message> filter;

        private TestTcpCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
            if (this.filter != null) {
                this.filter.apply((Object)msg);
            }
            super.sendMessage(node, msg, ackC);
        }
    }
}

