/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.processor;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationResult;
import org.apache.ignite.internal.processors.cache.checker.processor.PartitionReconciliationAbstractTest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartitionReconciliationTombstonesWithIndicesTest
extends PartitionReconciliationAbstractTest {
    protected static final int NODES_CNT = 3;
    private static final String CUSTOM_KEY_CLS = "org.apache.ignite.tests.p2p.ReconciliationCustomKey";
    private static final String CUSTOM_VAL_CLS = "org.apache.ignite.tests.p2p.ReconciliationCustomValue";
    @Parameterized.Parameter(value=0)
    public CacheAtomicityMode cacheAtomicityMode;
    @Parameterized.Parameter(value=1)
    public boolean fixMode;

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName("default");
        ccfg.setAtomicityMode(this.cacheAtomicityMode);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1));
        ccfg.setBackups(2);
        ccfg.setReadFromBackup(true);
        ccfg.setIndexedTypes(new Class[]{PartitionReconciliationTombstonesWithIndicesTest.getExternalClassLoader().loadClass(CUSTOM_KEY_CLS), PartitionReconciliationTombstonesWithIndicesTest.getExternalClassLoader().loadClass(CUSTOM_VAL_CLS)});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        cfg.setConsistentId((Serializable)((Object)name));
        cfg.setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        cfg.setClassLoader(PartitionReconciliationTombstonesWithIndicesTest.getExternalClassLoader());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Parameterized.Parameters(name="atomicity = {0}, repair = {1}")
    public static List<Object[]> parameters() {
        CacheAtomicityMode[] atomicityModes;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (CacheAtomicityMode atomicityMode : atomicityModes = new CacheAtomicityMode[]{CacheAtomicityMode.ATOMIC, CacheAtomicityMode.TRANSACTIONAL}) {
            params.add(new Object[]{atomicityMode, false});
            params.add(new Object[]{atomicityMode, true});
        }
        return params;
    }

    @Test
    @WithSystemProperty(key="DEFAULT_TOMBSTONE_TTL", value="300000000")
    public void testTombstones() throws Exception {
        Throwable throwable;
        Transaction tx;
        Object val;
        int i;
        IgniteEx ig = this.startGrids(3);
        IgniteEx client = this.startClientGrid(3);
        ig.cluster().state(ClusterState.ACTIVE);
        Class<?> customKeyCls = ig.configuration().getClassLoader().loadClass(CUSTOM_KEY_CLS);
        Class<?> customValCls = ig.configuration().getClassLoader().loadClass(CUSTOM_VAL_CLS);
        Constructor<?> keyCtor = customKeyCls.getDeclaredConstructor(Integer.TYPE);
        IgniteCache clientCache = client.cache("default");
        Object primaryKey = keyCtor.newInstance(42);
        Object primaryVal = customValCls.newInstance();
        int primaryNodeIdx = -1;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!this.grid(i2).affinity("default").isPrimary(this.grid(i2).localNode(), primaryKey)) continue;
            primaryNodeIdx = i2;
            break;
        }
        PartitionReconciliationTombstonesWithIndicesTest.assertTrue((String)("Failed to find primary node for key [key=" + primaryKey + ']'), (primaryNodeIdx >= 0 ? 1 : 0) != 0);
        clientCache.put(primaryKey, primaryVal);
        AtomicInteger blocked = new AtomicInteger(2);
        TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)this.grid(primaryNodeIdx));
        spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            boolean blockedMsg = this.cacheAtomicityMode == CacheAtomicityMode.ATOMIC ? msg instanceof GridDhtAtomicSingleUpdateRequest : msg instanceof GridDhtTxFinishRequest;
            return blockedMsg && blocked.decrementAndGet() >= 0;
        });
        int pNodeIdx = primaryNodeIdx;
        IgniteInternalFuture removeFut = GridTestUtils.runAsync(() -> this.grid(pNodeIdx).cache("default").remove(primaryKey));
        PartitionReconciliationTombstonesWithIndicesTest.assertTrue((String)"Failed to wait all update messages that are sent to backup nodes.", (boolean)GridTestUtils.waitForCondition(() -> blocked.get() == 0, (long)10000L));
        ReconciliationResult res = PartitionReconciliationTombstonesWithIndicesTest.partitionReconciliation((Ignite)ig, (boolean)this.fixMode, (RepairAlgorithm)RepairAlgorithm.PRIMARY, (int)4, (String[])new String[]{"default"});
        PartitionReconciliationTombstonesWithIndicesTest.assertTrue((String)("unexpected error [errs=" + res.errors() + ']'), (boolean)res.errors().isEmpty());
        PartitionReconciliationTombstonesWithIndicesTest.assertEquals((String)"Unexpected number of inconsistent keys.", (int)1, (int)res.partitionReconciliationResult().inconsistentKeysCount());
        if (this.fixMode) {
            for (i = 0; i < 3; ++i) {
                if (this.cacheAtomicityMode == CacheAtomicityMode.ATOMIC) {
                    val = this.grid(i).cache("default").get(primaryKey);
                } else {
                    tx = this.grid(i).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.SERIALIZABLE);
                    throwable = null;
                    try {
                        val = this.grid(i).cache("default").get(primaryKey);
                        tx.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
                PartitionReconciliationTombstonesWithIndicesTest.assertNull((String)("Unexpected value on node [actualVal=" + val + ", nodeId=" + i + ']'), (Object)val);
            }
        }
        spi.stopBlock();
        removeFut.get(5L, TimeUnit.SECONDS);
        PartitionReconciliationTombstonesWithIndicesTest.doSleep((long)1000L);
        for (i = 0; i < 3; ++i) {
            if (this.cacheAtomicityMode == CacheAtomicityMode.ATOMIC) {
                val = this.grid(i).cache("default").get(primaryKey);
            } else {
                tx = this.grid(i).transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.SERIALIZABLE);
                throwable = null;
                try {
                    val = this.grid(i).cache("default").get(primaryKey);
                    tx.commit();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            PartitionReconciliationTombstonesWithIndicesTest.assertNull((String)("Unexpected value on node [actualVal=" + val + ", nodeId=" + i + ']'), (Object)val);
        }
    }
}

