/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheQueryLoadSelfTest
extends GridCommonAbstractTest {
    private static final int PUT_CNT = 10;
    private static final Map<Integer, ValueObject> STORE_MAP = new HashMap<Integer, ValueObject>();

    public IgniteCacheQueryLoadSelfTest() {
        super(true);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = IgniteCacheQueryLoadSelfTest.defaultCacheConfiguration();
        ccfg.setCacheMode(CacheMode.REPLICATED);
        ccfg.setCacheStoreFactory(IgniteCacheQueryLoadSelfTest.singletonFactory((Object)((Object)new TestStore())));
        ccfg.setReadThrough(true);
        ccfg.setWriteThrough(true);
        ccfg.setLoadPreviousValue(true);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setIndexedTypes(new Class[]{Integer.class, ValueObject.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.jcache().removeAll();
        assert (this.jcache().localSize(new CachePeekMode[0]) == 0);
        assert (this.size(ValueObject.class) == 0L);
        STORE_MAP.clear();
    }

    private long size(Class<?> cls) throws IgniteCheckedException {
        return (Long)((List)this.grid().cache("default").query(new SqlFieldsQuery("select count(*) from " + QueryUtils.typeName(cls)).setLocal(true)).getAll().get(0)).get(0);
    }

    @Test
    public void testLoadCache() throws Exception {
        IgniteCache cache = this.grid().cache("default");
        cache.loadCache(null, new Object[0]);
        IgniteCacheQueryLoadSelfTest.assertEquals((int)10, (int)cache.size(new CachePeekMode[0]));
        List res = cache.query((Query)new SqlQuery(ValueObject.class, "val >= 0")).getAll();
        IgniteCacheQueryLoadSelfTest.assertNotNull((Object)res);
        IgniteCacheQueryLoadSelfTest.assertEquals((int)10, (int)res.size());
        IgniteCacheQueryLoadSelfTest.assertEquals((long)10L, (long)this.size(ValueObject.class));
    }

    @Test
    public void testLoadCacheAsync() throws Exception {
        IgniteCache cache = this.grid().cache("default");
        cache.loadCacheAsync(null, new Object[]{0}).get();
        assert (cache.size(new CachePeekMode[0]) == 10);
        List res = cache.query((Query)new SqlQuery(ValueObject.class, "val >= 0")).getAll();
        assert (res != null);
        assert (res.size() == 10);
        assert (this.size(ValueObject.class) == 10L);
    }

    @Test
    public void testLoadCacheFiltered() throws Exception {
        IgniteCache cache = this.grid().cache("default");
        cache.loadCache((IgniteBiPredicate)new P2<Integer, ValueObject>(){

            public boolean apply(Integer key, ValueObject val) {
                return key >= 5;
            }
        }, new Object[0]);
        assert (cache.size(new CachePeekMode[0]) == 5);
        List res = cache.query((Query)new SqlQuery(ValueObject.class, "val >= 0")).getAll();
        assert (res != null);
        assert (res.size() == 5);
        assert (this.size(ValueObject.class) == 5L);
    }

    @Test
    public void testLoadCacheAsyncFiltered() throws Exception {
        IgniteCache cache = this.grid().cache("default");
        cache.loadCacheAsync((IgniteBiPredicate)new P2<Integer, ValueObject>(){

            public boolean apply(Integer key, ValueObject val) {
                return key >= 5;
            }
        }, new Object[]{0}).get();
        assert (cache.localSize(new CachePeekMode[0]) == 5);
        List res = cache.query((Query)new SqlQuery(ValueObject.class, "val >= 0")).getAll();
        assert (res != null);
        assert (res.size() == 5);
        assert (this.size(ValueObject.class) == 5L);
    }

    @Test
    public void testReloadAsync() throws Exception {
        STORE_MAP.put(1, new ValueObject(1));
        IgniteCache cache = this.jcache();
        assert (((ValueObject)cache.getAsync((Object)1).get()).value() == 1);
        assert (cache.size(new CachePeekMode[0]) == 1);
        List res = cache.query((Query)new SqlQuery(ValueObject.class, "val >= 0")).getAll();
        assert (res != null);
        assert (res.size() == 1);
        assert (this.size(ValueObject.class) == 1L);
    }

    @Test
    public void testReloadAll() throws Exception {
        for (int i = 0; i < 10; ++i) {
            STORE_MAP.put(i, new ValueObject(i));
        }
        IgniteCache cache = this.jcache();
        Object[] keys = new Integer[5];
        for (int i = 0; i < 5; ++i) {
            keys[i] = i + 5;
        }
        CompletionListenerFuture fut = new CompletionListenerFuture();
        this.grid().cache("default").loadAll(F.asSet((Object[])keys), true, (CompletionListener)fut);
        fut.get();
        assert (cache.size(new CachePeekMode[0]) == 5);
        List res = cache.query((Query)new SqlQuery(ValueObject.class, "val >= 0")).getAll();
        assert (res != null);
        assert (res.size() == 5);
        assert (this.size(ValueObject.class) == 5L);
        cache.clear();
        assert (cache.size(new CachePeekMode[0]) == 0);
        IgniteCacheQueryLoadSelfTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
        fut = new CompletionListenerFuture();
        this.grid().cache("default").loadAll(F.asSet((Object[])keys), true, (CompletionListener)fut);
        fut.get();
        IgniteCacheQueryLoadSelfTest.assertEquals((int)5, (int)cache.size(new CachePeekMode[0]));
        res = cache.query((Query)new SqlQuery(ValueObject.class, "val >= 0")).getAll();
        assert (res != null);
        assert (res.size() == 5);
        assert (this.size(ValueObject.class) == 5L);
    }

    private static class ValueObject
    implements Serializable {
        @QuerySqlField
        private final int val;

        ValueObject(int val) {
            this.val = val;
        }

        int value() {
            return this.val;
        }

        public String toString() {
            return S.toString(ValueObject.class, (Object)this);
        }
    }

    private static class TestStore
    extends CacheStoreAdapter<Integer, ValueObject> {
        private TestStore() {
        }

        public void loadCache(IgniteBiInClosure<Integer, ValueObject> clo, Object ... args) {
            assert (clo != null);
            for (int i = 0; i < 10; ++i) {
                clo.apply((Object)i, (Object)new ValueObject(i));
            }
        }

        public ValueObject load(Integer key) {
            assert (key != null);
            return (ValueObject)STORE_MAP.get(key);
        }

        public void write(Cache.Entry<? extends Integer, ? extends ValueObject> e) {
            assert (e != null);
            assert (e.getKey() != null);
            assert (e.getValue() != null);
            STORE_MAP.put(e.getKey(), e.getValue());
        }

        public void delete(Object key) {
            assert (key != null);
            STORE_MAP.remove(key);
        }
    }
}

