/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCachePrimitiveFieldsQuerySelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration(CACHE_NAME)});
        cfg.setMarshaller(null);
        return cfg;
    }

    private CacheConfiguration<Integer, IndexedType> cacheConfiguration(String cacheName) {
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        QueryEntity entity = new QueryEntity(Integer.class.getName(), IndexedType.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("iVal", "int");
        entity.setFields(fields);
        entity.setIndexes((Collection)F.asList((Object)new QueryIndex("iVal")));
        ccfg.setQueryEntities((Collection)F.asList((Object)entity));
        return ccfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(3);
    }

    @Test
    public void testStaticCache() throws Exception {
        this.checkCache((IgniteCache<Integer, IndexedType>)this.ignite(0).cache(CACHE_NAME));
    }

    private void checkCache(IgniteCache<Integer, IndexedType> cache) throws Exception {
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)i, (Object)new IndexedType(i));
        }
        List res = cache.query(new SqlFieldsQuery("select avg(iVal) from IndexedType where iVal > ?").setArgs(new Object[]{499})).getAll();
        IgniteCachePrimitiveFieldsQuerySelfTest.assertEquals((int)1, (int)res.size());
        IgniteCachePrimitiveFieldsQuerySelfTest.assertEquals((int)1, (int)((List)res.get(0)).size());
    }

    private static class IndexedType {
        private int iVal;

        private IndexedType(int iVal) {
            this.iVal = iVal;
        }
    }
}

