/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheNoClassQuerySelfTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        ((TcpDiscoverySpi)c.getDiscoverySpi()).setForceServerMode(true);
        CacheConfiguration cc = IgniteCacheNoClassQuerySelfTest.defaultCacheConfiguration();
        c.setMarshaller((Marshaller)new JdkMarshaller());
        cc.setName("cache");
        cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setRebalanceMode(CacheRebalanceMode.SYNC);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType("MyClass");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("strField", String.class.getName());
        fields.put("intField", Integer.class.getName());
        fields.put("doubleField", Double.class.getName());
        qryEntity.setFields(fields);
        qryEntity.setFields(fields);
        qryEntity.setIndexes(Arrays.asList(new QueryIndex("strField"), new QueryIndex("intField"), new QueryIndex("doubleField")));
        cc.setQueryEntities(Collections.singletonList(qryEntity));
        c.setCacheConfiguration(new CacheConfiguration[]{cc});
        return c;
    }

    @Test
    public void testNoClass() throws Exception {
        try {
            this.startGrid();
            IgniteCacheNoClassQuerySelfTest.fail();
        }
        catch (Exception e) {
            IgniteCacheNoClassQuerySelfTest.assertTrue((boolean)e.getMessage().contains("default marshaller"));
        }
        finally {
            this.stopAllGrids();
        }
    }
}

