/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheJoinQueryWithAffinityKeyTest
extends GridCommonAbstractTest {
    private static final int NODES = 5;
    private boolean client;
    private boolean escape;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheKeyConfiguration keyCfg = new CacheKeyConfiguration();
        keyCfg.setTypeName(TestKeyWithAffinity.class.getName());
        keyCfg.setAffinityKeyFieldName("affKey");
        cfg.setCacheKeyConfiguration(new CacheKeyConfiguration[]{keyCfg});
        cfg.setClientMode(this.client);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(4);
        this.client = true;
        this.startGrid(4);
    }

    @Test
    public void testJoinQuery() throws Exception {
        this.testJoinQuery(CacheMode.PARTITIONED, 0, false, true);
        this.testJoinQuery(CacheMode.PARTITIONED, 1, false, true);
        this.testJoinQuery(CacheMode.REPLICATED, 0, false, true);
    }

    @Test
    public void testJoinQueryEscapeAll() throws Exception {
        this.escape = true;
        this.testJoinQuery();
    }

    @Test
    public void testJoinQueryWithAffinityKey() throws Exception {
        this.testJoinQuery(CacheMode.PARTITIONED, 0, true, true);
        this.testJoinQuery(CacheMode.PARTITIONED, 1, true, true);
        this.testJoinQuery(CacheMode.REPLICATED, 0, true, true);
    }

    @Test
    public void testJoinQueryWithAffinityKeyEscapeAll() throws Exception {
        this.escape = true;
        this.testJoinQueryWithAffinityKey();
    }

    @Test
    public void testJoinQueryWithAffinityKeyNotQueryField() throws Exception {
        this.testJoinQuery(CacheMode.PARTITIONED, 0, true, false);
        this.testJoinQuery(CacheMode.PARTITIONED, 1, true, false);
        this.testJoinQuery(CacheMode.REPLICATED, 0, true, false);
    }

    @Test
    public void testJoinQueryWithAffinityKeyNotQueryFieldEscapeAll() throws Exception {
        this.escape = true;
        this.testJoinQueryWithAffinityKeyNotQueryField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testJoinQuery(CacheMode cacheMode, int backups, boolean affKey, boolean includeAffKey) {
        CacheConfiguration ccfg = this.cacheConfiguration(cacheMode, backups, affKey, includeAffKey);
        log.info("Test cache [mode=" + cacheMode + ", backups=" + backups + ']');
        IgniteCache cache = this.ignite(0).createCache(ccfg);
        try {
            PutData putData = this.putData(cache, affKey);
            for (int i = 0; i < 5; ++i) {
                log.info("Test node: " + i);
                IgniteCache cache0 = this.ignite(i).cache(ccfg.getName());
                this.checkPersonAccountsJoin(cache0, putData.personAccounts, affKey);
                this.checkOrganizationPersonsJoin(cache0, putData.orgPersons);
            }
        }
        finally {
            this.ignite(0).destroyCache(ccfg.getName());
        }
    }

    private void checkOrganizationPersonsJoin(IgniteCache cache, Map<Integer, Integer> cnts) {
        List res;
        SqlFieldsQuery qry = this.escape ? new SqlFieldsQuery("select o.\"name\", p.\"name\" from \"Organization\" o, \"Person\" p where p.\"orgId\" = o._key and o._key=?") : new SqlFieldsQuery("select o.name, p.name from Organization o, Person p where p.orgId = o._key and o._key=?");
        qry.setDistributedJoins(true);
        long total = 0L;
        for (int i = 0; i < cnts.size(); ++i) {
            qry.setArgs(new Object[]{i});
            res = cache.query(qry).getAll();
            IgniteCacheJoinQueryWithAffinityKeyTest.assertEquals((int)cnts.get(i), (int)res.size());
            total += (long)res.size();
        }
        SqlFieldsQuery qry2 = this.escape ? new SqlFieldsQuery("select count(*) from \"Organization\" o, \"Person\" p where p.\"orgId\" = o._key") : new SqlFieldsQuery("select count(*) from Organization o, Person p where p.orgId = o._key");
        qry2.setDistributedJoins(true);
        res = cache.query(qry2).getAll();
        IgniteCacheJoinQueryWithAffinityKeyTest.assertEquals((int)1, (int)res.size());
        IgniteCacheJoinQueryWithAffinityKeyTest.assertEquals((Object)total, ((List)res.get(0)).get(0));
    }

    private void checkPersonAccountsJoin(IgniteCache cache, Map<Object, Integer> cnts, boolean affKey) {
        String sql1 = this.escape ? "select p.\"name\" from \"Person\" p, \"" + (affKey ? "AccountKeyWithAffinity" : "Account") + "\" a where p._key = a.\"personKey\" and p._key=?" : "select p.name from Person p, " + (affKey ? "AccountKeyWithAffinity" : "Account") + " a where p._key = a.personKey and p._key=?";
        SqlFieldsQuery qry1 = new SqlFieldsQuery(sql1);
        qry1.setDistributedJoins(true);
        String sql2 = this.escape ? "select p.\"name\" from \"Person\" p, \"" + (affKey ? "AccountKeyWithAffinity" : "Account") + "\" a where p.\"id\" = a.\"personId\" and p.\"id\"=?" : "select p.name from Person p, " + (affKey ? "AccountKeyWithAffinity" : "Account") + " a where p.id = a.personId and p.id=?";
        SqlFieldsQuery qry2 = new SqlFieldsQuery(sql2);
        qry2.setDistributedJoins(true);
        Ignite ignite = (Ignite)cache.unwrap(Ignite.class);
        boolean binary = ignite.configuration().getMarshaller() instanceof BinaryMarshaller;
        long total = 0L;
        for (Map.Entry<Object, Integer> e : cnts.entrySet()) {
            Object arg = binary ? ignite.binary().toBinary(e.getKey()) : e.getKey();
            qry1.setArgs(new Object[]{arg});
            List res = cache.query(qry1).getAll();
            IgniteCacheJoinQueryWithAffinityKeyTest.assertEquals((int)e.getValue(), (int)res.size());
            total += (long)res.size();
            qry2.setArgs(new Object[]{((Id)e.getKey()).id()});
            res = cache.query(qry2).getAll();
            IgniteCacheJoinQueryWithAffinityKeyTest.assertEquals((int)e.getValue(), (int)res.size());
        }
        SqlFieldsQuery[] qrys = new SqlFieldsQuery[2];
        if (this.escape) {
            qrys[0] = new SqlFieldsQuery("select count(*) from \"Person\" p, \"" + (affKey ? "AccountKeyWithAffinity" : "Account") + "\" a where p.\"id\" = a.\"personId\"");
            qrys[1] = new SqlFieldsQuery("select count(*) from \"Person\" p, \"" + (affKey ? "AccountKeyWithAffinity" : "Account") + "\" a where p._key = a.\"personKey\"");
        } else {
            qrys[0] = new SqlFieldsQuery("select count(*) from Person p, " + (affKey ? "AccountKeyWithAffinity" : "Account") + " a where p.id = a.personId");
            qrys[1] = new SqlFieldsQuery("select count(*) from Person p, " + (affKey ? "AccountKeyWithAffinity" : "Account") + " a where p._key = a.personKey");
        }
        for (SqlFieldsQuery qry : qrys) {
            qry.setDistributedJoins(true);
            List res = cache.query(qry).getAll();
            IgniteCacheJoinQueryWithAffinityKeyTest.assertEquals((int)1, (int)res.size());
            IgniteCacheJoinQueryWithAffinityKeyTest.assertEquals((Object)total, ((List)res.get(0)).get(0));
        }
    }

    private CacheConfiguration cacheConfiguration(CacheMode cacheMode, int backups, boolean affKey, boolean includeAffKey) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(cacheMode);
        if (cacheMode == CacheMode.PARTITIONED) {
            ccfg.setBackups(backups);
        }
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        String personKeyType = affKey ? TestKeyWithAffinity.class.getName() : TestKey.class.getName();
        QueryEntity account = new QueryEntity();
        account.setKeyType(Integer.class.getName());
        account.setValueType(affKey ? AccountKeyWithAffinity.class.getName() : Account.class.getName());
        account.addQueryField("personKey", personKeyType, null);
        account.addQueryField("personId", Integer.class.getName(), null);
        account.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("personKey"), new QueryIndex("personId")}));
        QueryEntity person = new QueryEntity();
        person.setKeyType(personKeyType);
        person.setValueType(Person.class.getName());
        person.setKeyFields(Collections.singleton("id"));
        person.addQueryField("orgId", Integer.class.getName(), null);
        person.addQueryField("id", Integer.class.getName(), null);
        person.addQueryField("name", String.class.getName(), null);
        person.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("orgId"), new QueryIndex("id"), new QueryIndex("name")}));
        if (affKey && includeAffKey) {
            person.addQueryField("affKey", Integer.class.getName(), null);
        }
        QueryEntity org = new QueryEntity();
        org.setKeyType(Integer.class.getName());
        org.setValueType(Organization.class.getName());
        org.addQueryField("name", String.class.getName(), null);
        org.setIndexes((Collection)F.asList((Object)new QueryIndex("name")));
        ccfg.setQueryEntities((Collection)F.asList((Object[])new QueryEntity[]{account, person, org}));
        ccfg.setSqlEscapeAll(this.escape);
        return ccfg;
    }

    private PutData putData(IgniteCache cache, boolean affKey) {
        HashMap<Integer, Integer> orgPersons = new HashMap<Integer, Integer>();
        HashMap<Object, Integer> personAccounts = new HashMap<Object, Integer>();
        int ORG_CNT = 10;
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)new Organization("org-" + i));
        }
        HashSet<Integer> personIds = new HashSet<Integer>();
        HashSet<Integer> accountIds = new HashSet<Integer>();
        for (int i = 0; i < 10; ++i) {
            int persons = ThreadLocalRandom.current().nextInt(100);
            for (int p = 0; p < persons; ++p) {
                int personId = ThreadLocalRandom.current().nextInt();
                while (!personIds.add(personId)) {
                    personId = ThreadLocalRandom.current().nextInt();
                }
                Id personKey = affKey ? new TestKeyWithAffinity(personId) : new TestKey(personId);
                String name = "person-" + personId;
                cache.put((Object)personKey, (Object)new Person(i, name));
                int accounts = ThreadLocalRandom.current().nextInt(10);
                for (int a = 0; a < accounts; ++a) {
                    int accountId = ThreadLocalRandom.current().nextInt();
                    while (!accountIds.add(accountId)) {
                        accountId = ThreadLocalRandom.current().nextInt();
                    }
                    cache.put((Object)accountId, (Object)(affKey ? new AccountKeyWithAffinity(personKey) : new Account(personKey)));
                }
                personAccounts.put(personKey, accounts);
            }
            orgPersons.put(i, persons);
        }
        return new PutData(orgPersons, personAccounts);
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        String name;

        public Organization(String name) {
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        int orgId;
        @QuerySqlField
        String name;

        public Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }

    private static class AccountKeyWithAffinity
    implements Serializable {
        @QuerySqlField
        private TestKeyWithAffinity personKey;
        @QuerySqlField
        private int personId;

        public AccountKeyWithAffinity(Object personKey) {
            this.personKey = (TestKeyWithAffinity)personKey;
            this.personId = this.personKey.id;
        }
    }

    private static class Account
    implements Serializable {
        @QuerySqlField
        private TestKey personKey;
        @QuerySqlField
        private int personId;

        public Account(Object personKey) {
            this.personKey = (TestKey)personKey;
            this.personId = this.personKey.id;
        }
    }

    public static class TestKeyWithAffinity
    implements Id {
        private int id;
        @AffinityKeyMapped
        private int affKey;

        public TestKeyWithAffinity(int id) {
            this.id = id;
            this.affKey = id + 1;
        }

        @Override
        public int id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKeyWithAffinity other = (TestKeyWithAffinity)o;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class TestKey
    implements Id {
        private int id;

        public TestKey(int id) {
            this.id = id;
        }

        @Override
        public int id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKey other = (TestKey)o;
            return this.id == other.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static interface Id {
        public int id();
    }

    private static class PutData {
        final Map<Integer, Integer> orgPersons;
        final Map<Object, Integer> personAccounts;

        public PutData(Map<Integer, Integer> orgPersons, Map<Object, Integer> personAccounts) {
            this.orgPersons = orgPersons;
            this.personAccounts = personAccounts;
        }
    }
}

