/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteBinaryObjectFieldsQuerySelfTest
extends GridCommonAbstractTest {
    public static final String PERSON_KEY_CLS_NAME = "org.apache.ignite.tests.p2p.cache.PersonKey";
    public static final int GRID_CNT = 4;
    private static ClassLoader extClassLoader;

    protected String getPersonClassName() {
        return "org.apache.ignite.tests.p2p.cache.Person";
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setPeerClassLoadingEnabled(false);
        cfg.setMarshaller(null);
        if (this.getTestIgniteInstanceName(3).equals(igniteInstanceName)) {
            cfg.setClientMode(true);
            cfg.setClassLoader(extClassLoader);
        }
        return cfg;
    }

    protected CacheConfiguration cache(CacheMode cacheMode, CacheAtomicityMode atomicity) throws Exception {
        CacheConfiguration cache = IgniteBinaryObjectFieldsQuerySelfTest.defaultCacheConfiguration();
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setRebalanceMode(CacheRebalanceMode.SYNC);
        cache.setCacheMode(cacheMode);
        cache.setAtomicityMode(atomicity);
        cache.setIndexedTypes(new Class[]{extClassLoader.loadClass(PERSON_KEY_CLS_NAME), extClassLoader.loadClass(this.getPersonClassName())});
        return cache;
    }

    protected void beforeTestsStarted() throws Exception {
        this.initExtClassLoader();
        this.startGrids(4);
    }

    protected void initExtClassLoader() {
        extClassLoader = IgniteBinaryObjectFieldsQuerySelfTest.getExternalClassLoader();
    }

    protected void afterTestsStopped() throws Exception {
        extClassLoader = null;
    }

    @Test
    public void testQueryPartitionedAtomic() throws Exception {
        this.checkQuery(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testQueryReplicatedAtomic() throws Exception {
        this.checkQuery(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testQueryPartitionedTransactional() throws Exception {
        this.checkQuery(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL);
    }

    @Test
    public void testQueryReplicatedTransactional() throws Exception {
        this.checkQuery(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL);
    }

    @Test
    public void testFieldsQueryPartitionedAtomic() throws Exception {
        this.checkFieldsQuery(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testFieldsQueryReplicatedAtomic() throws Exception {
        this.checkFieldsQuery(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testFieldsQueryPartitionedTransactional() throws Exception {
        this.checkFieldsQuery(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL);
    }

    @Test
    public void testFieldsQueryReplicatedTransactional() throws Exception {
        this.checkFieldsQuery(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFieldsQuery(CacheMode cacheMode, CacheAtomicityMode atomicity) throws Exception {
        IgniteCache cache = this.grid(3).getOrCreateCache(this.cache(cacheMode, atomicity));
        try {
            this.populate((IgniteCache<Object, Object>)cache);
            FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("select id, name, lastName, salary from Person order by id asc"));
            List all = cur.getAll();
            IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((int)100, (int)all.size());
            for (int i = 0; i < 100; ++i) {
                List row = (List)all.get(i);
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((Object)i, row.get(0));
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((Object)("person-" + i), row.get(1));
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((Object)("person-last-" + i), row.get(2));
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((Object)(i * 25), row.get(3));
            }
        }
        finally {
            this.grid(3).destroyCache("default");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQuery(CacheMode cacheMode, CacheAtomicityMode atomicity) throws Exception {
        IgniteCache cache = this.grid(3).getOrCreateCache(this.cache(cacheMode, atomicity));
        try {
            this.populate((IgniteCache<Object, Object>)cache);
            QueryCursor cur = cache.query((Query)new SqlQuery("Person", "order by id asc"));
            List all = cur.getAll();
            IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((int)100, (int)all.size());
            for (int i = 0; i < 100; ++i) {
                Object person = ((Cache.Entry)all.get(i)).getValue();
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((Object)i, (Object)U.field((Object)person, (String)"id"));
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((String)("person-" + i), (String)((String)U.field((Object)person, (String)"name")));
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((String)("person-last-" + i), (String)((String)U.field((Object)person, (String)"lastName")));
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((double)(i * 25), (Double)((Double)U.field((Object)person, (String)"salary")));
            }
            int max = 49;
            ScanQuery scanQry = new ScanQuery((IgniteBiPredicate)new PersonKeyFilter(max));
            QueryCursor curs = this.grid(3).cache("default").withKeepBinary().query((Query)scanQry);
            List records = curs.getAll();
            IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((int)50, (int)records.size());
            for (Cache.Entry entry : records) {
                BinaryObject key = (BinaryObject)entry.getKey();
                IgniteBinaryObjectFieldsQuerySelfTest.assertTrue(((Integer)key.field("id") <= max ? 1 : 0) != 0);
                IgniteBinaryObjectFieldsQuerySelfTest.assertEquals((String)PERSON_KEY_CLS_NAME, (String)key.deserialize().getClass().getName());
            }
        }
        finally {
            this.grid(3).cache("default").removeAll();
            this.grid(3).destroyCache("default");
        }
    }

    private void populate(IgniteCache<Object, Object> cache) throws Exception {
        Class<?> keyCls = extClassLoader.loadClass(PERSON_KEY_CLS_NAME);
        Class<?> cls = extClassLoader.loadClass(this.getPersonClassName());
        for (int i = 0; i < 100; ++i) {
            Object key = keyCls.newInstance();
            GridTestUtils.setFieldValue(key, (String)"id", (Object)i);
            Object person = cls.newInstance();
            GridTestUtils.setFieldValue(person, (String)"id", (Object)i);
            GridTestUtils.setFieldValue(person, (String)"name", (Object)("person-" + i));
            GridTestUtils.setFieldValue(person, (String)"lastName", (Object)("person-last-" + i));
            GridTestUtils.setFieldValue(person, (String)"salary", (Object)(i * 25));
            cache.put(key, person);
        }
    }

    private static class PersonKeyFilter
    implements IgniteBiPredicate<BinaryObject, BinaryObject> {
        private int maxId;

        public PersonKeyFilter(int maxId) {
            this.maxId = maxId;
        }

        public boolean apply(BinaryObject key, BinaryObject val) {
            return (Integer)key.field("id") <= this.maxId;
        }
    }
}

