/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collections;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.fifo.FifoEvictionPolicy;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractQuerySelfTest;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridIndexingWithNoopSwapSelfTest
extends GridCommonAbstractTest {
    protected Ignite ignite;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cc = GridIndexingWithNoopSwapSelfTest.defaultCacheConfiguration();
        cc.setCacheMode(CacheMode.PARTITIONED);
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setRebalanceMode(CacheRebalanceMode.SYNC);
        cc.setNearConfiguration(new NearCacheConfiguration());
        FifoEvictionPolicy plc = new FifoEvictionPolicy();
        plc.setMaxSize(1000);
        cc.setEvictionPolicy((EvictionPolicy)plc);
        cc.setOnheapCacheEnabled(true);
        cc.setBackups(1);
        cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cc.setIndexedTypes(new Class[]{Integer.class, IgniteCacheAbstractQuerySelfTest.ObjectValue.class});
        c.setCacheConfiguration(new CacheConfiguration[]{cc});
        return c;
    }

    protected void beforeTest() throws Exception {
        this.ignite = this.startGrid();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.ignite = null;
    }

    @Test
    public void testQuery() throws Exception {
        int i;
        IgniteCache cache = this.ignite.cache("default");
        int cnt = 10;
        for (i = 0; i < cnt; ++i) {
            cache.getAndPut((Object)i, (Object)new IgniteCacheAbstractQuerySelfTest.ObjectValue("test" + i, i));
        }
        for (i = 0; i < cnt; ++i) {
            GridIndexingWithNoopSwapSelfTest.assertNotNull((Object)cache.localPeek((Object)i, ONHEAP_PEEK_MODES));
            cache.localEvict(Collections.singleton(i));
        }
        SqlQuery qry = new SqlQuery(IgniteCacheAbstractQuerySelfTest.ObjectValue.class, "intVal >= ? order by intVal");
        GridIndexingWithNoopSwapSelfTest.assertEquals((int)10, (int)cache.query((Query)qry.setArgs(new Object[]{0})).getAll().size());
    }
}

