/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class DuplicateIndexCreationTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x10000000L)));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("default").setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{Integer.class, Person.class}), new CacheConfiguration().setName("CACHE_2").setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{Integer.class, Department.class})});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testIndexCreationDefaultName() throws Exception {
        SqlFieldsQuery queryCreateIndex = new SqlFieldsQuery("CREATE INDEX ON PUBLIC.PERSON (NAME)");
        SqlFieldsQuery queryCreateIndexIfNotExist = new SqlFieldsQuery("CREATE INDEX IF NOT EXISTS ON PUBLIC.PERSON (NAME)");
        IgniteEx node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = node.cache("default");
        cache.query(queryCreateIndex).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndexIfNotExist).getAll(), CacheException.class, null);
        this.stopGrid(0);
        this.startGrid(0);
        this.stopGrid(0);
        this.cleanPersistenceDir();
        node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        cache = node.cache("default");
        cache.query(queryCreateIndexIfNotExist).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        this.stopGrid(0);
        this.startGrid(0);
    }

    @Test
    public void testIndexCreationViaAnnotations() throws Exception {
        SqlFieldsQuery queryCreateIndex = new SqlFieldsQuery("CREATE INDEX PERSON_NAME_IDX ON PUBLIC.PERSON (NAME)");
        SqlFieldsQuery queryCreateIndexIfNotExist = new SqlFieldsQuery("CREATE INDEX PERSON_NAME_IDX IF NOT EXISTS ON PUBLIC.PERSON (NAME)");
        IgniteEx node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = node.cache("default");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndexIfNotExist).getAll(), CacheException.class, null);
        this.stopGrid(0);
        this.startGrid(0);
        this.stopGrid(0);
        this.cleanPersistenceDir();
        node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        cache = node.cache("default");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndexIfNotExist).getAll(), CacheException.class, null);
        this.stopGrid(0);
        this.startGrid(0);
    }

    @Test
    public void testIndexCreation() throws Exception {
        SqlFieldsQuery queryCreateIndex = DuplicateIndexCreationTest.createIndexQuery("PERSON", false);
        SqlFieldsQuery queryCreateIndexIfNotExist = DuplicateIndexCreationTest.createIndexQuery("PERSON", true);
        IgniteEx node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = node.cache("default");
        cache.query(queryCreateIndex).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        cache.query(queryCreateIndexIfNotExist).getAll();
        this.stopGrid(0);
        this.startGrid(0);
        this.stopGrid(0);
        this.cleanPersistenceDir();
        node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        cache = node.cache("default");
        cache.query(queryCreateIndexIfNotExist).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        this.stopGrid(0);
        this.startGrid(0);
    }

    @Test
    public void testIndexCreationDifferentCaches() throws Exception {
        SqlFieldsQuery queryCreateIndex = DuplicateIndexCreationTest.createIndexQuery("DEPARTMENT", false);
        SqlFieldsQuery queryCreateIndexIfNotExist = DuplicateIndexCreationTest.createIndexQuery("DEPARTMENT", true);
        IgniteEx node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = node.cache("default");
        cache.query(DuplicateIndexCreationTest.createIndexQuery("PERSON", false)).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        cache.query(queryCreateIndexIfNotExist).getAll();
        this.stopGrid(0);
        this.startGrid(0);
        this.stopGrid(0);
        this.cleanPersistenceDir();
        node = this.startGrid(0);
        node.cluster().state(ClusterState.ACTIVE);
        cache = node.cache("default");
        cache.query(queryCreateIndexIfNotExist).getAll();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> cache.query(queryCreateIndex).getAll(), CacheException.class, null);
        this.stopGrid(0);
        this.startGrid(0);
    }

    private static SqlFieldsQuery createIndexQuery(String tableName, boolean ifNotExists) {
        assert (!tableName.isEmpty());
        return new SqlFieldsQuery("CREATE INDEX " + (ifNotExists ? "IF NOT EXISTS " : "") + " NAME_IDX ON PUBLIC." + tableName + " (NAME)");
    }

    private static class Department
    implements Serializable {
        @QuerySqlField
        public String name;

        private Department() {
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        public String name;

        private Person() {
        }
    }
}

