/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingSpi;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class CacheGroupMetricsWithIndexBuildFailTest
extends AbstractIndexingCommonTest {
    private static final String GROUP_NAME = "TEST_GROUP";
    private final AtomicBoolean failIndexRebuild = new AtomicBoolean();

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xA00000L)));
        cfg.setIndexingSpi((IndexingSpi)new TestIndexingSpi());
        return cfg;
    }

    private CacheConfiguration<Integer, Integer> cacheConfiguration(String cacheName) {
        CacheConfiguration ccfg = new CacheConfiguration(cacheName);
        ccfg.setGroupName(GROUP_NAME);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        return ccfg;
    }

    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        GridQueryProcessor.idxCls = null;
    }

    @Test
    public void testIndexRebuildCountPartitionsLeft() throws Exception {
        IgniteEx ignite0 = this.startGrid(0);
        ignite0.cluster().active(true);
        String cacheName1 = "cache1";
        String cacheName2 = "cache2";
        IgniteCache cache1 = ignite0.getOrCreateCache(this.cacheConfiguration(cacheName1));
        IgniteCache cache2 = ignite0.getOrCreateCache(this.cacheConfiguration(cacheName2));
        cache1.put((Object)1, (Object)1);
        cache2.put((Object)1, (Object)1);
        int parts1 = ignite0.cachex(cacheName1).configuration().getAffinity().partitions();
        int parts2 = ignite0.cachex(cacheName2).configuration().getAffinity().partitions();
        List<Path> idxPaths = this.getIndexBinPaths(cacheName1);
        this.stopAllGrids();
        idxPaths.forEach(idxPath -> CacheGroupMetricsWithIndexBuildFailTest.assertTrue((boolean)U.delete((Path)idxPath)));
        GridQueryProcessor.idxCls = AbstractIndexingCommonTest.BlockingIndexing.class;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        MetricRegistry grpMreg = ignite.context().metric().registry(MetricUtils.metricName((String[])new String[]{"cacheGroups", GROUP_NAME}));
        LongMetric indexBuildCountPartitionsLeft = (LongMetric)grpMreg.findMetric("IndexBuildCountPartitionsLeft");
        CacheGroupMetricsWithIndexBuildFailTest.assertEquals((long)(parts1 + parts2), (long)indexBuildCountPartitionsLeft.value());
        this.failIndexRebuild.set(true);
        ((AbstractIndexingCommonTest.BlockingIndexing)ignite.context().query().getIndexing()).stopBlock(cacheName1);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> ignite.cache(cacheName1).indexReadyFuture().get(30000L), IgniteSpiException.class, (String)"Test exception.");
        CacheGroupMetricsWithIndexBuildFailTest.assertEquals((long)parts2, (long)indexBuildCountPartitionsLeft.value());
        this.failIndexRebuild.set(false);
        ((AbstractIndexingCommonTest.BlockingIndexing)ignite.context().query().getIndexing()).stopBlock(cacheName2);
        ignite.cache(cacheName2).indexReadyFuture().get(30000L);
        CacheGroupMetricsWithIndexBuildFailTest.assertEquals((long)0L, (long)indexBuildCountPartitionsLeft.value());
    }

    private class TestIndexingSpi
    extends IgniteSpiAdapter
    implements IndexingSpi {
        private TestIndexingSpi() {
        }

        public Iterator<Cache.Entry<?, ?>> query(@Nullable String cacheName, Collection<Object> params, @Nullable IndexingQueryFilter filters) throws IgniteSpiException {
            return null;
        }

        public void store(@Nullable String cacheName, Object key, Object val, long expirationTime) throws IgniteSpiException {
            if (CacheGroupMetricsWithIndexBuildFailTest.this.failIndexRebuild.get()) {
                throw new IgniteSpiException("Test exception.");
            }
        }

        public void remove(@Nullable String cacheName, Object key) throws IgniteSpiException {
        }

        public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        }

        public void spiStop() throws IgniteSpiException {
        }
    }
}

