/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateProposedMessage;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class BinaryTypeRegistrationTest
extends GridCommonAbstractTest {
    private final ConcurrentLinkedQueue<Object> metadataUpdateProposedMessages = new ConcurrentLinkedQueue();

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi(){

            public void sendCustomEvent(DiscoverySpiCustomMessage msg) throws IgniteException {
                if (msg instanceof CustomMessageWrapper && ((CustomMessageWrapper)msg).delegate() instanceof MetadataUpdateProposedMessage) {
                    BinaryTypeRegistrationTest.this.metadataUpdateProposedMessages.add(((CustomMessageWrapper)msg).delegate());
                }
                super.sendCustomEvent(msg);
            }
        });
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.metadataUpdateProposedMessages.clear();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.metadataUpdateProposedMessages.clear();
    }

    @Test
    public void shouldSendOnlyOneMetadataMessage() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        int threadsNum = 20;
        ExecutorService exec = Executors.newFixedThreadPool(threadsNum);
        CyclicBarrier barrier = new CyclicBarrier(threadsNum + 1);
        for (int i = 0; i < threadsNum; ++i) {
            exec.submit(new TypeRegistrator((Ignite)ignite, barrier));
        }
        barrier.await();
        exec.shutdown();
        exec.awaitTermination(10L, TimeUnit.SECONDS);
        BinaryTypeRegistrationTest.assertEquals((String)this.metadataUpdateProposedMessages.toString(), (int)1, (int)this.metadataUpdateProposedMessages.size());
    }

    @Test
    public void shouldSendMetadataMessagePerEachNewBinaryData() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        int threadsNum = 20;
        ExecutorService exec = Executors.newFixedThreadPool(threadsNum);
        CyclicBarrier barrier = new CyclicBarrier(threadsNum + 1);
        for (int i = 0; i < threadsNum; ++i) {
            exec.submit(new TypeRegistrator((Ignite)ignite, barrier, "intField" + i));
        }
        barrier.await();
        exec.shutdown();
        exec.awaitTermination(10L, TimeUnit.SECONDS);
        BinaryTypeRegistrationTest.assertEquals((int)threadsNum, (int)this.metadataUpdateProposedMessages.size());
    }

    private static void register(Ignite ignite, String fieldName) {
        IgniteBinary binary = ignite.binary();
        BinaryObjectBuilder builder = binary.builder("TestType");
        builder.setField(fieldName, (Object)1);
        builder.build();
    }

    static class TypeRegistrator
    implements Runnable {
        static final String DEFAULT_BINARY_FIELD_NAME = "intField";
        private Ignite ignite;
        private CyclicBarrier cyclicBarrier;
        private String binaryFieldName;

        TypeRegistrator(Ignite ignite, CyclicBarrier cyclicBarrier) {
            this(ignite, cyclicBarrier, DEFAULT_BINARY_FIELD_NAME);
        }

        public TypeRegistrator(Ignite ignite, CyclicBarrier cyclicBarrier, String binaryFieldName) {
            this.ignite = ignite;
            this.cyclicBarrier = cyclicBarrier;
            this.binaryFieldName = binaryFieldName;
        }

        @Override
        public void run() {
            try {
                this.cyclicBarrier.await();
                BinaryTypeRegistrationTest.register(this.ignite, this.binaryFieldName);
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
            }
        }
    }
}

