/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import java.util.Comparator;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInlineIndexColumn
implements InlineIndexColumn {
    public static final int CANT_BE_COMPARE = -2;
    public static final int COMPARE_UNSUPPORTED = Integer.MIN_VALUE;
    private final Column col;
    private final int type;
    private final short size;

    protected AbstractInlineIndexColumn(Column col, int type, short size) {
        assert (col.getType().getValueType() == type) : "columnType=" + col.getType().getValueType() + ", type=" + type;
        assert (size != 0);
        this.col = col;
        this.type = type;
        this.size = size;
    }

    @Override
    public String columnName() {
        return this.col.getName();
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public int columnIndex() {
        return this.col.getColumnId();
    }

    @Override
    public short size() {
        return this.size;
    }

    @Override
    public int fullSize(long pageAddr, int off) {
        byte type = PageUtils.getByte((long)pageAddr, (int)off);
        if (type == 0) {
            return 1;
        }
        if (this.size > 0) {
            return this.size + 1;
        }
        return (PageUtils.getShort((long)pageAddr, (int)(off + 1)) & Short.MAX_VALUE) + 3;
    }

    @Override
    public String columnSql() {
        return this.col.getOriginalSQL();
    }

    @Nullable
    public Value get(long pageAddr, int off, int maxSize) {
        if (this.size > 0 && this.size + 1 > maxSize) {
            return null;
        }
        if (maxSize < 1) {
            return null;
        }
        byte type = PageUtils.getByte((long)pageAddr, (int)off);
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            return ValueNull.INSTANCE;
        }
        this.ensureValueType(type);
        return this.get0(pageAddr, off);
    }

    @Override
    public int compare(long pageAddr, int off, int maxSize, Value v, Comparator<Value> comp) {
        int type;
        if (this.size > 0 && this.size + 1 > maxSize || maxSize < 1 || (type = PageUtils.getByte((long)pageAddr, (int)off)) == -1) {
            return -2;
        }
        if (type == 0) {
            return Integer.signum(comp.compare((Value)ValueNull.INSTANCE, v));
        }
        if (v == ValueNull.INSTANCE) {
            return 1;
        }
        this.ensureValueType(type);
        type = Value.getHigherOrder((int)type, (int)v.getValueType());
        int c = this.compare0(pageAddr, off, v, type);
        if (c != Integer.MIN_VALUE) {
            return c;
        }
        Value v1 = this.get(pageAddr, off, maxSize);
        if (v1 == null) {
            return -2;
        }
        return Integer.signum(comp.compare(v1, v));
    }

    @Override
    public int inlineSizeOf(Value val) {
        if (val.getType().getValueType() == 0) {
            return 1;
        }
        this.ensureValueType(val.getType().getValueType());
        return this.inlineSizeOf0(val);
    }

    @Override
    public int put(long pageAddr, int off, Value val, int maxSize) {
        if (this.size > 0 && this.size + 1 > maxSize) {
            return 0;
        }
        if (this.size < 0 && maxSize < 4) {
            PageUtils.putByte((long)pageAddr, (int)off, (byte)-1);
            return 0;
        }
        int valType = val.getType().getValueType();
        if (valType == 0) {
            PageUtils.putByte((long)pageAddr, (int)off, (byte)0);
            return 1;
        }
        this.ensureValueType(valType);
        return this.put0(pageAddr, off, val, maxSize);
    }

    private void ensureValueType(int valType) {
        if (valType != this.type) {
            throw new UnsupportedOperationException("Value type doesn't match: exp=" + this.type + ", act=" + valType);
        }
    }

    protected abstract int compare0(long var1, int var3, Value var4, int var5);

    protected abstract int put0(long var1, int var3, Value var4, int var5);

    @Nullable
    protected abstract Value get0(long var1, int var3);

    protected abstract int inlineSizeOf0(Value var1);

    protected byte[] readBytes(long pageAddr, int off) {
        int size = PageUtils.getShort((long)pageAddr, (int)(off + 1)) & Short.MAX_VALUE;
        return PageUtils.getBytes((long)pageAddr, (int)(off + 3), (int)size);
    }
}

