/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.ComputeMXBeanImpl;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.QueryMXBeanImpl;
import org.apache.ignite.internal.ServiceMXBeanImpl;
import org.apache.ignite.internal.TransactionsMXBeanImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.mxbean.ClientProcessorMXBean;
import org.apache.ignite.mxbean.ComputeMXBean;
import org.apache.ignite.mxbean.QueryMXBean;
import org.apache.ignite.mxbean.ServiceMXBean;
import org.apache.ignite.mxbean.TransactionsMXBean;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.util.KillCommandsTests;
import org.junit.Test;

public class KillCommandsMXBeanTest
extends GridCommonAbstractTest {
    public static final int NODES_CNT = 3;
    private static List<IgniteEx> srvs;
    private static IgniteEx startCli;
    private static IgniteEx killCli;
    private static QueryMXBean qryMBean;
    private static TransactionsMXBean txMBean;
    private static ComputeMXBean computeMBean;
    private static ServiceMXBean svcMxBean;

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        srvs = new ArrayList<IgniteEx>();
        for (int i = 0; i < 3; ++i) {
            srvs.add(this.grid(i));
        }
        startCli = this.startClientGrid("startClient");
        killCli = this.startClientGrid("killClient");
        srvs.get(0).cluster().state(ClusterState.ACTIVE);
        this.computeJobWorkerInterruptTimeout((Ignite)srvs.get(0)).propagate((Serializable)Long.valueOf(100L));
        IgniteCache cache = startCli.getOrCreateCache(new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        for (int i = 0; i < 5000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        qryMBean = (QueryMXBean)KillCommandsMXBeanTest.getMxBean((String)killCli.name(), (String)"Query", (String)QueryMXBeanImpl.class.getSimpleName(), QueryMXBean.class);
        txMBean = (TransactionsMXBean)KillCommandsMXBeanTest.getMxBean((String)killCli.name(), (String)"Transactions", (String)TransactionsMXBeanImpl.class.getSimpleName(), TransactionsMXBean.class);
        computeMBean = (ComputeMXBean)KillCommandsMXBeanTest.getMxBean((String)killCli.name(), (String)"Compute", (String)ComputeMXBeanImpl.class.getSimpleName(), ComputeMXBean.class);
        svcMxBean = (ServiceMXBean)KillCommandsMXBeanTest.getMxBean((String)killCli.name(), (String)"Service", (String)ServiceMXBeanImpl.class.getSimpleName(), ServiceMXBean.class);
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testCancelComputeTask() throws Exception {
        KillCommandsTests.doTestCancelComputeTask(startCli, srvs, sessId -> computeMBean.cancel(sessId));
    }

    @Test
    public void testCancelService() throws Exception {
        KillCommandsTests.doTestCancelService(startCli, killCli, srvs.get(0), name -> svcMxBean.cancel(name));
    }

    @Test
    public void testCancelTx() {
        KillCommandsTests.doTestCancelTx(startCli, srvs, xid -> txMBean.cancel(xid));
    }

    @Test
    public void testCancelSQLQuery() {
        KillCommandsTests.doTestCancelSQLQuery(startCli, qryId -> qryMBean.cancelSQL(qryId));
    }

    @Test
    public void testCancelContinuousQuery() throws Exception {
        KillCommandsTests.doTestCancelContinuousQuery(startCli, srvs, (nodeId, routineId) -> qryMBean.cancelContinuous(nodeId.toString(), routineId.toString()));
    }

    @Test
    public void testCancelScanQuery() {
        KillCommandsTests.doTestScanQueryCancel(startCli, srvs, args -> qryMBean.cancelScan(((UUID)args.get1()).toString(), (String)args.get2(), (Long)args.get3()));
    }

    @Test
    public void testCancelClientConnection() {
        KillCommandsTests.doTestCancelClientConnection(srvs, (nodeId, connId) -> {
            ClientProcessorMXBean cliMxBean = (ClientProcessorMXBean)KillCommandsMXBeanTest.getMxBean((String)(nodeId == null ? (Ignite)srvs.get(1) : G.ignite((UUID)nodeId)).name(), (String)"Clients", (String)ClientListenerProcessor.class.getSimpleName(), ClientProcessorMXBean.class);
            if (connId == null) {
                cliMxBean.dropAllConnections();
            } else {
                cliMxBean.dropConnection(connId.longValue());
            }
        });
    }

    @Test
    public void testCancelUnknownSQLQuery() {
        qryMBean.cancelSQL(srvs.get(0).localNode().id().toString() + "_42");
    }

    @Test
    public void testCancelUnknownContinuousQuery() {
        qryMBean.cancelContinuous(srvs.get(0).localNode().id().toString(), UUID.randomUUID().toString());
    }

    @Test
    public void testCancelUnknownScanQuery() {
        qryMBean.cancelScan(srvs.get(0).localNode().id().toString(), "unknown", Long.valueOf(1L));
    }

    @Test
    public void testCancelUnknownComputeTask() {
        computeMBean.cancel(IgniteUuid.randomUuid().toString());
    }

    @Test
    public void testCancelUnknownTx() {
        txMBean.cancel("unknown");
    }

    @Test
    public void testCancelUnknownService() {
        svcMxBean.cancel("unknown");
    }
}

