/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqltests;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CheckWarnJoinPartitionedTables
extends GridCommonAbstractTest {
    private final ListeningTestLogger testLog = new ListeningTestLogger(log);
    private IgniteEx crd;
    @Parameterized.Parameter
    public String joinType;

    @Parameterized.Parameters(name="join={0}")
    public static List<Object> params() {
        return Arrays.asList("LEFT JOIN", "RIGHT JOIN", "INNER JOIN", "JOIN");
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setGridLogger((IgniteLogger)this.testLog);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.crd = this.startGrid();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void joinSameTableWithPrimaryKey() {
        this.execute(new SqlFieldsQuery("CREATE TABLE A (ID INT PRIMARY KEY, TITLE VARCHAR);"));
        this.checkSameTableWithJoinType();
    }

    @Test
    public void joinSameTableWithPrimaryAffinityKey() {
        this.execute(new SqlFieldsQuery("CREATE TABLE A (ID INT PRIMARY KEY, TITLE VARCHAR) with \"AFFINITY_KEY=ID\";"));
        this.checkSameTableWithJoinType();
    }

    private void checkSameTableWithJoinType() {
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a2.ID = a1.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2._KEY;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY = a2._KEY;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID = a2._KEY;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID AND a1.TITLE = a2.TITLE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID AND a1.TITLE != a2.TITLE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID AND (a1.TITLE = a2.TITLE OR a1.ID = a2.ID);", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on (a1.TITLE = a2.TITLE OR a1.ID = a2.ID) AND a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " (select a2.ID from A a2) a3 on a1.ID = a3.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " (select ID from A) a2 where a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 where a1.ID in (select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID = a3.ID);", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " (select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID = a3.ID) t on a1.ID = t.ID;", new Object[0]);
        if (!this.joinType.contains("RIGHT")) {
            this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID " + this.joinType + " A a3 on a1.ID = a3.ID;", new Object[0]);
        }
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on 1 = 1;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID > a2.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID != a2.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.TITLE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY = a2.TITLE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.TITLE = a2.TITLE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID OR a1.TITLE = a2.TITLE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID OR (a1.ID = a2.ID AND a1.TITLE = a2.TITLE);", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " (select ID from A) a2 on a1.ID > a2.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " (select ID from A) a2 where a1.ID > a2.ID;", new Object[0]);
        if (!this.joinType.contains("RIGHT")) {
            this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.TITLE " + this.joinType + " A a3 on a1.ID = a3.ID;", new Object[0]);
        }
        if (!this.joinType.contains("RIGHT")) {
            boolean shouldWarn = !this.joinType.contains("LEFT");
            this.checkLogListener(shouldWarn, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID " + this.joinType + " A a3 on a1.ID = a3.TITLE;", new Object[0]);
        }
        this.checkLogListener(true, "SELECT a1.* FROM A a1 where a1.ID in (select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID = a3.TITLE);", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 where a1.ID in (select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID != a3.ID);", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " (select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID = a3.TITLE) t on a1.ID = t.ID;", new Object[0]);
    }

    @Test
    public void joinSameTableWithComplexPrimaryKey() {
        this.execute(new SqlFieldsQuery("CREATE TABLE A (ID INT, TITLE VARCHAR, PRICE INT, COMMENT VARCHAR, PRIMARY KEY (ID, TITLE, PRICE));"));
        this.checkSameTableWithComplexPrimaryKeyWithJoinType();
    }

    private void checkSameTableWithComplexPrimaryKeyWithJoinType() {
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY = a2._KEY;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1._KEY = a2._KEY;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a2._KEY = a1._KEY;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID = a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE and a1.COMMENT = a2.COMMENT;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE and a1.COMMENT != a2.COMMENT;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.PRICE = a2.PRICE and a1.TITLE = a2.TITLE and a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.PRICE = a2.PRICE and a1.TITLE = a2.TITLE and a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID where a1.PRICE = a2.PRICE and a1.TITLE = a2.TITLE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID where a1.PRICE = a2.PRICE and a1.TITLE = a2.TITLE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 where a1.ID in (   select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID = a3.ID and a2.TITLE = a3.TITLE and a2.PRICE = a3.PRICE);", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 where a1.ID in (   select a2.ID from A a2 " + this.joinType + " A a3 where a2.ID = a3.ID and a2.TITLE = a3.TITLE and a2.PRICE = a3.PRICE);", new Object[0]);
        if (!this.joinType.contains("RIGHT")) {
            this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY = a2._KEY " + this.joinType + " A a3 on a1._KEY = a3._KEY;", new Object[0]);
        }
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a2._KEY != a1._KEY;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a2._KEY != a1._KEY;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID != a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID != a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID != a2.ID and a1.TITLE != a2.TITLE and a1.PRICE != a2.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID != a2.ID and a1.TITLE != a2.TITLE and a1.PRICE != a2.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID and a1.PRICE = a2.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID = a2.ID and a1.PRICE = a2.PRICE;", new Object[0]);
        if (!this.joinType.contains("RIGHT")) {
            boolean shouldWarn = !this.joinType.contains("LEFT");
            this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY = a2._KEY " + this.joinType + " A a3 on a1._KEY != a3._KEY;", new Object[0]);
            this.checkLogListener(!shouldWarn, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY != a2._KEY " + this.joinType + " A a3 on a1._KEY = a3._KEY;", new Object[0]);
        }
    }

    @Test
    public void joinSameTableWithComplexPrimaryKeySingleAffKey() {
        this.execute(new SqlFieldsQuery("CREATE TABLE A (ID INT, TITLE VARCHAR, PRICE INT, COMMENT VARCHAR, PRIMARY KEY (ID, TITLE, PRICE)) with \"AFFINITY_KEY=ID\";"));
        this.checkSameTableWithComplexPrimaryKeySingleAffKeyWithJoinType();
    }

    private void checkSameTableWithComplexPrimaryKeySingleAffKeyWithJoinType() {
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID and a1.TITLE != a2.TITLE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID = a2.ID and a1.TITLE != a2.TITLE;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.TITLE != a2.TITLE and a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.TITLE != a2.TITLE and a1.ID = a2.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 where a1.ID in (select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID = a3.ID);", new Object[0]);
        this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " (select a2.ID from A a2 " + this.joinType + " A a3 on a2.ID = a3.ID) t on a1.ID = t.ID;", new Object[0]);
        if (!this.joinType.contains("RIGHT")) {
            this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID " + this.joinType + " A a3 on a1.ID = a3.ID;", new Object[0]);
        }
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1._KEY = a2._KEY;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1._KEY = a2._KEY;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID != a2.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID != a2.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID != a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.ID != a2.ID and a1.TITLE = a2.TITLE and a1.PRICE = a2.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.TITLE = a2.TITLE;", new Object[0]);
        this.checkLogListener(true, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 where a1.TITLE = a2.TITLE;", new Object[0]);
        if (!this.joinType.contains("RIGHT")) {
            boolean shouldWarn = !this.joinType.contains("LEFT");
            this.checkLogListener(false, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID = a2.ID " + this.joinType + " A a3 on a1.ID != a3.ID;", new Object[0]);
            this.checkLogListener(!shouldWarn, "SELECT a1.* FROM A a1 " + this.joinType + " A a2 on a1.ID != a2.ID " + this.joinType + " A a3 on a1.ID = a3.ID;", new Object[0]);
        }
    }

    @Test
    public void joinWithPrimaryKey() {
        this.execute(new SqlFieldsQuery("CREATE TABLE A (ID INT PRIMARY KEY, TITLE VARCHAR);"));
        this.execute(new SqlFieldsQuery("CREATE TABLE B (ID INT PRIMARY KEY, PRICE INT);"));
        this.checkJoinPrimaryKeyWithJoinType();
    }

    private void checkJoinPrimaryKeyWithJoinType() {
        this.checkLogListener(false, "SELECT a.* FROM A a " + this.joinType + " B b on a.ID = b.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a.* FROM A a " + this.joinType + " B b on b.ID = a.ID;", new Object[0]);
        this.checkLogListener(false, "SELECT a.* FROM A a " + this.joinType + " B b on b._KEY = a._KEY;", new Object[0]);
        this.checkLogListener(false, "SELECT a.* FROM A a " + this.joinType + " B b on b.ID = a.ID and a.TITLE != 'Title';", new Object[0]);
        this.checkLogListener(false, "SELECT a.* FROM A a " + this.joinType + " B b on b.ID = a.ID and b.PRICE > 100;", new Object[0]);
        this.checkLogListener(false, "SELECT a.* FROM A a " + this.joinType + " B b on b.ID = a.ID and b.PRICE != a.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b on 1 = 1;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b where 1 = 1;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b on a.ID != b.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b where a.ID != b.ID;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b on b.ID = 1;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b where b.ID = 1;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b on a.ID = b.PRICE;", new Object[0]);
        this.checkLogListener(true, "SELECT a.* FROM A a " + this.joinType + " B b where a.ID = b.PRICE;", new Object[0]);
    }

    @Test
    public void joinPrimaryKeyAndAffinityKey() {
        this.execute(new SqlFieldsQuery("CREATE TABLE A (k1 VARCHAR PRIMARY KEY, v2 VARCHAR);"));
        this.execute(new SqlFieldsQuery("CREATE TABLE B (k1 VARCHAR, ak2 VARCHAR, v3 VARCHAR, PRIMARY KEY(k1, ak2)) with \"AFFINITY_KEY=ak2\";"));
        this.checkLogListener(false, "SELECT * FROM A a " + this.joinType + " B b on a.k1 = b.ak2", new Object[0]);
        this.checkLogListener(false, "SELECT * FROM A a " + this.joinType + " B b on a.k1 = b.ak2 WHERE b.k1 = ?", "1");
        this.checkLogListener(false, "SELECT * FROM A a " + this.joinType + " B b where a.k1 = b.ak2", new Object[0]);
        this.checkLogListener(false, "SELECT * FROM A a " + this.joinType + " B b where b.ak2 = a.k1", new Object[0]);
        this.checkLogListener(false, "SELECT * FROM A a " + this.joinType + " B b on a.k1 = b.ak2 WHERE a.k1 < b.ak2", new Object[0]);
        this.checkLogListener(true, "SELECT * FROM A a " + this.joinType + " B b on a.k1 = b.k1", new Object[0]);
        this.checkLogListener(true, "SELECT * FROM A a " + this.joinType + " B b on a.k1 = b.k1 and a.v2 = b.ak2", new Object[0]);
        this.checkLogListener(true, "SELECT * FROM A a " + this.joinType + " B b on a.k1 > b.ak2", new Object[0]);
        this.checkLogListener(true, "SELECT * FROM A a " + this.joinType + " B b where a.k1 = ? and b.ak2 = ?", "1", "1");
    }

    @Test
    public void testWrongQueryButAllAffinityKeysAreUsed() {
        this.execute(new SqlFieldsQuery("CREATE TABLE A (ID INT, TITLE VARCHAR, PRICE INT, COMMENT VARCHAR, PRIMARY KEY (ID, TITLE, PRICE));"));
        this.checkLogListener(false, "SELECT a1.* FROM A a1 LEFT JOIN A a2 on a1.PRICE = a2.ID and a1.TITLE = a2.TITLE and a1.ID = a2.PRICE;", new Object[0]);
    }

    private void checkLogListener(boolean shouldFindMsg, String sql, Object ... args) {
        LogListener lsnr = LogListener.matches((String)"For join two partitioned tables join condition should contain the equality operation of affinity keys").build();
        this.testLog.registerListener(lsnr);
        this.execute(new SqlFieldsQuery(sql).setArgs(args));
        if (shouldFindMsg) {
            CheckWarnJoinPartitionedTables.assertTrue((String)sql, (boolean)lsnr.check());
        } else {
            CheckWarnJoinPartitionedTables.assertFalse((String)sql, (boolean)lsnr.check());
        }
        this.testLog.clearListeners();
    }

    protected final void execute(SqlFieldsQuery qry) {
        FieldsQueryCursor cursor = this.crd.context().query().querySqlFields(qry, false);
        cursor.getAll();
    }
}

