/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqltests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class BaseSqlTest
extends AbstractIndexingCommonTest {
    public static final long EMP_CNT = 1000L;
    public static final long DEP_CNT = 50L;
    public static final long ADDR_CNT = 500L;
    public static final long FREE_EMP_CNT = 50L;
    public static final long FREE_DEP_CNT = 5L;
    public static final long FREE_ADDR_CNT = 30L;
    public static final int AGES_CNT = 50;
    public static final String CLIENT_NODE_NAME = "clientNode";
    public static final String EMP_CACHE_NAME = "SQL_PUBLIC_EMPLOYEE";
    public static final String DEP_CACHE_NAME = "SQL_PUBLIC_DEPARTMENT";
    public static final String ADDR_CACHE_NAME = "SQL_PUBLIC_ADDRESS";
    protected static IgniteEx client;
    public final String SRV2_NAME = "server2";
    public final String SRV1_NAME = "server1";
    public static final String[] ALL_EMP_FIELDS;
    public static boolean explain;
    protected String DEP_TAB = "Department";
    private Random rnd = new Random();

    private IgniteConfiguration clientConfiguration() throws Exception {
        IgniteConfiguration clCfg = this.getConfiguration(CLIENT_NODE_NAME);
        clCfg.setClientMode(true);
        return this.optimize(clCfg);
    }

    protected void fillCommonData() {
        Long depId;
        SqlFieldsQuery insEmp = new SqlFieldsQuery("INSERT INTO Employee VALUES (?, ?, ?, ?, ?, ?, ?)");
        SqlFieldsQuery insConf = new SqlFieldsQuery("INSERT INTO Address VALUES (?, ?, ?, ?)");
        this.fillDepartmentTable("Department");
        for (long id = 0L; id < 1000L; ++id) {
            depId = this.rnd.nextInt(45);
            if (id < 50L) {
                depId = null;
            }
            String firstName = UUID.randomUUID().toString();
            String lastName = UUID.randomUUID().toString();
            Integer age = this.rnd.nextInt(50) + 18;
            Integer salary = this.rnd.nextInt(50) + 50;
            this.execute(insEmp.setArgs(new Object[]{id, depId, depId, firstName, lastName, age, salary}));
        }
        for (long addrId = 0L; addrId < 500L; ++addrId) {
            depId = this.rnd.nextInt(45);
            if (addrId < 30L) {
                depId = null;
            }
            String address = UUID.randomUUID().toString();
            this.execute(insConf.setArgs(new Object[]{addrId, depId, depId, address}));
        }
    }

    protected void fillDepartmentTable(String tabName) {
        SqlFieldsQuery insDep = new SqlFieldsQuery("INSERT INTO " + tabName + " VALUES (?, ?, ?)");
        for (long id = 0L; id < 50L; ++id) {
            String name = UUID.randomUUID().toString();
            this.execute(insDep.setArgs(new Object[]{id, id, name}));
        }
    }

    protected final void createTables(String commonParams) {
        this.createEmployeeTable(commonParams);
        this.createDepartmentTable(this.DEP_TAB, commonParams);
        this.createAddressTable(commonParams);
    }

    protected void createAddressTable(String commonParams) {
        this.execute("CREATE TABLE Address (id LONG PRIMARY KEY, depId LONG, depIdNoidx LONG, address VARCHAR)" + (F.isEmpty((String)commonParams) ? "" : " WITH \"" + commonParams + "\"") + ";");
        this.execute("CREATE INDEX depIndex ON Address (depId)");
    }

    protected void createDepartmentTable(String depTabName, String commonParams) {
        this.execute("CREATE TABLE " + depTabName + " (id LONG PRIMARY KEY,idNoidx LONG, name VARCHAR) " + (F.isEmpty((String)commonParams) ? "" : " WITH \"" + commonParams + "\"") + ";");
    }

    protected void createEmployeeTable(String commonParams) {
        this.execute("CREATE TABLE Employee (id LONG, depId LONG, depIdNoidx LONG,firstName VARCHAR, lastName VARCHAR, age INT, salary INT, PRIMARY KEY (id, depId)) WITH \"affinity_key=depId" + (F.isEmpty((String)commonParams) ? "" : ", " + commonParams) + "\";");
        this.execute("CREATE INDEX AgeIndex ON Employee (age)");
    }

    protected void setupData() {
        this.createTables("");
        this.fillCommonData();
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid("server1", this.getConfiguration("server1"), null);
        this.startGrid("server2", this.getConfiguration("server2"), null);
        client = (IgniteEx)this.startGrid(CLIENT_NODE_NAME, this.clientConfiguration(), null);
        boolean locExp = explain;
        explain = false;
        this.setupData();
        explain = locExp;
    }

    protected <T> void assertSortedBy(List<T> vals, Comparator<T> cmp) {
        Iterator<T> it = vals.iterator();
        if (!it.hasNext()) {
            return;
        }
        T last = it.next();
        while (it.hasNext()) {
            T cur = it.next();
            if (cmp.compare(last, cur) > 0) {
                throw new AssertionError((Object)("List is not sorted, element '" + last + "' is greater than '" + cur + "'. List: " + vals));
            }
        }
    }

    private static List<String> readColNames(FieldsQueryCursor<?> cursor) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (int i = 0; i < cursor.getColumnsCount(); ++i) {
            colNames.add(cursor.getFieldName(i));
        }
        return Collections.unmodifiableList(colNames);
    }

    protected Result executeFrom(String qry, Ignite node) {
        return this.executeFrom(new SqlFieldsQuery(qry), node);
    }

    protected Result execute(String qry) {
        return this.executeFrom(new SqlFieldsQuery(qry), (Ignite)client);
    }

    protected Result execute(SqlFieldsQuery qry) {
        return this.executeFrom(qry, (Ignite)client);
    }

    protected final Result executeFrom(SqlFieldsQuery qry, Ignite node) {
        if (explain) {
            try {
                SqlFieldsQuery explainQry = new SqlFieldsQuery(qry).setSql("EXPLAIN " + qry.getSql());
                List res = ((IgniteEx)node).context().query().querySqlFields(explainQry, false).getAll();
                String explanation = (String)((List)res.get(0)).get(0);
                if (log.isDebugEnabled()) {
                    log.debug("Node: " + node.name() + ": Execution plan for query " + qry + ":\n" + explanation);
                }
            }
            catch (Exception exc) {
                log.error("Ignoring exception gotten explaining query : " + qry, (Throwable)exc);
            }
        }
        FieldsQueryCursor cursor = ((IgniteEx)node).context().query().querySqlFields(qry, false);
        return Result.fromCursor(cursor);
    }

    protected void assertContainsEq(Collection actual, Collection expected) {
        this.assertContainsEq(null, actual, expected);
    }

    protected void assertContainsEq(String msg, Collection<?> actual, Collection<?> expected) {
        boolean eq;
        if (F.isEmpty((String)msg)) {
            msg = "Assertion failed.";
        }
        boolean bl = eq = actual.size() == expected.size() && actual.containsAll(expected);
        if (!eq) {
            StringBuilder errMsg = new StringBuilder(msg + "\n");
            errMsg.append("\texpectedSize=").append(expected.size()).append("\n");
            errMsg.append("\tactualSize=  ").append(actual.size()).append("\n");
            Collection expectedOnly = BaseSqlTest.removeFromCopy(expected, actual);
            Collection actualOnly = BaseSqlTest.removeFromCopy(actual, expected);
            if (!expectedOnly.isEmpty()) {
                errMsg.append("\texpectedOnly={\n");
                for (Object row : expectedOnly) {
                    errMsg.append("\t\t").append(row).append("\n");
                }
                errMsg.append("\t}\n");
            }
            if (!actualOnly.isEmpty()) {
                errMsg.append("\tactualOnly={\n");
                for (Object row : actualOnly) {
                    errMsg.append("\t\t").append(row).append("\n");
                }
                errMsg.append("\t}\n");
            }
            throw new AssertionError((Object)errMsg.toString());
        }
        if (actual.size() != expected.size()) {
            throw new AssertionError((Object)(msg + " Collections contain different number of elements: [actual=" + actual + ", expected=" + expected + "].\n[uniqActual=]" + BaseSqlTest.removeFromCopy(actual, expected) + ", uniqExpected=" + BaseSqlTest.removeFromCopy(expected, actual) + "]"));
        }
        if (!actual.containsAll(expected)) {
            throw new AssertionError((Object)(msg + " Collections differ: [actual=" + actual + ", expected=" + expected + "].\n[uniqActual=]" + BaseSqlTest.removeFromCopy(actual, expected) + ", uniqExpected=" + BaseSqlTest.removeFromCopy(expected, actual) + "]"));
        }
    }

    private static Collection removeFromCopy(Collection<?> from, Collection<?> toRemove) {
        ArrayList fromCp = new ArrayList(from);
        for (Object item : toRemove) {
            fromCp.remove(item);
        }
        return fromCp;
    }

    protected static <K, V> List<List<Object>> select(IgniteCache<K, V> cache, @Nullable IgnitePredicate<Map<String, Object>> filter, String ... fields) {
        IgniteClosure & Serializable fieldsExtractor = (IgniteClosure & Serializable)row -> {
            ArrayList res = new ArrayList();
            for (String field : fields) {
                String normField = field.toUpperCase();
                if (!row.containsKey(normField)) {
                    throw new RuntimeException("Field with name " + normField + " not found in the table. Avaliable fields: " + row.keySet());
                }
                Object val = row.get(normField);
                res.add(val);
            }
            return res;
        };
        return BaseSqlTest.select(cache, filter, fieldsExtractor);
    }

    protected static <K, V, R> List<R> select(IgniteCache<K, V> cache, @Nullable IgnitePredicate<Map<String, Object>> filter, IgniteClosure<Map<String, Object>, R> transformer) {
        Collection entities = ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getQueryEntities();
        assert (entities.size() == 1) : "Cache should contain exactly one table";
        QueryEntity meta = (QueryEntity)entities.iterator().next();
        IgniteClosure & Serializable transformerAdapter = (IgniteClosure & Serializable)entry -> {
            Map<String, Object> row = BaseSqlTest.entryToMap(meta, entry.getKey(), entry.getValue());
            return transformer.apply(row);
        };
        IgniteBiPredicate & Serializable filterAdapter = filter == null ? null : (IgniteBiPredicate & Serializable)(key, val) -> filter.apply(BaseSqlTest.entryToMap(meta, key, val));
        QueryCursor cursor = cache.withKeepBinary().query((Query)new ScanQuery((IgniteBiPredicate)filterAdapter), (IgniteClosure)transformerAdapter);
        return cursor.getAll();
    }

    private static Map<String, Object> entryToMap(QueryEntity meta, Object key, Object val) {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        if (key instanceof BinaryObject) {
            BinaryObject compositeKey = (BinaryObject)key;
            for (String field : compositeKey.type().fieldNames()) {
                row.put(field, compositeKey.field(field));
            }
        } else {
            row.put(meta.getKeyFieldName(), key);
        }
        if (val instanceof BinaryObject) {
            BinaryObject compositeVal = (BinaryObject)val;
            for (String field : compositeVal.type().fieldNames()) {
                row.put(field, compositeVal.field(field));
            }
        } else {
            row.put(meta.getValueFieldName(), val);
        }
        return row;
    }

    public static Set<Object> distinct(Collection<?> src) {
        return new HashSet<Object>(src);
    }

    protected void testAllNodes(Consumer<Ignite> consumer) {
        for (Ignite node : Ignition.allGrids()) {
            log.info("Testing on node " + node.name() + '.');
            consumer.accept(node);
            log.info("Testing on node " + node.name() + " is done.");
        }
    }

    @Test
    public void testBasicSelect() {
        this.testAllNodes(node -> {
            Result emps = this.executeFrom("SELECT * FROM Employee", (Ignite)node);
            this.assertContainsEq("SELECT * returned unexpected column names.", emps.columnNames(), Arrays.asList(ALL_EMP_FIELDS));
            List<List<Object>> expEmps = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), null, emps.columnNames().toArray(new String[0]));
            this.assertContainsEq(emps.values(), expEmps);
        });
    }

    @Test
    public void testSelectFields() {
        this.testAllNodes(node -> {
            Result res = this.executeFrom("SELECT firstName, id, age FROM Employee;", (Ignite)node);
            String[] fields = new String[]{"FIRSTNAME", "ID", "AGE"};
            BaseSqlTest.assertEquals((String)"Returned column names are incorrect.", res.columnNames(), Arrays.asList(fields));
            List<List<Object>> expected = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), null, fields);
            this.assertContainsEq(res.values(), expected);
        });
    }

    @Test
    public void testSelectBetween() {
        this.testAllNodes(node -> {
            Result emps = this.executeFrom("SELECT * FROM Employee e WHERE e.id BETWEEN 101 and 200", (Ignite)node);
            BaseSqlTest.assertEquals((String)"Fetched number of employees is incorrect", (int)100, (int)emps.values().size());
            String[] fields = emps.columnNames().toArray(new String[0]);
            this.assertContainsEq("SELECT * returned unexpected column names.", emps.columnNames(), Arrays.asList(ALL_EMP_FIELDS));
            IgnitePredicate & Serializable between = (IgnitePredicate & Serializable)row -> {
                long id = (Long)row.get("ID");
                return 101L <= id && id <= 200L;
            };
            List<List<Object>> expected = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), (IgnitePredicate<Map<String, Object>>)between, fields);
            this.assertContainsEq(emps.values(), expected);
        });
    }

    @Test
    public void testEmptyBetween() {
        this.testAllNodes(node -> {
            Result emps = this.executeFrom("SELECT * FROM Employee e WHERE e.id BETWEEN 200 AND 101", (Ignite)node);
            BaseSqlTest.assertTrue((String)("SQL should have returned empty result set, but it have returned: " + emps), (boolean)emps.values().isEmpty());
        });
    }

    @Test
    public void testSelectInStatic() {
        this.testAllNodes(node -> {
            Result actual = this.executeFrom("SELECT age FROM Employee WHERE id IN (1, 256, 42)", (Ignite)node);
            List<List<Object>> expected = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> {
                Object id = row.get("ID");
                return F.eq(id, (Object)1L) || F.eq(id, (Object)256L) || F.eq(id, (Object)42L);
            }, "AGE");
            this.assertContainsEq(actual.values(), expected);
        });
    }

    @Test
    public void testSelectInSubquery() {
        this.testAllNodes(node -> {
            Result actual = this.executeFrom("SELECT lastName FROM Employee WHERE id in (SELECT id FROM Employee WHERE age < 30)", (Ignite)node);
            List<List<Object>> expected = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Integer)row.get("AGE") < 30, "lastName");
            this.assertContainsEq(actual.values(), expected);
        });
    }

    @Test
    public void testBasicOrderByLastName() {
        this.testAllNodes(node -> {
            Result result = this.executeFrom("SELECT * FROM Employee e ORDER BY e.lastName", (Ignite)node);
            List<List<Object>> exp = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), null, result.columnNames().toArray(new String[0]));
            this.assertContainsEq(result.values(), exp);
            int lastNameIdx = result.columnNames().indexOf("LASTNAME");
            Comparator<List> asc = Comparator.comparing(row -> (String)row.get(lastNameIdx));
            this.assertSortedBy(result.values(), asc);
        });
    }

    @Test
    public void testBasicDistinct() {
        this.testAllNodes(node -> {
            Result ages = this.executeFrom("SELECT DISTINCT age FROM Employee", (Ignite)node);
            Set<Object> expected = BaseSqlTest.distinct(BaseSqlTest.select(node.cache(EMP_CACHE_NAME), null, "age"));
            this.assertContainsEq("Values in cache differ from values returned from sql.", ages.values(), expected);
        });
    }

    @Test
    public void testDistinctWithWhere() {
        this.testAllNodes(node -> {
            Result ages = this.executeFrom("SELECT DISTINCT age FROM Employee WHERE id < 100", (Ignite)node);
            Set<Object> expAges = BaseSqlTest.distinct(BaseSqlTest.select(node.cache(EMP_CACHE_NAME), (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Long)row.get("ID") < 100L, "age"));
            this.assertContainsEq(ages.values(), expAges);
        });
    }

    @Test
    public void testWhereGreater() {
        this.testAllNodes(node -> {
            Result idxActual = this.executeFrom("SELECT firstName FROM Employee WHERE age > 30", (Ignite)node);
            Result noidxActual = this.executeFrom("SELECT firstName FROM Employee WHERE salary > 75", (Ignite)node);
            IgniteCache cache = node.cache(EMP_CACHE_NAME);
            List<List<Object>> idxExp = BaseSqlTest.select(cache, (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Integer)row.get("AGE") > 30, "firstName");
            List<List<Object>> noidxExp = BaseSqlTest.select(cache, (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Integer)row.get("SALARY") > 75, "firstName");
            this.assertContainsEq(idxActual.values(), idxExp);
            this.assertContainsEq(noidxActual.values(), noidxExp);
        });
    }

    @Test
    public void testWhereLess() {
        this.testAllNodes(node -> {
            Result idxActual = this.executeFrom("SELECT firstName FROM Employee WHERE age < 30", (Ignite)node);
            Result noidxActual = this.executeFrom("SELECT firstName FROM Employee WHERE salary < 75", (Ignite)node);
            IgniteCache cache = node.cache(EMP_CACHE_NAME);
            List<List<Object>> idxExp = BaseSqlTest.select(cache, (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Integer)row.get("AGE") < 30, "firstName");
            List<List<Object>> noidxExp = BaseSqlTest.select(cache, (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Integer)row.get("SALARY") < 75, "firstName");
            this.assertContainsEq(idxActual.values(), idxExp);
            this.assertContainsEq(noidxActual.values(), noidxExp);
        });
    }

    @Test
    public void testWhereEq() {
        this.testAllNodes(node -> {
            Result idxActual = this.executeFrom("SELECT firstName FROM Employee WHERE age = 30", (Ignite)node);
            Result noidxActual = this.executeFrom("SELECT firstName FROM Employee WHERE salary = 75", (Ignite)node);
            IgniteCache cache = node.cache(EMP_CACHE_NAME);
            List<List<Object>> idxExp = BaseSqlTest.select(cache, (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Integer)row.get("AGE") == 30, "firstName");
            List<List<Object>> noidxExp = BaseSqlTest.select(cache, (IgnitePredicate<Map<String, Object>>)(IgnitePredicate & Serializable)row -> (Integer)row.get("SALARY") == 75, "firstName");
            this.assertContainsEq(idxActual.values(), idxExp);
            this.assertContainsEq(noidxActual.values(), noidxExp);
        });
    }

    @Test
    public void testGroupByIndexedField() {
        this.testAllNodes(node -> {
            int avgAge = 20;
            Result result = this.executeFrom("SELECT age, COUNT(*) FROM Employee GROUP BY age HAVING COUNT(*) > 20", (Ignite)node);
            List<List<Object>> all = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), null, "age");
            HashMap<Integer, Long> cntGroups = new HashMap<Integer, Long>();
            for (List<Object> entry : all) {
                Integer age = (Integer)entry.get(0);
                long cnt = cntGroups.getOrDefault(age, 0L);
                cntGroups.put(age, cnt + 1L);
            }
            List expected = cntGroups.entrySet().stream().filter(ent -> (Long)ent.getValue() > 20L).map(ent -> Arrays.asList(ent.getKey(), ent.getValue())).collect(Collectors.toList());
            this.assertContainsEq(result.values(), expected);
        });
    }

    @Test
    public void testGroupByNonIndexedField() {
        this.testAllNodes(node -> {
            int avgDep = 21;
            Result result = this.executeFrom("SELECT depId, COUNT(*) FROM Employee GROUP BY depIdNoidx HAVING COUNT(*) > 21", (Ignite)node);
            List<List<Object>> all = BaseSqlTest.select(node.cache(EMP_CACHE_NAME), null, "depId");
            HashMap<Long, Long> cntGroups = new HashMap<Long, Long>();
            for (List<Object> entry : all) {
                Long depId = (Long)entry.get(0);
                long cnt = cntGroups.getOrDefault(depId, 0L);
                cntGroups.put(depId, cnt + 1L);
            }
            List expected = cntGroups.entrySet().stream().filter(ent -> (Long)ent.getValue() > 21L).map(ent -> Arrays.asList(ent.getKey(), ent.getValue())).collect(Collectors.toList());
            this.assertContainsEq(result.values(), expected);
        });
    }

    public static <R> List<R> doCommonJoin(IgniteCache<?, ?> left, IgniteCache<?, ?> right, IgniteBiPredicate<Map<String, Object>, Map<String, Object>> filter, IgniteBiClosure<Map<String, Object>, Map<String, Object>, R> transformer, boolean outerLeft, boolean outerRight) {
        List<Map> leftTab = BaseSqlTest.select(left, null, (IgniteClosure & Serializable)x -> x);
        List<Map> rightTab = BaseSqlTest.select(right, null, (IgniteClosure & Serializable)x -> x);
        Map nullRow = Collections.emptyMap();
        ArrayList<Object> join = new ArrayList<Object>();
        Set<Map> notFoundRight = Collections.newSetFromMap(new IdentityHashMap());
        notFoundRight.addAll(rightTab);
        for (Map lRow : leftTab) {
            boolean foundLeft = false;
            for (Map rRow : rightTab) {
                if (!filter.apply((Object)lRow, (Object)rRow)) continue;
                foundLeft = true;
                notFoundRight.remove(rRow);
                join.add(transformer.apply((Object)lRow, (Object)rRow));
            }
            if (foundLeft || !outerLeft) continue;
            join.add(transformer.apply((Object)lRow, nullRow));
        }
        if (outerRight) {
            for (Map rRow : notFoundRight) {
                join.add(transformer.apply(nullRow, (Object)rRow));
            }
        }
        return join;
    }

    protected static <R> List<R> doRightJoin(IgniteCache<?, ?> left, IgniteCache<?, ?> right, IgniteBiPredicate<Map<String, Object>, Map<String, Object>> filter, IgniteBiClosure<Map<String, Object>, Map<String, Object>, R> transformer) {
        return BaseSqlTest.doCommonJoin(left, right, filter, transformer, false, true);
    }

    protected static <R> List<R> doLeftJoin(IgniteCache<?, ?> left, IgniteCache<?, ?> right, IgniteBiPredicate<Map<String, Object>, Map<String, Object>> filter, IgniteBiClosure<Map<String, Object>, Map<String, Object>, R> transformer) {
        return BaseSqlTest.doCommonJoin(left, right, filter, transformer, true, false);
    }

    protected static <R> List<R> doInnerJoin(IgniteCache<?, ?> left, IgniteCache<?, ?> right, IgniteBiPredicate<Map<String, Object>, Map<String, Object>> filter, IgniteBiClosure<Map<String, Object>, Map<String, Object>, R> transformer) {
        return BaseSqlTest.doCommonJoin(left, right, filter, transformer, false, false);
    }

    protected void assertDistJoinHasIncorrectIndex(Callable<?> joinCmd) {
        GridTestUtils.assertThrows((IgniteLogger)log, joinCmd, CacheException.class, (String)"Failed to prepare distributed join query: join condition does not use index");
    }

    public void checkInnerJoinEmployeeDepartment(String depTab) {
        Arrays.asList(true, false).forEach(forceOrd -> this.testAllNodes(node -> {
            String qryTpl = "SELECT e.id as EmpId, e.firstName as EmpName, d.id as DepId, d.name as DepName FROM Employee e INNER JOIN " + depTab + " d ON e.%s = d.%s";
            Result actIdxOnOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "id"), (Ignite)node);
            Result actIdxOnOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "idNoidx"), (Ignite)node);
            Result actIdxOffOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "id"), (Ignite)node);
            Result actIdxOffOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "idNoidx"), (Ignite)node);
            List expected = BaseSqlTest.doInnerJoin(node.cache(EMP_CACHE_NAME), node.cache(BaseSqlTest.cacheName(depTab)), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(emp, dep) -> BaseSqlTest.sqlEq(emp.get("DEPID"), dep.get("ID")), (IgniteBiClosure & Serializable)(emp, dep) -> Arrays.asList(emp.get("ID"), emp.get("FIRSTNAME"), dep.get("ID"), dep.get("NAME")));
            this.assertContainsEq("Join on idx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOn.values(), expected);
            this.assertContainsEq("Join on idx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOff.values(), expected);
            this.assertContainsEq("Join on noidx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOn.values(), expected);
            this.assertContainsEq("Join on noidx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOff.values(), expected);
        }));
    }

    @Test
    public void testInnerJoinEmployeeDepartment() {
        this.checkInnerJoinEmployeeDepartment(this.DEP_TAB);
    }

    public void checkInnerJoinDepartmentEmployee(String depTab) {
        Arrays.asList(true, false).forEach(forceOrd -> this.testAllNodes(node -> {
            String qryTpl = "SELECT e.id as EmpId, e.firstName as EmpName, d.id as DepId, d.name as DepName FROM " + depTab + " d INNER JOIN Employee e ON e.%s = d.%s";
            Result actIdxOnOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "id"), (Ignite)node);
            Result actIdxOnOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "idNoidx"), (Ignite)node);
            Result actIdxOffOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "id"), (Ignite)node);
            Result actIdxOffOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "idNoidx"), (Ignite)node);
            List expected = BaseSqlTest.doInnerJoin(node.cache(EMP_CACHE_NAME), node.cache(BaseSqlTest.cacheName(depTab)), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(emp, dep) -> BaseSqlTest.sqlEq(emp.get("DEPID"), dep.get("ID")), (IgniteBiClosure & Serializable)(emp, dep) -> Arrays.asList(emp.get("ID"), emp.get("FIRSTNAME"), dep.get("ID"), dep.get("NAME")));
            this.assertContainsEq("Join on idx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOn.values(), expected);
            this.assertContainsEq("Join on idx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOff.values(), expected);
            this.assertContainsEq("Join on noidx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOn.values(), expected);
            this.assertContainsEq("Join on noidx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOff.values(), expected);
        }));
    }

    public void checkLeftJoinEmployeeDepartment(String depTab) {
        Arrays.asList(true, false).forEach(forceOrd -> this.testAllNodes(node -> {
            String qryTpl = "SELECT e.id as EmpId, e.firstName as EmpName, d.id as DepId, d.name as DepName FROM Employee e LEFT JOIN " + depTab + " d ON e.%s = d.%s";
            Result actIdxOnOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "id"), (Ignite)node);
            Result actIdxOnOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "idNoidx"), (Ignite)node);
            Result actIdxOffOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "id"), (Ignite)node);
            Result actIdxOffOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "idNoidx"), (Ignite)node);
            List expected = BaseSqlTest.doLeftJoin(node.cache(EMP_CACHE_NAME), node.cache(BaseSqlTest.cacheName(depTab)), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(emp, dep) -> BaseSqlTest.sqlEq(emp.get("DEPID"), dep.get("ID")), (IgniteBiClosure & Serializable)(emp, dep) -> Arrays.asList(emp.get("ID"), emp.get("FIRSTNAME"), dep.get("ID"), dep.get("NAME")));
            this.assertContainsEq("Join on idx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOn.values(), expected);
            this.assertContainsEq("Join on idx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOff.values(), expected);
            this.assertContainsEq("Join on noidx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOn.values(), expected);
            this.assertContainsEq("Join on noidx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOff.values(), expected);
        }));
    }

    public void checkLeftJoinDepartmentEmployee(String depTab) {
        Arrays.asList(true, false).forEach(forceOrd -> this.testAllNodes(node -> {
            String qryTpl = "SELECT e.id as EmpId, e.firstName as EmpName, d.id as DepId, d.name as DepName FROM " + depTab + " d LEFT JOIN Employee e ON e.%s = d.%s";
            Result actIdxOnOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "id"), (Ignite)node);
            Result actIdxOnOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "idNoidx"), (Ignite)node);
            Result actIdxOffOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "id"), (Ignite)node);
            Result actIdxOffOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "idNoidx"), (Ignite)node);
            List expected = BaseSqlTest.doLeftJoin(node.cache(BaseSqlTest.cacheName(depTab)), node.cache(EMP_CACHE_NAME), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, emp) -> BaseSqlTest.sqlEq(emp.get("DEPID"), dep.get("ID")), (IgniteBiClosure & Serializable)(dep, emp) -> Arrays.asList(emp.get("ID"), emp.get("FIRSTNAME"), dep.get("ID"), dep.get("NAME")));
            this.assertContainsEq("Join on idx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOn.values(), expected);
            this.assertContainsEq("Join on idx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOff.values(), expected);
            this.assertContainsEq("Join on noidx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOn.values(), expected);
            this.assertContainsEq("Join on noidx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOff.values(), expected);
        }));
    }

    @Test
    public void testLeftJoin() {
        this.checkLeftJoinEmployeeDepartment(this.DEP_TAB);
    }

    public void checkRightJoinEmployeeDepartment(String depTab) {
        Arrays.asList(true, false).forEach(forceOrd -> this.testAllNodes(node -> {
            String qryTpl = "SELECT e.id as EmpId, e.firstName as EmpName, d.id as DepId, d.name as DepName FROM Employee e RIGHT JOIN " + depTab + " d ON e.%s = d.%s";
            Result actIdxOnOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "id"), (Ignite)node);
            Result actIdxOnOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "idNoidx"), (Ignite)node);
            Result actIdxOffOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "id"), (Ignite)node);
            Result actIdxOffOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "idNoidx"), (Ignite)node);
            List expected = BaseSqlTest.doRightJoin(node.cache(EMP_CACHE_NAME), node.cache(BaseSqlTest.cacheName(depTab)), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(emp, dep) -> BaseSqlTest.sqlEq(emp.get("DEPID"), dep.get("ID")), (IgniteBiClosure & Serializable)(emp, dep) -> Arrays.asList(emp.get("ID"), emp.get("FIRSTNAME"), dep.get("ID"), dep.get("NAME")));
            this.assertContainsEq("Join on idx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOn.values(), expected);
            this.assertContainsEq("Join on idx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOff.values(), expected);
            this.assertContainsEq("Join on noidx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOn.values(), expected);
            this.assertContainsEq("Join on noidx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOff.values(), expected);
        }));
    }

    public void checkRightJoinDepartmentEmployee(String depTab) {
        Arrays.asList(true, false).forEach(forceOrd -> this.testAllNodes(node -> {
            String qryTpl = "SELECT e.id as EmpId, e.firstName as EmpName, d.id as DepId, d.name as DepName FROM " + depTab + " d RIGHT JOIN Employee e ON e.%s = d.%s";
            Result actIdxOnOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "id"), (Ignite)node);
            Result actIdxOnOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depId", "idNoidx"), (Ignite)node);
            Result actIdxOffOn = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "id"), (Ignite)node);
            Result actIdxOffOff = this.executeFrom(BaseSqlTest.joinQry(forceOrd, qryTpl, "depIdNoidx", "idNoidx"), (Ignite)node);
            List expected = BaseSqlTest.doRightJoin(node.cache(BaseSqlTest.cacheName(depTab)), node.cache(EMP_CACHE_NAME), (IgniteBiPredicate<Map<String, Object>, Map<String, Object>>)(IgniteBiPredicate & Serializable)(dep, emp) -> BaseSqlTest.sqlEq(emp.get("DEPID"), dep.get("ID")), (IgniteBiClosure & Serializable)(dep, emp) -> Arrays.asList(emp.get("ID"), emp.get("FIRSTNAME"), dep.get("ID"), dep.get("NAME")));
            this.assertContainsEq("Join on idx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOn.values(), expected);
            this.assertContainsEq("Join on idx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOnOff.values(), expected);
            this.assertContainsEq("Join on noidx = idx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOn.values(), expected);
            this.assertContainsEq("Join on noidx = noidx is incorrect. Preserve join order = " + forceOrd + ".", actIdxOffOff.values(), expected);
        }));
    }

    @Test
    public void testRightJoin() {
        this.checkRightJoinEmployeeDepartment(this.DEP_TAB);
    }

    @Test
    public void testFullOuterJoinIsNotSupported() {
        this.testAllNodes(node -> {
            String fullOuterJoinQry = "SELECT e.id as EmpId, e.firstName as EmpName, d.id as DepId, d.name as DepName FROM Employee e FULL OUTER JOIN Department d ON e.depId = d.id";
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.executeFrom(fullOuterJoinQry, (Ignite)node), IgniteSQLException.class, (String)"Failed to parse query.");
            String fullOuterJoinSubquery = "SELECT EmpId from (" + fullOuterJoinQry + ")";
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.executeFrom(fullOuterJoinSubquery, (Ignite)node), IgniteSQLException.class, (String)"Failed to parse query.");
        });
    }

    @Test
    public void testFullOuterDistributedJoinIsNotSupported() {
        this.testAllNodes(node -> {
            String qry = "SELECT d.id, d.name, a.address FROM Department d FULL OUTER JOIN Address a ON d.idNoidx = a.depIdNoidx";
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.executeFrom(BaseSqlTest.distributedJoinQry(false, qry, new Object[0]), (Ignite)node), IgniteSQLException.class, (String)"Failed to parse query.");
        });
    }

    public static boolean sqlEq(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static void setExplain(boolean shouldExplain) {
        explain = shouldExplain;
    }

    static String cacheName(String tabName) {
        return "SQL_PUBLIC_" + tabName.toUpperCase();
    }

    static SqlFieldsQuery joinQry(boolean enforceJoinOrder, String tpl, Object ... args) {
        return new SqlFieldsQuery(String.format(tpl, args)).setEnforceJoinOrder(enforceJoinOrder);
    }

    static SqlFieldsQuery distributedJoinQry(boolean enforceJoinOrder, String tpl, Object ... args) {
        return BaseSqlTest.joinQry(enforceJoinOrder, tpl, args).setDistributedJoins(true);
    }

    static {
        ALL_EMP_FIELDS = new String[]{"ID", "DEPID", "DEPIDNOIDX", "FIRSTNAME", "LASTNAME", "AGE", "SALARY"};
        explain = false;
    }

    static class Result {
        private List<String> colNames;
        private List<List<?>> vals;

        public Result(List<String> colNames, List<List<?>> vals) {
            this.colNames = colNames;
            this.vals = vals;
        }

        public List<String> columnNames() {
            return this.colNames;
        }

        public List<List<?>> values() {
            return this.vals;
        }

        public static Result fromCursor(FieldsQueryCursor<List<?>> cursor) {
            List cols = BaseSqlTest.readColNames(cursor);
            List vals = cursor.getAll();
            return new Result(cols, vals);
        }
    }
}

