/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.timeout;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;

public class TimedQueryHelper {
    private static final int ROW_COUNT = 250;
    private final long executionTime;
    private final String cacheName;

    public TimedQueryHelper(long executionTime, String cacheName) {
        assert (executionTime >= 250L);
        this.executionTime = executionTime;
        this.cacheName = cacheName;
    }

    public void createCache(Ignite ign) {
        IgniteCache cache = ign.createCache(new CacheConfiguration(this.cacheName).setSqlSchema("PUBLIC").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, Integer.class).setTableName(this.cacheName))).setSqlFunctionClasses(new Class[]{TimedQueryHelper.class}));
        Map entries = IntStream.range(0, 250).boxed().collect(Collectors.toMap(Function.identity(), Function.identity()));
        cache.putAll(entries);
    }

    public String buildTimedQuery() {
        long rowTimeout = this.executionTime / 250L;
        return "select longProcess(_val, " + rowTimeout + ") from " + this.cacheName;
    }

    public String buildTimedUpdateQuery() {
        long rowTimeout = this.executionTime / 250L;
        return "update " + this.cacheName + " set _val = longProcess(_val, " + rowTimeout + ")";
    }

    @QuerySqlFunction
    public static int longProcess(int i, long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return i;
    }
}

