/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.timeout;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.timeout.AbstractDefaultQueryTimeoutTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DefaultQueryTimeoutThickJavaTest
extends AbstractDefaultQueryTimeoutTest {
    @Parameterized.Parameter(value=0)
    public boolean lazy;
    @Parameterized.Parameter(value=1)
    public boolean update;
    @Parameterized.Parameter(value=2)
    public boolean local;

    @Parameterized.Parameters(name="lazy={0}, update={1}, local={2}")
    public static List<Object[]> parameters() {
        boolean[] arrBool;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (boolean lazy0 : arrBool = new boolean[]{true, false}) {
            for (boolean update0 : arrBool) {
                for (boolean local0 : arrBool) {
                    if (local0 && update0) continue;
                    params.add(new Object[]{lazy0, update0, local0});
                }
            }
        }
        return params;
    }

    @Override
    protected void prepareQueryExecution() throws Exception {
        super.prepareQueryExecution();
        this.startClientGrid("cli");
    }

    @Override
    protected void executeQuery(String sql) throws Exception {
        this.executeQuery0(new SqlFieldsQuery(sql));
    }

    @Override
    protected void executeQuery(String sql, int timeout) throws Exception {
        this.executeQuery0(new SqlFieldsQuery(sql).setTimeout(timeout, TimeUnit.MILLISECONDS));
    }

    @Override
    protected void assertQueryCancelled(Callable<?> c) {
        GridTestUtils.assertThrows((IgniteLogger)log, c, Exception.class, (String)"cancel");
    }

    @Override
    protected boolean updateQuery() {
        return this.update;
    }

    private void executeQuery0(SqlFieldsQuery qry) throws Exception {
        qry.setLazy(this.lazy);
        qry.setLocal(this.local);
        IgniteEx ign = this.local ? this.grid(0) : this.grid("cli");
        ign.context().query().querySqlFields(qry, false).getAll();
    }
}

