/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.hll;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.internal.processors.query.stat.hll.HLL;
import org.apache.ignite.internal.processors.query.stat.hll.HLLType;
import org.apache.ignite.internal.processors.query.stat.hll.ProbabilisticTestUtil;
import org.apache.ignite.internal.processors.query.stat.hll.serialization.ISchemaVersion;
import org.apache.ignite.internal.processors.query.stat.hll.serialization.SerializationUtil;
import org.apache.ignite.internal.processors.query.stat.hll.util.BitVector;
import org.apache.ignite.internal.processors.query.stat.hll.util.HLLUtil;
import org.apache.ignite.internal.processors.query.stat.hll.util.LongIterator;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class FullHLLTest {
    @Test
    public void smallRangeSmokeTest() {
        int log2m = 11;
        int m = 2048;
        int regwidth = 5;
        HLL hll = new HLL(11, 5, 128, 256, HLLType.FULL);
        hll.addRaw(ProbabilisticTestUtil.constructHLLValue(11, 0, 1));
        long cardinality = hll.cardinality();
        long expected = (long)Math.ceil(2048.0 * Math.log(1.0004885197850513));
        Assert.assertEquals((long)cardinality, (long)expected);
        hll = new HLL(11, 5, 128, 256, HLLType.FULL);
        for (int i = 0; i < 2047; ++i) {
            hll.addRaw(ProbabilisticTestUtil.constructHLLValue(11, i, 1));
        }
        cardinality = hll.cardinality();
        expected = (long)Math.ceil(2048.0 * Math.log(2048.0));
        Assert.assertEquals((long)cardinality, (long)expected);
    }

    @Test
    public void normalRangeSmokeTest() {
        int log2m = 11;
        int regwidth = 5;
        int l = 41;
        int m = 2048;
        HLL hll = new HLL(11, 5, 128, 256, HLLType.FULL);
        int registerValue = 7;
        for (int i = 0; i < 2048; ++i) {
            hll.addRaw(ProbabilisticTestUtil.constructHLLValue(11, i, 7));
        }
        long cardinality = hll.cardinality();
        double estimator = HLLUtil.alphaMSquared((int)2048) / (2048.0 / Math.pow(2.0, 7.0));
        Assert.assertTrue((estimator <= Math.pow(2.0, 41.0) / 30.0 ? 1 : 0) != 0);
        Assert.assertTrue((estimator > 5120.0 ? 1 : 0) != 0);
        long expected = (long)Math.ceil(estimator);
        Assert.assertEquals((long)cardinality, (long)expected);
    }

    @Test
    public void largeRangeSmokeTest() {
        int log2m = 12;
        int regwidth = 5;
        int l = 42;
        int m = 4096;
        HLL hll = new HLL(12, 5, 128, 256, HLLType.FULL);
        int registerValue = 31;
        for (int i = 0; i < 4096; ++i) {
            hll.addRaw(ProbabilisticTestUtil.constructHLLValue(12, i, 31));
        }
        long cardinality = hll.cardinality();
        double estimator = HLLUtil.alphaMSquared((int)4096) / (4096.0 / Math.pow(2.0, 31.0));
        Assert.assertTrue((estimator > Math.pow(2.0, 42.0) / 30.0 ? 1 : 0) != 0);
        long expected = (long)Math.ceil(-1.0 * Math.pow(2.0, 42.0) * Math.log(1.0 - estimator / Math.pow(2.0, 42.0)));
        Assert.assertEquals((long)cardinality, (long)expected);
    }

    @Test
    public void registerValueTest() {
        int log2m = 4;
        int regwidth = 4;
        HLL hll = new HLL(4, 4, 128, 256, HLLType.FULL);
        BitVector bitVector = (BitVector)GridTestUtils.getFieldValue((Object)hll, (String[])new String[]{"probabilisticStorage"});
        hll.addRaw(1L);
        Assert.assertEquals((long)bitVector.getRegister(1L), (long)0L);
        hll.addRaw(18L);
        Assert.assertEquals((long)bitVector.getRegister(2L), (long)1L);
        hll.addRaw(35L);
        Assert.assertEquals((long)bitVector.getRegister(3L), (long)2L);
        hll.addRaw(68L);
        Assert.assertEquals((long)bitVector.getRegister(4L), (long)3L);
        hll.addRaw(133L);
        Assert.assertEquals((long)bitVector.getRegister(5L), (long)4L);
        hll.addRaw(65542L);
        Assert.assertEquals((long)bitVector.getRegister(6L), (long)13L);
        hll.addRaw(131079L);
        Assert.assertEquals((long)bitVector.getRegister(7L), (long)14L);
        hll.addRaw(262152L);
        Assert.assertEquals((long)bitVector.getRegister(8L), (long)15L);
        hll.addRaw(524297L);
        Assert.assertEquals((long)bitVector.getRegister(9L), (long)15L);
        hll.addRaw(196618L);
        Assert.assertEquals((long)bitVector.getRegister(10L), (long)13L);
        hll.addRaw(0x11000BL);
        Assert.assertEquals((long)bitVector.getRegister(11L), (long)13L);
        regwidth = 5;
        hll = new HLL(4, 5, 128, 256, HLLType.FULL);
        bitVector = (BitVector)GridTestUtils.getFieldValue((Object)hll, (String[])new String[]{"probabilisticStorage"});
        hll.addRaw(1L);
        Assert.assertEquals((long)bitVector.getRegister(1L), (long)0L);
        hll.addRaw(18L);
        Assert.assertEquals((long)bitVector.getRegister(2L), (long)1L);
        hll.addRaw(35L);
        Assert.assertEquals((long)bitVector.getRegister(3L), (long)2L);
        hll.addRaw(68L);
        Assert.assertEquals((long)bitVector.getRegister(4L), (long)3L);
        hll.addRaw(133L);
        Assert.assertEquals((long)bitVector.getRegister(5L), (long)4L);
        hll.addRaw(0x100000006L);
        Assert.assertEquals((long)bitVector.getRegister(6L), (long)29L);
        hll.addRaw(0x200000007L);
        Assert.assertEquals((long)bitVector.getRegister(7L), (long)30L);
        hll.addRaw(0x400000008L);
        Assert.assertEquals((long)bitVector.getRegister(8L), (long)31L);
        hll.addRaw(0x800000009L);
        Assert.assertEquals((long)bitVector.getRegister(9L), (long)31L);
    }

    @Test
    public void clearTest() {
        int i;
        int regwidth = 5;
        int log2m = 4;
        int m = 16;
        HLL hll = new HLL(4, 5, 128, 256, HLLType.FULL);
        BitVector bitVector = (BitVector)GridTestUtils.getFieldValue((Object)hll, (String[])new String[]{"probabilisticStorage"});
        for (i = 0; i < 16; ++i) {
            bitVector.setRegister((long)i, (long)i);
        }
        hll.clear();
        for (i = 0; i < 16; ++i) {
            Assert.assertEquals((long)bitVector.getRegister((long)i), (long)0L);
        }
    }

    @Test
    public void toFromBytesTest() {
        int log2m = 11;
        int regwidth = 5;
        ISchemaVersion schemaVersion = SerializationUtil.DEFAULT_SCHEMA_VERSION;
        HLLType type = HLLType.FULL;
        int padding = schemaVersion.paddingBytes(type);
        int dataByteCount = ProbabilisticTestUtil.getRequiredBytes(5, 2048);
        int expectedByteCount = padding + dataByteCount;
        HLL hll = new HLL(11, 5, 128, 256, HLLType.FULL);
        byte[] bytes = hll.toBytes(schemaVersion);
        Assert.assertEquals((long)bytes.length, (long)expectedByteCount);
        HLL inHLL = HLL.fromBytes((byte[])bytes);
        FullHLLTest.assertElementsEqual(hll, inHLL);
        hll = new HLL(11, 5, 128, 256, HLLType.FULL);
        for (int i = 0; i < 3; ++i) {
            long rawValue = ProbabilisticTestUtil.constructHLLValue(11, i, i + 9);
            hll.addRaw(rawValue);
        }
        bytes = hll.toBytes(schemaVersion);
        Assert.assertEquals((long)bytes.length, (long)expectedByteCount);
        inHLL = HLL.fromBytes((byte[])bytes);
        FullHLLTest.assertElementsEqual(hll, inHLL);
        hll = new HLL(11, 5, 128, 256, HLLType.FULL);
        for (int i = 0; i < 2048; ++i) {
            long rawValue = ProbabilisticTestUtil.constructHLLValue(11, i, i % 9 + 1);
            hll.addRaw(rawValue);
        }
        bytes = hll.toBytes(schemaVersion);
        Assert.assertEquals((long)bytes.length, (long)expectedByteCount);
        inHLL = HLL.fromBytes((byte[])bytes);
        FullHLLTest.assertElementsEqual(hll, inHLL);
    }

    @Test
    public void unionTest() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        HLL hll = new HLL(13, 5);
        hll.addRaw(((Random)r).nextLong());
    }

    @Test
    public void homogeneousUnionTest() {
        FullHLLTest.getHll(1).union(FullHLLTest.getHll(1));
        FullHLLTest.getHll(1000).union(FullHLLTest.getHll(1000));
        FullHLLTest.getHll(100000).union(FullHLLTest.getHll(100000));
    }

    @Test
    public void emptyUnionTest() {
        FullHLLTest.getHll(0).union(FullHLLTest.getHll(0));
        FullHLLTest.getHll(1000).union(FullHLLTest.getHll(0));
        FullHLLTest.getHll(0).union(FullHLLTest.getHll(1000));
    }

    @Test
    public void serializationTest() {
        FullHLLTest.testSerialization(FullHLLTest.getHll(0));
        FullHLLTest.testSerialization(FullHLLTest.getHll(1));
        FullHLLTest.testSerialization(FullHLLTest.getHll(1000));
        FullHLLTest.testSerialization(FullHLLTest.getHll(100000));
    }

    private static void testSerialization(HLL originHll) {
        byte[] hllBytes = originHll.toBytes();
        HLL restoredHll = HLL.fromBytes((byte[])hllBytes);
        FullHLLTest.assertElementsEqual(originHll, restoredHll);
        Assert.assertEquals((long)originHll.cardinality(), (long)restoredHll.cardinality());
        Assert.assertEquals((Object)originHll.getType(), (Object)restoredHll.getType());
    }

    private static HLL getHll(int rows) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        HLL result = new HLL(13, 5);
        for (int i = 0; i < rows; ++i) {
            result.addRaw(((Random)r).nextLong());
        }
        return result;
    }

    private static void assertElementsEqual(HLL hllA, HLL hllB) {
        BitVector bitVectorA = (BitVector)GridTestUtils.getFieldValue((Object)hllA, (String[])new String[]{"probabilisticStorage"});
        BitVector bitVectorB = (BitVector)GridTestUtils.getFieldValue((Object)hllB, (String[])new String[]{"probabilisticStorage"});
        if (bitVectorA == null && bitVectorB == null) {
            return;
        }
        LongIterator iterA = bitVectorA.registerIterator();
        LongIterator iterB = bitVectorB.registerIterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            Assert.assertEquals((long)iterA.next(), (long)iterB.next());
        }
        Assert.assertFalse((boolean)iterA.hasNext());
        Assert.assertFalse((boolean)iterB.hasNext());
    }
}

