/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsProcessor;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;

public abstract class StatisticsViewsTest
extends StatisticsAbstractTest {
    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGrid(0);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        this.grid(0).getOrCreateCache("default");
        this.createSmallTable(null);
        this.collectStatistics(SMALL_TARGET);
    }

    @Test
    public void testConfigurationView() throws Exception {
        List<List> config = Arrays.asList(Arrays.asList("PUBLIC", "TABLE", "SMALL", "A", (byte)15, null, null, null, null, 1L), Arrays.asList("PUBLIC", "TABLE", "SMALL", "B", (byte)15, null, null, null, null, 1L), Arrays.asList("PUBLIC", "TABLE", "SMALL", "C", (byte)15, null, null, null, null, 1L));
        this.checkSqlResult("select * from SYS.STATISTICS_CONFIGURATION", null, config::equals);
    }

    @Test
    public void testConfigurationViewDeletion() throws Exception {
        String name = this.createSmallTable("DELETE");
        name = name.toUpperCase();
        this.grid(0).cache("default").query(new SqlFieldsQuery("ANALYZE " + name)).getAll();
        ArrayList<List<Object>> config = new ArrayList<List<Object>>();
        config.add(Arrays.asList("PUBLIC", "TABLE", name, "A", (byte)15, null, null, null, null, 1L));
        config.add(Arrays.asList("PUBLIC", "TABLE", name, "B", (byte)15, null, null, null, null, 1L));
        config.add(Arrays.asList("PUBLIC", "TABLE", name, "C", (byte)15, null, null, null, null, 1L));
        this.checkSqlResult("select * from SYS.STATISTICS_CONFIGURATION where NAME = '" + name + "'", null, config::equals);
        this.grid(0).cache("default").query(new SqlFieldsQuery("DROP STATISTICS " + name + "(A);")).getAll();
        List removed = (List)config.remove(0);
        this.checkSqlResult("select * from SYS.STATISTICS_CONFIGURATION where NAME = '" + name + "'", null, act -> this.testContains((List<List<Object>>)config, (List<List<?>>)act) == null && this.testContains(Arrays.asList(removed), (List<List<?>>)act) != null);
        this.grid(0).cache("default").query(new SqlFieldsQuery("DROP STATISTICS " + name)).getAll();
        this.checkSqlResult("select * from SYS.STATISTICS_CONFIGURATION where NAME = '" + name + "'", null, List::isEmpty);
    }

    @Test
    public void testPartitionDataView() throws Exception {
        List<List> partLines = Arrays.asList(Arrays.asList("PUBLIC", "TABLE", "SMALL", "A", 0, null, null, null, 0L, null, null, null, null));
        this.checkSqlResult("select * from SYS.STATISTICS_PARTITION_DATA where PARTITION < 10", null, act -> {
            this.checkContains((List<List<Object>>)partLines, (List<List<?>>)act);
            return true;
        });
    }

    private void checkContains(List<List<Object>> expected, List<List<?>> actual) {
        List<Object> notExisting = this.testContains(expected, actual);
        if (notExisting != null) {
            StatisticsViewsTest.fail((String)("Unable to found " + notExisting + " in specified dataset"));
        }
    }

    private List<Object> testContains(List<List<Object>> expected, List<List<?>> actual) {
        StatisticsViewsTest.assertTrue((expected.size() <= actual.size() ? 1 : 0) != 0);
        StatisticsViewsTest.assertTrue((String)("Test may take too long with such datasets of actual = " + actual.size()), (actual.size() <= 1024 ? 1 : 0) != 0);
        for (List<Object> exp : expected) {
            List<?> act;
            boolean found = false;
            Iterator<List<?>> iterator = actual.iterator();
            while (iterator.hasNext() && !(found = this.checkEqualWithNull(exp, act = iterator.next()))) {
            }
            if (found) continue;
            return exp;
        }
        return null;
    }

    private boolean checkEqualWithNull(List<Object> expected, List<?> actual) {
        StatisticsViewsTest.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object exp = expected.get(i);
            Object act = actual.get(i);
            if (exp == null || exp.equals(act) || act == null) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testLocalDataView() throws Exception {
        long size = 100L;
        ObjectStatisticsImpl smallStat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        StatisticsViewsTest.assertNotNull((Object)smallStat);
        Timestamp tsA = new Timestamp(smallStat.columnStatistics("A").createdAt());
        Timestamp tsB = new Timestamp(smallStat.columnStatistics("B").createdAt());
        Timestamp tsC = new Timestamp(smallStat.columnStatistics("C").createdAt());
        List<List> localData = Arrays.asList(Arrays.asList("PUBLIC", "TABLE", "SMALL", "A", size, size, 0L, size, 4, 1L, tsA.toString()), Arrays.asList("PUBLIC", "TABLE", "SMALL", "B", size, size, 0L, size, 4, 1L, tsB.toString()), Arrays.asList("PUBLIC", "TABLE", "SMALL", "C", size, 10L, 0L, size, 4, 1L, tsC.toString()));
        this.checkSqlResult("select * from SYS.STATISTICS_LOCAL_DATA", null, localData::equals);
    }

    @Test
    public void testEnforceStatisticValues() throws Exception {
        long size = 100L;
        Logger.getLogger(StatisticsProcessor.class).setLevel(Level.TRACE);
        ObjectStatisticsImpl smallStat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        StatisticsViewsTest.assertNotNull((Object)smallStat);
        StatisticsViewsTest.assertEquals((long)size, (long)smallStat.rowCount());
        this.sql("DROP STATISTICS SMALL");
        this.checkSqlResult("select * from SYS.STATISTICS_LOCAL_DATA where NAME = 'SMALL'", null, list -> list.isEmpty());
        this.sql("ANALYZE SMALL (A) WITH \"DISTINCT=5,NULLS=6,TOTAL=7,SIZE=8\"");
        this.sql("ANALYZE SMALL (B) WITH \"DISTINCT=6,NULLS=7,TOTAL=8\"");
        this.sql("ANALYZE SMALL (C)");
        this.checkSqlResult("select * from SYS.STATISTICS_LOCAL_DATA where NAME = 'SMALL' and COLUMN = 'C'", null, list -> !list.isEmpty());
        StatisticsViewsTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            ObjectStatisticsImpl stat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
            return stat != null && stat.rowCount() == 8L;
        }, (long)3000L));
        smallStat = (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY);
        Timestamp tsA = new Timestamp(smallStat.columnStatistics("A").createdAt());
        Timestamp tsB = new Timestamp(smallStat.columnStatistics("B").createdAt());
        Timestamp tsC = new Timestamp(smallStat.columnStatistics("C").createdAt());
        List<List> localData = Arrays.asList(Arrays.asList("PUBLIC", "TABLE", "SMALL", "A", 8L, 5L, 6L, 7L, 8, 3L, tsA.toString()), Arrays.asList("PUBLIC", "TABLE", "SMALL", "B", 8L, 6L, 7L, 8L, 4, 3L, tsB.toString()), Arrays.asList("PUBLIC", "TABLE", "SMALL", "C", 8L, 10L, 0L, size, 4, 3L, tsC.toString()));
        this.checkSqlResult("select * from SYS.STATISTICS_LOCAL_DATA where NAME = 'SMALL'", null, localData::equals);
    }
}

