/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;

public abstract class StatisticsTypesAbstractTest
extends StatisticsAbstractTest {
    protected static final String[] TYPES = new String[]{"BOOLEAN", "INT", "TINYINT", "SMALLINT", "BIGINT", "DECIMAL", "DOUBLE", "REAL", "TIME", "DATE", "TIMESTAMP", "VARCHAR", "CHAR", "UUID", "BINARY", "GEOMETRY"};
    protected static final String COL_NAME_PREFIX = "COL_";
    private static final String START_DATE = "1970.01.01 12:00:00 UTC";
    protected static final Instant TIMESTART = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss z").parse((CharSequence)"1970.01.01 12:00:00 UTC", Instant::from);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.of("UTC"));
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.of("UTC"));
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC"));

    @Override
    protected void beforeTestsStarted() throws Exception {
        Ignite node = this.startGridsMultiThreaded(1);
        node.getOrCreateCache("default");
    }

    protected void beforeTest() throws Exception {
        int i;
        this.sql("DROP TABLE IF EXISTS dtypes");
        StringBuilder create = new StringBuilder("CREATE TABLE dtypes (ID INT PRIMARY KEY, col_index int, col_no_index int");
        for (String type : TYPES) {
            create.append(", ").append(COL_NAME_PREFIX).append(type).append(" ").append(type);
        }
        create.append(")");
        this.sql(create.toString());
        this.sql("CREATE INDEX dtypes_col_index ON dtypes(col_index)");
        for (String type : TYPES) {
            this.sql(String.format("CREATE INDEX dtypes_%s ON dtypes(col_%s)", type, type));
        }
        for (i = 1; i < 100; ++i) {
            this.sql(this.insert(i));
        }
        for (i = 0; i > -50; --i) {
            this.sql(this.insertNulls(i));
        }
        this.collectStatistics("dtypes");
    }

    private String getVal(String type, long cntr) {
        switch (type) {
            case "BOOLEAN": {
                return (cntr & 1L) == 0L ? "False" : "True";
            }
            case "INT": {
                return String.valueOf(cntr % 0x80000000L);
            }
            case "TINYINT": {
                return String.valueOf(cntr % 128L);
            }
            case "SMALLINT": {
                return String.valueOf(cntr % 32768L);
            }
            case "BIGINT": {
                return String.valueOf(cntr);
            }
            case "DECIMAL": 
            case "DOUBLE": 
            case "REAL": {
                return String.valueOf((double)cntr / 100.0);
            }
            case "TIME": {
                return "'" + TIME_FORMATTER.format(TIMESTART.plus(cntr, ChronoUnit.SECONDS)) + "'";
            }
            case "DATE": {
                return "'" + DATE_FORMATTER.format(TIMESTART.plus(cntr, ChronoUnit.DAYS)) + "'";
            }
            case "TIMESTAMP": {
                return "'" + TIMESTAMP_FORMATTER.format(TIMESTART.plus(cntr, ChronoUnit.SECONDS)) + "'";
            }
            case "VARCHAR": {
                return "'varchar" + cntr + "'";
            }
            case "CHAR": {
                return "'" + (char)(65L + cntr % 26L) + "'";
            }
            case "UUID": {
                return "'" + new UUID(0L, cntr) + "'";
            }
            case "BINARY": {
                return String.valueOf(cntr);
            }
            case "GEOMETRY": {
                return "null";
            }
        }
        throw new IllegalArgumentException();
    }

    private String insertNulls(long cntr) {
        return String.format("INSERT INTO dtypes(id) values (%d)", cntr);
    }

    private String insert(long cntr) {
        StringBuilder insert = new StringBuilder("INSERT INTO dtypes(id, col_index, col_no_index");
        for (String type : TYPES) {
            insert.append(", col_").append(type);
        }
        insert.append(") VALUES (").append(cntr).append(", ").append(cntr).append(", ").append(cntr);
        for (String type : TYPES) {
            insert.append(", ").append(this.getVal(type, cntr));
        }
        insert.append(")");
        return insert.toString();
    }
}

