/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.Collections;
import java.util.Objects;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManagerImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsRestartAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class StatisticsGatheringTest
extends StatisticsRestartAbstractTest {
    @Override
    public int nodes() {
        return 1;
    }

    @Test
    public void testInactiveClusterGathering() throws IgniteInterruptedCheckedException {
        IgniteStatisticsManagerImpl statMgr0 = this.statisticsMgr(0);
        StatisticsTarget t101 = this.createStatisticTarget(101);
        this.sql("select * from SMALL101");
        statMgr0.statisticConfiguration().dropStatistics(Collections.singletonList(t101), false);
        this.grid(0).cluster().state(ClusterState.INACTIVE);
        GridTestUtils.assertThrows(null, () -> this.collectStatistics(t101), IgniteException.class, (String)"Unable to perform collect statistics due to cluster state [state=INACTIVE]");
    }

    @Test
    public void testGathering() throws Exception {
        ObjectStatisticsImpl[] stats = this.getStats("SMALL", StatisticsType.LOCAL);
        this.testCond(Objects::nonNull, stats);
        this.testCond(stat -> stat.columnsStatistics().size() == stats[0].columnsStatistics().size(), stats);
        this.testCond(this::checkStat, stats);
    }

    @Test
    public void testGroupGathering() throws Exception {
        StatisticsTarget t100 = this.createStatisticTarget(100);
        StatisticsTarget t101 = this.createStatisticTarget(101);
        StatisticsTarget tWrong = new StatisticsTarget(t101.schema(), t101.obj() + "wrong", new String[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.statisticsMgr(0).collectStatistics(IgniteStatisticsHelper.buildDefaultConfigurations((StatisticsTarget[])new StatisticsTarget[]{t100, t101, tWrong})), IgniteException.class, (String)"Table doesn't exist [schema=PUBLIC, table=SMALL101wrong]");
        this.updateStatistics(t100, t101);
        ObjectStatisticsImpl[] stats100 = this.getStats(t100.obj(), StatisticsType.LOCAL);
        ObjectStatisticsImpl[] stats101 = this.getStats(t101.obj(), StatisticsType.LOCAL);
        this.testCond(this::checkStat, stats100);
        this.testCond(this::checkStat, stats101);
    }

    private boolean checkStat(ObjectStatisticsImpl stat) {
        StatisticsGatheringTest.assertTrue((stat.columnStatistics("A").total() > 0L ? 1 : 0) != 0);
        StatisticsGatheringTest.assertTrue((stat.columnStatistics("B").distinct() > 0L ? 1 : 0) != 0);
        ColumnStatistics statC = stat.columnStatistics("C");
        StatisticsGatheringTest.assertTrue((statC.min() != null ? 1 : 0) != 0);
        StatisticsGatheringTest.assertTrue((statC.max() != null ? 1 : 0) != 0);
        StatisticsGatheringTest.assertTrue((statC.size() > 0 ? 1 : 0) != 0);
        StatisticsGatheringTest.assertTrue((statC.nulls() == 0L ? 1 : 0) != 0);
        StatisticsGatheringTest.assertTrue((statC.raw().length > 0 ? 1 : 0) != 0);
        StatisticsGatheringTest.assertTrue((statC.total() == stat.rowCount() ? 1 : 0) != 0);
        return true;
    }
}

