/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsPersistenceStoreImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsRestartAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class StatisticsClearTest
extends StatisticsRestartAbstractTest {
    @Override
    public int nodes() {
        return 2;
    }

    @Test
    public void testStatisticsClear() throws Exception {
        this.updateStatistics(this.SMALL_TARGET);
        Assert.assertNotNull((Object)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY));
        Assert.assertNotNull((Object)this.statisticsMgr(1).getLocalStatistics(SMALL_KEY));
        this.statisticsMgr(1).dropStatistics(new StatisticsTarget[]{this.SMALL_TARGET});
        GridTestUtils.waitForCondition(() -> null == this.statisticsMgr(0).getLocalStatistics(SMALL_KEY) && null == this.statisticsMgr(1).getLocalStatistics(SMALL_KEY), (long)3000L);
        this.statisticsMgr(1).collectStatistics(IgniteStatisticsHelper.buildDefaultConfigurations((StatisticsTarget[])new StatisticsTarget[]{this.SMALL_TARGET}));
    }

    @Test(expected=Throwable.class)
    public void testStatisticsClearOnNotExistingTable() throws Exception {
        this.statisticsMgr(1).dropStatistics(new StatisticsTarget[]{new StatisticsTarget("PUBLIC", "NO_NAME", new String[0])});
    }

    @Test
    public void testGetNonExistingTableStatistics() {
        Assert.assertNull((Object)this.statisticsMgr(0).getLocalStatistics(new StatisticsKey("PUBLIC", "NO_NAME")));
        Assert.assertNull((Object)this.statisticsMgr(1).getLocalStatistics(new StatisticsKey("PUBLIC", "NO_NAME")));
    }

    @Test
    public void testRestartWrongVersion() throws Exception {
        this.testRestartVersion(metaStorage -> {
            try {
                metaStorage.write("stats.version", (Serializable)Integer.valueOf(2));
            }
            catch (IgniteCheckedException e) {
                Assert.fail();
            }
        });
    }

    @Test
    public void testRestartNoVersion() throws Exception {
        this.testRestartVersion(metaStorage -> {
            try {
                metaStorage.remove("stats.version");
            }
            catch (IgniteCheckedException e) {
                Assert.fail();
            }
        });
    }

    @Test
    public void testRestartCorruptedVersion() throws Exception {
        this.testRestartVersion(metaStorage -> {
            try {
                metaStorage.write("stats.version", (Serializable)((Object)"corrupted"));
            }
            catch (IgniteCheckedException e) {
                Assert.fail();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRestartVersion(Consumer<MetaStorage> verCorruptor) throws Exception {
        IgniteCacheDatabaseSharedManager db = this.grid(0).context().cache().context().database();
        this.checkStatisticsExist(db, 3000L);
        db.checkpointReadLock();
        try {
            verCorruptor.accept(db.metaStorage());
        }
        finally {
            db.checkpointReadUnlock();
        }
        this.stopGrid(0);
        this.startGrid(0);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        db = this.grid(0).context().cache().context().database();
        db.checkpointReadLock();
        try {
            StatisticsClearTest.assertEquals((Object)IgniteStatisticsPersistenceStoreImpl.VERSION, (Object)db.metaStorage().read("stats.version"));
        }
        finally {
            db.checkpointReadUnlock();
        }
        db = this.grid(0).context().cache().context().database();
        this.checkStatisticsExist(db, 3000L);
    }

    private void checkStatisticsExist(IgniteCacheDatabaseSharedManager db, long timeout) throws IgniteCheckedException {
        StatisticsClearTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            db.checkpointReadLock();
            try {
                boolean[] found = new boolean[1];
                db.metaStorage().iterate("stats.data.PUBLIC.SMALL.", (k, v) -> {
                    found[0] = true;
                }, true);
                boolean bl = found[0];
                return bl;
            }
            catch (Throwable ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                db.checkpointReadUnlock();
            }
        }, (long)timeout));
    }
}

