/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManagerImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;

public abstract class StatisticsAbstractTest
extends GridCommonAbstractTest {
    public static final String SCHEMA = "PUBLIC";
    private static final AtomicInteger queryRandomizer = new AtomicInteger(0);
    static final int BIG_SIZE = 1000;
    static final int MED_SIZE = 500;
    static final int SMALL_SIZE = 100;
    static final StatisticsKey SMALL_KEY = new StatisticsKey("PUBLIC", "SMALL");
    static final StatisticsTarget SMALL_TARGET = new StatisticsTarget(SMALL_KEY, null);
    static final int TIMEOUT = 3000;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
    }

    protected void checkOptimalPlanChosenForDifferentIndexes(IgniteEx grid, String[] optimal, String sql, String[][] indexes) {
        int size = -1;
        for (String[] idxs : indexes) {
            if (size == -1) {
                int n = size = idxs == null ? 0 : idxs.length;
            }
            assert (idxs == null || idxs.length == size);
        }
        sql = StatisticsAbstractTest.replaceIndexHintPlaceholders(sql, indexes);
        int spaces = queryRandomizer.incrementAndGet();
        StringBuilder spaceBuilder = new StringBuilder(spaces);
        for (int i = 0; i < spaces; ++i) {
            spaceBuilder.append(' ');
        }
        sql = sql.replaceFirst(" ", spaceBuilder.toString());
        Object[] actual = this.runLocalExplainIdx((Ignite)grid, sql);
        StatisticsAbstractTest.assertTrue((String)String.format("got %s, expected %s in query %s", Arrays.asList(actual), Arrays.asList(optimal), sql), (boolean)Arrays.equals(actual, optimal));
    }

    protected void checkOptimalPlanChosenForDifferentJoinOrders(Ignite grid, String sql, String ... tbls) {
        String directOrder = StatisticsAbstractTest.replaceTablePlaceholders(sql, tbls);
        if (log.isDebugEnabled()) {
            log.debug("Direct join order=" + directOrder);
        }
        this.ensureOptimalPlanChosen(grid, directOrder, new String[0]);
        List<String> dirOrdTbls = Arrays.asList(tbls);
        Collections.reverse(dirOrdTbls);
        String reversedOrder = StatisticsAbstractTest.replaceTablePlaceholders(sql, dirOrdTbls.toArray(new String[dirOrdTbls.size()]));
        if (log.isDebugEnabled()) {
            log.debug("Reversed join order=" + reversedOrder);
        }
        this.ensureOptimalPlanChosen(grid, reversedOrder, new String[0]);
    }

    private void ensureOptimalPlanChosen(Ignite grid, String sql, String ... tbls) {
        int cntNoStats = this.runLocalExplainAnalyze(grid, true, sql);
        int cntStats = this.runLocalExplainAnalyze(grid, false, sql);
        String res = "Scanned rows count [noStats=" + cntNoStats + ", withStats=" + cntStats + ", diff=" + (cntNoStats - cntStats) + ']';
        if (log.isInfoEnabled()) {
            log.info(res);
        }
        StatisticsAbstractTest.assertTrue((String)res, (cntStats <= cntNoStats ? 1 : 0) != 0);
    }

    protected String[] runLocalExplainIdx(Ignite grid, String sql) {
        List res = grid.cache("default").query(new SqlFieldsQuery("EXPLAIN " + sql).setLocal(true)).getAll();
        String explainRes = (String)((List)res.get(0)).get(0);
        Matcher m = Pattern.compile(".*\\/\\*.+?\\.(\\w+):.*\\R*.*\\R*.*\\R*.*\\R*\\*\\/.*").matcher(explainRes);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1).trim());
        }
        return result.toArray(new String[result.size()]);
    }

    protected int runLocalExplainAnalyze(Ignite grid, boolean enfJoinOrder, String sql) {
        List res = grid.cache("default").query((SqlFieldsQuery)new SqlFieldsQueryEx("EXPLAIN ANALYZE " + sql, null).setEnforceJoinOrder(enfJoinOrder).setLocal(true)).getAll();
        if (log.isDebugEnabled()) {
            log.debug("ExplainAnalyze enfJoinOrder=" + enfJoinOrder + ", res=" + res);
        }
        return this.extractScanCountFromExplain(res);
    }

    private void processObsolescence(IgniteEx grid) {
        IgniteH2Indexing indexing = (IgniteH2Indexing)grid.context().query().getIndexing();
        ((IgniteStatisticsManagerImpl)indexing.statsManager()).processObsolescence();
    }

    private int extractScanCountFromExplain(List<List<?>> res) {
        String explainRes = (String)res.get(0).get(0);
        Matcher m = Pattern.compile("scanCount: (?=(\\d+))").matcher(explainRes);
        int scanCnt = 0;
        while (m.find()) {
            scanCnt += Integer.parseInt(m.group(1));
        }
        return scanCnt;
    }

    protected List<List<?>> sql(String sql) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql), false).getAll();
    }

    protected String createSmallTable(String suffix) {
        String tblName = "small" + (suffix != null ? suffix : "");
        this.sql("DROP TABLE IF EXISTS " + tblName);
        this.sql(String.format("CREATE TABLE %s (a INT PRIMARY KEY, b INT, c INT) with \"BACKUPS=1,CACHE_NAME=SMALL%s\"", tblName, suffix));
        this.sql(String.format("CREATE INDEX %s_b ON %s(b)", tblName, tblName));
        this.sql(String.format("CREATE INDEX %s_c ON %s(c)", tblName, tblName));
        for (int i = 0; i < 100; ++i) {
            this.sql(String.format("INSERT INTO %s(a, b, c) VALUES(%d, %d, %d)", tblName, i, i, i % 10));
        }
        return tblName;
    }

    protected void dropSmallTable(String suffix) {
        suffix = suffix != null ? suffix : "";
        this.sql("DROP TABLE IF EXISTS small" + suffix);
    }

    private static String replaceIndexHintPlaceholders(String sql, String[][] idxs) {
        assert (!sql.contains("i0"));
        int i = 0;
        for (Object[] objectArray : idxs) {
            String idxPlaceHolder = "i" + ++i;
            assert (sql.contains(idxPlaceHolder));
            if (!F.isEmpty((Object[])objectArray)) {
                String idxStr = "USE INDEX (" + String.join((CharSequence)",", (CharSequence[])objectArray) + ")";
                sql = sql.replaceAll(idxPlaceHolder, idxStr);
                continue;
            }
            sql = sql.replaceAll(idxPlaceHolder, "");
        }
        assert (!sql.contains("i" + (i + 1)));
        return sql;
    }

    private static String replaceTablePlaceholders(String sql, String ... tbls) {
        assert (!sql.contains("t0"));
        int i = 0;
        for (String tbl : tbls) {
            String tblPlaceHolder = "t" + ++i;
            assert (sql.contains(tblPlaceHolder));
            sql = sql.replace(tblPlaceHolder, tbl);
        }
        assert (!sql.contains("t" + (i + 1)));
        return sql;
    }

    protected void updateStatistics(String ... tables) {
        StatisticsTarget[] targets = (StatisticsTarget[])Arrays.stream(tables).map(tbl -> new StatisticsTarget(SCHEMA, tbl.toUpperCase(), new String[0])).toArray(StatisticsTarget[]::new);
        this.updateStatistics(targets);
    }

    protected void collectStatistics(String ... tables) {
        StatisticsTarget[] targets = (StatisticsTarget[])Arrays.stream(tables).map(tbl -> new StatisticsTarget(SCHEMA, tbl.toUpperCase(), new String[0])).toArray(StatisticsTarget[]::new);
        this.collectStatistics(targets);
    }

    protected void updateStatistics(StatisticsTarget ... targets) {
        this.makeStatistics(false, targets);
    }

    protected void collectStatistics(StatisticsTarget ... targets) {
        this.makeStatistics(true, targets);
    }

    private void makeStatistics(boolean collect, StatisticsTarget ... targets) {
        try {
            HashMap<StatisticsTarget, Long> expectedVersion = new HashMap<StatisticsTarget, Long>();
            IgniteStatisticsManagerImpl statMgr = this.statisticsMgr(0);
            for (StatisticsTarget target : targets) {
                Predicate<StatisticsColumnConfiguration> pred;
                StatisticsObjectConfiguration currCfg = statMgr.statisticConfiguration().config(target.key());
                if (F.isEmpty((Object[])target.columns())) {
                    pred = c -> true;
                } else {
                    Set cols = Arrays.stream(target.columns()).collect(Collectors.toSet());
                    pred = c -> cols.contains(c.name());
                }
                Long expVer = currCfg == null ? 1L : currCfg.columnsAll().values().stream().filter(pred).mapToLong(StatisticsColumnConfiguration::version).min().orElse(0L) + 1L;
                expectedVersion.put(target, expVer);
            }
            if (collect) {
                this.statisticsMgr(0).collectStatistics(IgniteStatisticsHelper.buildDefaultConfigurations((StatisticsTarget[])targets));
            } else {
                this.statisticsMgr(0).refreshStatistics(targets);
            }
            this.awaitStatistics(3000L, expectedVersion);
        }
        catch (Exception ex) {
            throw new IgniteException((Throwable)ex);
        }
    }

    protected ObjectStatisticsImpl getStatistics(long rowsCnt) {
        ColumnStatistics colStatistics = new ColumnStatistics(null, null, 100L, 0L, 100L, 0, new byte[0], 0L, U.currentTimeMillis());
        return new ObjectStatisticsImpl(rowsCnt, Collections.singletonMap("col1", colStatistics));
    }

    protected ObjectPartitionStatisticsImpl getPartitionStatistics(int partId) {
        ColumnStatistics colStatistics = new ColumnStatistics(null, null, 100L, 0L, 100L, 0, new byte[0], 0L, U.currentTimeMillis());
        return new ObjectPartitionStatisticsImpl(partId, 0L, 0L, Collections.singletonMap("col1", colStatistics));
    }

    protected ObjectStatisticsImpl getStatistics() {
        ColumnStatistics colStatistics = new ColumnStatistics(null, null, 100L, 0L, 100L, 0, new byte[0], 0L, U.currentTimeMillis());
        return new ObjectStatisticsImpl(0L, Collections.singletonMap("col1", colStatistics));
    }

    protected void checkStatisticTasksEmpty(IgniteEx ign) {
        Map currColls = (Map)GridTestUtils.getFieldValue((Object)this.statisticsMgr(ign), (String[])new String[]{"statProc", "gatheringInProgress"});
        StatisticsAbstractTest.assertTrue((String)currColls.toString(), (boolean)currColls.isEmpty());
        IgniteThreadPoolExecutor mgmtPool = (IgniteThreadPoolExecutor)GridTestUtils.getFieldValue((Object)this.statisticsMgr(ign), (String[])new String[]{"mgmtPool"});
        StatisticsAbstractTest.assertTrue((boolean)mgmtPool.getQueue().isEmpty());
        IgniteThreadPoolExecutor gatherPool = (IgniteThreadPoolExecutor)GridTestUtils.getFieldValue((Object)this.statisticsMgr(ign), (String[])new String[]{"gatherPool"});
        StatisticsAbstractTest.assertTrue((boolean)gatherPool.getQueue().isEmpty());
    }

    protected void awaitStatistics(long timeout, Map<StatisticsTarget, Long> expectedVersions) throws Exception {
        for (Ignite ign : G.allGrids()) {
            if (((IgniteEx)ign).context().clientNode()) continue;
            this.awaitStatistics(timeout, expectedVersions, (IgniteEx)ign);
        }
    }

    protected void awaitStatistics(long timeout, Map<StatisticsTarget, Long> expectedVersions, IgniteEx ign) throws Exception {
        long t0 = U.currentTimeMillis();
        IgniteH2Indexing indexing = (IgniteH2Indexing)ign.context().query().getIndexing();
        while (true) {
            try {
                this.checkStatisticTasksEmpty(ign);
                for (Map.Entry<StatisticsTarget, Long> targetVersionEntry : expectedVersions.entrySet()) {
                    StatisticsTarget target = targetVersionEntry.getKey();
                    Long ver = targetVersionEntry.getValue();
                    ObjectStatisticsImpl s = (ObjectStatisticsImpl)indexing.statsManager().getLocalStatistics(target.key());
                    StatisticsAbstractTest.assertNotNull((Object)s);
                    long minVer = Long.MAX_VALUE;
                    Set<Object> cols = F.isEmpty((Object[])target.columns()) ? s.columnsStatistics().keySet() : Arrays.stream(target.columns()).collect(Collectors.toSet());
                    for (String col : cols) {
                        if (s.columnStatistics(col).version() >= minVer) continue;
                        minVer = s.columnStatistics(col).version();
                    }
                    if (minVer == Long.MAX_VALUE) {
                        minVer = -1L;
                    }
                    StatisticsAbstractTest.assertEquals((String)String.format("Expected minimum statistics version %d but found %d", ver, minVer), (long)ver, (long)minVer);
                }
                return;
            }
            catch (Throwable ex) {
                if (t0 + timeout < U.currentTimeMillis()) {
                    throw ex;
                }
                U.sleep((long)200L);
                continue;
            }
            break;
        }
    }

    protected Lock nodeMsgsLock(int nodeIdx) throws Exception {
        IgniteThreadPoolExecutor pool = (IgniteThreadPoolExecutor)GridTestUtils.getFieldValue((Object)this.statisticsMgr(nodeIdx), (String[])new String[]{"statCrawler", "msgMgmtPool"});
        return this.lockPool(pool);
    }

    protected Lock nodeGathLock(int nodeIdx) throws Exception {
        IgniteThreadPoolExecutor pool = (IgniteThreadPoolExecutor)GridTestUtils.getFieldValue((Object)this.statisticsMgr(nodeIdx), (String[])new String[]{"statGathering", "gatMgmtPool"});
        return this.lockPool(pool);
    }

    private Lock lockPool(IgniteThreadPoolExecutor pool) {
        ReentrantLock res = new ReentrantLock();
        res.lock();
        pool.submit(res::lock);
        return res;
    }

    protected ObjectStatisticsImpl[] getStats(String tblName, StatisticsType type) {
        int nodes = G.allGrids().size();
        ObjectStatisticsImpl[] res = new ObjectStatisticsImpl[nodes];
        for (int i = 0; i < nodes; ++i) {
            res[i] = this.getStatsFromNode(i, tblName, type);
        }
        return res;
    }

    protected void testCond(Function<ObjectStatisticsImpl, Boolean> cond, ObjectStatisticsImpl ... stats) {
        StatisticsAbstractTest.assertFalse((boolean)F.isEmpty((Object[])stats));
        for (ObjectStatisticsImpl stat : stats) {
            StatisticsAbstractTest.assertTrue((boolean)cond.apply(stat));
        }
    }

    protected ObjectStatisticsImpl getStatsFromNode(int nodeIdx, String tblName, StatisticsType type) {
        switch (type) {
            case LOCAL: {
                return (ObjectStatisticsImpl)this.statisticsMgr(nodeIdx).getLocalStatistics(new StatisticsKey(SCHEMA, tblName));
            }
        }
        throw new UnsupportedOperationException();
    }

    public IgniteStatisticsManagerImpl statisticsMgr(int nodeIdx) {
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.grid(nodeIdx).context().query().getIndexing();
        return (IgniteStatisticsManagerImpl)indexing.statsManager();
    }

    public IgniteStatisticsManagerImpl statisticsMgr(IgniteEx ign) {
        IgniteH2Indexing indexing = (IgniteH2Indexing)ign.context().query().getIndexing();
        return (IgniteStatisticsManagerImpl)indexing.statsManager();
    }

    public static <T> Set<T> setOf(T ... vals) {
        if (F.isEmpty((Object[])vals)) {
            return Collections.emptySet();
        }
        if (vals.length == 1) {
            return Collections.singleton(vals[0]);
        }
        HashSet res = new HashSet(vals.length);
        Collections.addAll(res, vals);
        return res;
    }

    protected void checkSqlResult(String sql, Predicate<Ignite> nodeFilter, Predicate<List<List<?>>> checker) throws Exception {
        List nodes = G.allGrids();
        if (nodeFilter != null) {
            nodes = nodes.stream().filter(nodeFilter).collect(Collectors.toList());
        }
        for (Ignite ign : nodes) {
            StatisticsAbstractTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
                List res = ign.cache("default").query(new SqlFieldsQuery(sql)).getAll();
                return checker.test(res);
            }, (long)3000L));
        }
    }

    static {
        StatisticsAbstractTest.assertTrue((boolean)true);
    }
}

