/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class QueryMemoryManagerSelfTest
extends GridCommonAbstractTest {
    protected boolean client;

    protected void beforeTest() throws Exception {
        System.clearProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE");
        super.beforeTest();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        System.clearProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE");
        this.stopAllGrids();
    }

    @Test
    public void testDefaults() throws Exception {
        long maxMem = Runtime.getRuntime().maxMemory();
        System.setProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE", String.valueOf(maxMem));
        this.startGrid(0);
        this.client = true;
        this.startGrid(1);
        this.createSchema();
        this.populateData();
        String sql = "select * from T as T0, T as T1 where T0.id < 1 UNION select * from T as T2, T as T3 where T2.id >= 2 AND T2.id < 3";
        try (FieldsQueryCursor<List<?>> cursor = this.query("select * from T as T0, T as T1 where T0.id < 1 UNION select * from T as T2, T as T3 where T2.id >= 2 AND T2.id < 3", false);){
            try {
                cursor.getAll();
                QueryMemoryManagerSelfTest.fail((String)"Exception not thrown.");
            }
            catch (SqlMemoryQuotaExceededException e) {
                QueryMemoryManagerSelfTest.assertTrue((boolean)e.getMessage().contains("SQL query ran out of memory: Global quota was exceeded"));
            }
        }
    }

    @Test
    public void testWrongSqlMemoryPoolSize() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            IgniteConfiguration cfg = this.getConfiguration("node1");
            long maxMem = Runtime.getRuntime().maxMemory();
            long memCompare = maxMem + 1L;
            log.info("maxMem detected: " + maxMem + ", mem will compare with: " + memCompare);
            cfg.setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota(String.valueOf(memCompare)));
            this.startGrid(cfg);
        }, IgniteException.class, (String)"Ouch! Argument is invalid: Sql global memory quota can't be more than heap size");
    }

    @Test
    public void testOffLoadingEnabledLogStmnt() throws Exception {
        ListeningTestLogger listeningLog = new ListeningTestLogger(log);
        IgniteConfiguration cfg = this.getConfiguration("node1");
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(true));
        cfg.setGridLogger((IgniteLogger)listeningLog);
        LogListener logListener = LogListener.matches((String)"offloadingEnabled=true]").build();
        listeningLog.registerListener(logListener);
        this.startGrid(cfg);
        QueryMemoryManagerSelfTest.assertTrue((boolean)logListener.check());
    }

    private void populateData() {
        int i;
        for (i = 0; i < 1000; ++i) {
            this.execSql("insert into T VALUES (?, ?, ?)", i, i, UUID.randomUUID().toString());
        }
        for (i = 0; i < 10000; ++i) {
            this.execSql("insert into K VALUES (?, ?, ?, ?, ?)", i, i, i % 100, i % 100, UUID.randomUUID().toString());
        }
    }

    private void createSchema() {
        this.execSql("create table T (id int primary key, ref_key int, name varchar)", new Object[0]);
        this.execSql("create table K (id int primary key, indexed int, grp int, grp_indexed int, name varchar)", new Object[0]);
        this.execSql("create index K_IDX on K(indexed)", new Object[0]);
        this.execSql("create index K_GRP_IDX on K(grp_indexed)", new Object[0]);
    }

    private void execSql(String sql, Object ... args) {
        this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false).getAll();
    }

    FieldsQueryCursor<List<?>> query(String sql, boolean lazy) {
        return this.grid(1).context().query().querySqlFields(new SqlFieldsQueryEx(sql, null).setLazy(lazy).setEnforceJoinOrder(true).setPageSize(100), false);
    }
}

