/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.query.h2.H2ManagedLocalResult;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.oom.BasicQueryMemoryTrackerSelfTest;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueString;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LocalQueryMemoryTrackerWithQueryParallelismSelfTest
extends BasicQueryMemoryTrackerSelfTest {
    private static final int PARALLELISM = 4;

    @Override
    protected boolean isLocal() {
        return true;
    }

    @Override
    protected void createSchema() {
        this.execSql("create table T (id int primary key, ref_key int, name varchar) WITH \"PARALLELISM=4\"", new Object[0]);
        this.execSql("create table K (id int primary key, indexed int, grp int, grp_indexed int, name varchar) WITH \"PARALLELISM=4\"", new Object[0]);
        this.execSql("create index K_IDX on K(indexed)", new Object[0]);
        this.execSql("create index K_GRP_IDX on K(grp_indexed)", new Object[0]);
    }

    @Override
    @Test
    public void testSimpleQuerySmallResult() throws Exception {
        this.execQuery("select * from T", false);
        long rowCount = localResults.stream().mapToLong(r -> r.getRowCount()).sum();
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.isEmpty());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((localResults.size() <= 4 ? 1 : 0) != 0);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((long)1000L, (long)rowCount);
    }

    @Override
    @Test
    public void testQueryWithSort() {
        this.maxMem = 0x200000L;
        this.checkQueryExpectOOM("select * from K ORDER BY K.grp", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)4, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((10000L > localResults.stream().mapToLong(H2ManagedLocalResult::getRowCount).sum() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testGlobalQuota() throws Exception {
        this.maxMem = -1L;
        ArrayList cursors = new ArrayList();
        IgniteH2Indexing h2 = (IgniteH2Indexing)this.grid(0).context().query().getIndexing();
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((long)this.globalQuotaSize(), (long)h2.memoryManager().memoryLimit());
        try {
            long rowSize = H2Utils.rowSizeInBytes((Object[])new Object[]{ValueString.get((String)UUID.randomUUID().toString()), ValueInt.get((int)512), ValueInt.get((int)512)});
            long resSetSize = rowSize * 1000L;
            if (resSetSize % 1024L != 0L) {
                resSetSize = (resSetSize / 1024L + 1L) * 1024L * 2L;
            }
            int expCursorCnt = (int)(this.globalQuotaSize() / resSetSize);
            CacheException ex = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                for (int i = 0; i < expCursorCnt * 2; ++i) {
                    FieldsQueryCursor<List<?>> cur = this.query("select T.name, 512, 512 from T ORDER BY T.name LIMIT 1000000", true);
                    cursors.add(cur);
                    Iterator iter = cur.iterator();
                    iter.next();
                }
                return null;
            }, CacheException.class, (String)"SQL query ran out of memory: Global quota was exceeded.");
            LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)expCursorCnt, (int)cursors.size());
            LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((h2.memoryManager().memoryLimit() < h2.memoryManager().reserved() + 0x100000L ? 1 : 0) != 0);
        }
        finally {
            for (QueryCursor c : cursors) {
                IgniteUtils.closeQuiet((AutoCloseable)c);
            }
        }
    }

    @Override
    @Test
    public void testUnionOfSmallDataSetsWithLargeResult() {
        this.checkQueryExpectOOM("select * from T as T0, T as T1 where T0.id < 2 UNION select * from T as T2, T as T3 where T2.id > 2 AND T2.id < 4", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)11, (int)localResults.size());
        long rowCnt = localResults.stream().mapToLong(H2ManagedLocalResult::getRowCount).sum();
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((3000L > rowCnt ? 1 : 0) != 0);
        Map<H2MemoryTracker, Long> collect = localResults.stream().collect(Collectors.toMap(H2ManagedLocalResult::memoryTracker, H2ManagedLocalResult::memoryReserved, Long::sum));
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((boolean)collect.values().stream().allMatch(s -> s < this.maxMem));
    }

    @Override
    @Test
    public void testLazyQueryWithJoinAndSort() {
        this.checkQueryExpectOOM("select * from T as T0, T as T1 ORDER BY T1.id", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.isEmpty());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((localResults.size() <= 4 ? 1 : 0) != 0);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((boolean)localResults.stream().allMatch(r -> r.memoryReserved() < this.maxMem));
    }

    @Override
    @Test
    public void testUnionLargeDataSets() {
        this.maxMem = 0x200000L;
        this.checkQueryExpectOOM("select * from T as T0, T as T1 where T0.id < 4 UNION select * from T as T2, T as T3 where T2.id >= 2 AND T2.id < 6", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)3, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)0, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((4000 > ((H2ManagedLocalResult)localResults.get(1)).getRowCount() + ((H2ManagedLocalResult)localResults.get(2)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithLimit() throws Exception {
        this.execQuery("select * from K LIMIT 500", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)5, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((boolean)localResults.stream().allMatch(r -> r.getRowCount() == 500));
    }

    @Override
    @Test
    public void testQueryWithDistinctAndGroupBy() throws Exception {
        this.checkQueryExpectOOM("select DISTINCT K.name from K GROUP BY K.id", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)1, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((long)0L, (long)((H2ManagedLocalResult)localResults.get(0)).memoryReserved());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)0, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Override
    @Test
    public void testSimpleJoinsHugeResult() {
        this.checkQueryExpectOOM("select * from T as T0, T as T1", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.isEmpty());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((localResults.size() <= 4 ? 1 : 0) != 0);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((boolean)localResults.stream().allMatch(r -> r.memoryReserved() < this.maxMem));
    }

    @Override
    @Test
    public void testLazyQueryWithSort() {
        this.maxMem = 0x200000L;
        this.checkQueryExpectOOM("select * from K ORDER BY K.grp", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)4, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.stream().anyMatch(r -> r.memoryReserved() + 1000L > this.maxMem));
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((10000L > localResults.stream().limit(4L).mapToLong(H2ManagedLocalResult::getRowCount).sum() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testLazyQueryWithSortByIndexedCol() throws Exception {
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)1, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithGroupBy() {
        this.checkQueryExpectOOM("select K.name, count(K.id), sum(K.grp) from K GROUP BY K.name", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.isEmpty());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((localResults.size() <= 4 ? 1 : 0) != 0);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((10000L > localResults.stream().mapToLong(r -> r.getRowCount()).sum() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithGroupByPrimaryKey() throws Exception {
        this.checkQueryExpectOOM("select K.indexed, sum(K.id) from K GROUP BY K.indexed", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)1, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testUnionSimple() throws Exception {
        this.maxMem = 0x200000L;
        this.execQuery("select * from T as T0, T as T1 where T0.id < 2 UNION select * from T as T2, T as T3 where T2.id >= 1 AND T2.id < 2", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)3, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(1)).memoryReserved() + ((H2ManagedLocalResult)localResults.get(2)).memoryReserved() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithSortByIndexedCol() {
        this.maxMem = 0x200000L;
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)4, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.stream().limit(4L).anyMatch(r -> r.memoryReserved() + 1000L > this.maxMem));
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((10000L > localResults.stream().mapToLong(H2ManagedLocalResult::getRowCount).sum() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithGroupsSmallResult() throws Exception {
        this.execQuery("select K.grp, avg(K.id), min(K.id), sum(K.id) from K GROUP BY K.grp", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)5, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.stream().limit(4L).anyMatch(r -> r.memoryReserved() + 1000L > this.maxMem));
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((long)100L, (long)localResults.stream().limit(4L).mapToLong(r -> r.getRowCount()).sum());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(4)).getRowCount());
    }

    @Override
    @Test
    public void testLazyQueryWithHighLimit() throws Exception {
        this.checkQueryExpectOOM("select * from K LIMIT 8000", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)1, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((8000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithHighLimit() {
        long rowSize = H2Utils.rowSizeInBytes((Object[])new Object[]{ValueInt.get((int)1), ValueInt.get((int)1), ValueInt.get((int)1), ValueString.get((String)UUID.randomUUID().toString())});
        long rowCntPerSegment = 2500L;
        this.maxMem = (long)((double)(rowSize * rowCntPerSegment) * 3.5);
        this.checkQueryExpectOOM("select 1, 1, 1, name from K LIMIT 8000", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)4, (int)localResults.size());
        long rowsRetrieved = localResults.stream().collect(Collectors.summarizingLong(H2ManagedLocalResult::getRowCount)).getSum();
        Assert.assertThat((Object)rowsRetrieved, LocalQueryMemoryTrackerWithQueryParallelismSelfTest.inRange(rowCntPerSegment * 3L, rowCntPerSegment * 4L));
    }

    @Override
    @Test
    public void testLazyQueryWithGroupByIndexedColAndDistinctAggregates() throws Exception {
        this.checkQueryExpectOOM("select K.grp_indexed, count(DISTINCT k.name) from K  USE INDEX (K_GRP_IDX) GROUP BY K.grp_indexed", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)1, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((100 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithGroupThenSort() throws Exception {
        this.execQuery("select K.grp_indexed, sum(K.id) as s from K GROUP BY K.grp_indexed ORDER BY s", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)5, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(4)).getRowCount());
    }

    @Override
    @Test
    public void testSimpleQueryLargeResult() throws Exception {
        this.maxMem = 0x300000L;
        this.execQuery("select * from K", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.isEmpty());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((localResults.size() <= 4 ? 1 : 0) != 0);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((long)10000L, (long)localResults.stream().mapToLong(H2ManagedLocalResult::getRowCount).sum());
    }

    @Override
    @Test
    public void testQueryWithGroupByIndexedCol() throws Exception {
        this.checkQueryExpectOOM("select K.indexed, sum(K.grp) from K GROUP BY K.indexed", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)1, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((100 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testQueryWithDistinctAndLowCardinality() throws Exception {
        this.execQuery("select DISTINCT K.grp_indexed from K", false);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)5, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(4)).getRowCount());
    }

    @Override
    @Test
    public void testQueryWithDistinctAndHighCardinality() throws Exception {
        this.checkQueryExpectOOM("select DISTINCT K.id from K", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)4, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertFalse((boolean)localResults.stream().allMatch(r -> r.memoryReserved() + 1000L > this.maxMem));
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertTrue((10000L > localResults.stream().mapToLong(H2ManagedLocalResult::getRowCount).sum() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testLazyQueryWithGroupByThenSort() {
        this.maxMem = 524288L;
        this.checkQueryExpectOOM("select K.indexed, sum(K.grp) as a from K GROUP BY K.indexed ORDER BY a DESC", true);
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)1, (int)localResults.size());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((long)0L, (long)((H2ManagedLocalResult)localResults.get(0)).memoryReserved());
        LocalQueryMemoryTrackerWithQueryParallelismSelfTest.assertEquals((int)0, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    private static <T extends Comparable<? super T>> Matcher<T> inRange(final T lowerBound, final T upperBound) {
        Objects.requireNonNull(lowerBound, "lowerBound");
        Objects.requireNonNull(upperBound, "upperBound");
        return new CustomMatcher<T>("should be in range [" + lowerBound + ", " + upperBound + "]"){

            public boolean matches(Object item) {
                return lowerBound != null && upperBound != null && item instanceof Comparable && ((Comparable)item).compareTo(lowerBound) >= 0 && ((Comparable)item).compareTo(upperBound) <= 0;
            }
        };
    }
}

