/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DiskSpillingQueriesTest
extends DiskSpillingAbstractTest {
    @Parameterized.Parameter(value=0)
    public boolean fromClient;
    @Parameterized.Parameter(value=1)
    public boolean loc;

    @Parameterized.Parameters(name="fromClient={0}, local={1}")
    public static Collection parameters() {
        return Arrays.asList({false, false}, {false, true}, {true, false});
    }

    @Override
    protected boolean fromClient() {
        return this.fromClient;
    }

    @Override
    protected boolean localQuery() {
        return this.loc;
    }

    @Test
    public void simpleSelect() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person");
    }

    @Test
    public void simpleSelectWithSort() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person ORDER BY id DESC");
    }

    @Test
    public void simpleSelectWithSortLazy() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT * FROM person ORDER BY id ASC, code ASC");
    }

    @Test
    public void simpleSelectWithDistinct() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT DISTINCT code FROM person");
    }

    @Test
    public void simpleSelectWithDistinctLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT DISTINCT depId, code FROM person");
    }

    @Test
    public void simpleSelectWithDistinctOrderBy() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT DISTINCT code FROM person ORDER BY code");
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-21599")
    @Test
    public void simpleSelectWithDistinctOrderByLazy() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT DISTINCT ON (code, depId) salary  FROM person ORDER BY code, salary DESC");
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-21599")
    @Test
    public void simpleSelectWithDistinctOrderByAggregate() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT DISTINCT code, depId FROM person ORDER BY CONCAT(depId, code)");
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-21599")
    @Test
    public void simpleSelectWithDistinctOrderByAggregateLazy() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT DISTINCT code, depId, temperature FROM person ORDER BY CONCAT(depId, code)");
    }

    @Test
    public void simpleSubSelectIn() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person WHERE depId IN (SELECT id FROM department)");
    }

    @Test
    public void simpleSubSelectInLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT * FROM person WHERE depId IN (SELECT id FROM department) ORDER BY salary DESC");
    }

    @Test
    public void simpleSubSelectExists() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person WHERE EXISTS (SELECT * FROM department)");
    }

    @Test
    public void simpleSubSelectExistsLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT * FROM person WHERE EXISTS (SELECT * FROM department) ORDER BY salary DESC");
    }

    @Test
    public void simpleSubSelect() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person WHERE age = (SELECT MAX(age) FROM (SELECT * FROM Person WHERE id < 200) WHERE id=age)");
    }

    @Test
    public void simpleSubSelectLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT * FROM person WHERE EXISTS (SELECT * FROM department) ORDER BY salary DESC");
    }

    @Test
    public void simpleSelectWithDistinctOn() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT DISTINCT ON (code) code, depId FROM person ORDER BY code, depId");
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-21599")
    @Test
    public void simpleSelectWithDistinctOnLazy() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT DISTINCT ON (code, depId) age FROM person ORDER BY code, depId");
    }

    @Test
    public void simpleJoin() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT p.id, p.name, p.depId, d.title FROM person p, department d  WHERE p.depId = d.id");
    }

    @Test
    public void simpleJoinLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT p.id, p.name, p.depId, d.title FROM person p, department d  WHERE p.depId = d.id AND  (p.id > 10 OR p.id < 10000) ORDER BY p.salary DESC OFFSET 10");
    }

    @Test
    public void simpleUnion() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT id, name, code, depId FROM person WHERE depId < 10  UNION SELECT id, name, code, depId FROM person WHERE depId > 5 ");
    }

    @Test
    public void simpleUnionLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "(SELECT DISTINCT id, name, code, depId FROM person WHERE depId < 10  ORDER BY id DESC OFFSET 20) UNION SELECT id, name, code, depId FROM person WHERE depId > 5 ORDER BY id DESC LIMIT 200");
    }

    @Test
    public void simpleExcept() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT id, name, code, depId FROM person WHERE depId >= 0  EXCEPT SELECT id, name, code, depId FROM person WHERE depId > 5 ");
    }

    @Test
    public void simpleExceptLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT id, name, code, depId FROM person WHERE depId >= 1  EXCEPT SELECT DISTINCT id, name, code, depId FROM person WHERE depId > 5 ");
    }

    @Test
    public void simpleIntersect() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT id, name, code, depId FROM person WHERE depId < 10  INTERSECT SELECT id, name, code, depId FROM person WHERE depId > 5 ");
    }

    @Test
    public void simpleIntersectLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "(SELECT id, name, code, depId FROM person WHERE depId < 10 ORDER BY code, id DESC LIMIT 900 OFFSET 10)  INTERSECT SELECT id, name, code, depId FROM person WHERE depId > 5 ");
    }

    @Test
    public void simpleSelectLimitOffset() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person ORDER BY name LIMIT 500 OFFSET 100");
    }

    @Test
    public void simpleSelectLimitOffsetLazy() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT * FROM person ORDER BY name LIMIT 800 OFFSET 20");
    }

    @Test
    public void simpleSelectOffset() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person ORDER BY name DESC OFFSET 50");
    }

    @Test
    public void simpleSelectOffsetLazy() {
        this.checkSortOrder = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT code, male, age, height, salary, tax, weight, temperature, time, date, timestamp, uuid FROM person ORDER BY name DESC OFFSET 50");
    }

    @Test
    public void simpleSelectLimit() {
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT * FROM person ORDER BY name LIMIT 700");
    }

    @Test
    public void simpleSelectLimitLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT DISTINCT code, male, age, height, salary, tax, weight FROM person ORDER BY tax DESC LIMIT 700");
    }

    @Test
    public void intersectUnionAllLimitOffset() {
        this.assertInMemoryAndOnDiskSameResults(false, "(SELECT *FROM person WHERE depId < 20 INTERSECT SELECT * FROM person WHERE depId > 1 )UNION ALL SELECT * FROM person WHERE age > 50 ORDER BY id LIMIT 1000 OFFSET 50 ");
    }

    @Test
    public void intersectUnionAllLimitOffsetLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "((SELECT * FROM person WHERE depId < 20 ORDER BY depId) INTERSECT SELECT * FROM person WHERE depId > 10 )UNION ALL SELECT DISTINCT * FROM person WHERE age <100  ORDER BY id LIMIT 10000 OFFSET 20 ");
    }

    @Test
    public void intersectJoinAllLimitOffset() {
        this.assertInMemoryAndOnDiskSameResults(false, "(SELECT DISTINCT p.age FROM person p JOIN department d WHERE d.id = p.depId AND depId < 10 UNION SELECT MAX(height) FROM person WHERE depId > 5  )UNION ALL SELECT DISTINCT id FROM person WHERE age < (SELECT SUM(id) FROM department WHERE id > 3)  UNION SELECT DISTINCT salary FROM person p JOIN department d ON p.age=d.id OR p.weight < 60 UNION SELECT MAX(salary) FROM person WHERE age > 10  GROUP BY temperature");
    }

    @Test
    public void intersectJoinAllLimitOffsetLazy() {
        this.assertInMemoryAndOnDiskSameResults(true, "(SELECT DISTINCT p.age FROM person p JOIN department d WHERE d.id = p.depId AND depId < 44 UNION SELECT MAX(height) FROM person WHERE depId > 5  )UNION ALL SELECT DISTINCT id FROM person WHERE age < (SELECT SUM(id) FROM department WHERE id > 2)  EXCEPT SELECT DISTINCT salary FROM person p JOIN department d ON p.age=d.id OR p.weight > 10");
    }

    @Test
    public void simpleGroupBy() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT age, depId, COUNT(*), MAX(salary), MIN(salary), AVG(salary), SUM(salary) FROM person GROUP BY age, depId");
    }

    @Test
    public void simpleGroupByLazy() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT depId, code, age, COUNT(*), SUM(salary),  LISTAGG(uuid) FROM person GROUP BY age, depId, code ");
    }

    @Test
    public void groupByWithUnion() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT age, code, COUNT(*), AVG(salary) FROM person GROUP BY code, age UNION SELECT age, name, SUM(age), MIN(salary) FROM person GROUP BY name, age");
    }

    @Test
    public void groupByWithExcept() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(true, "SELECT age, code, COUNT(id) FROM person GROUP BY code, age EXCEPT SELECT age, name, COUNT(temperature) FROM person GROUP BY name, age");
    }

    @Test
    public void simpleGroupByAllSupportedAggregates() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT code, age, COUNT(*), COUNT(temperature), AVG(temperature), SUM(temperature), MAX(temperature), MIN(temperature), LISTAGG(temperature)  FROM person GROUP BY age, code");
    }

    @Test
    public void simpleGroupByNullableAggregates() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT age, code, COUNT(nulls), COUNT(temperature), AVG(nulls), SUM(temperature), MAX(nulls), LISTAGG(temperature) FROM person GROUP BY age, code");
    }

    @Test
    public void groupByNullableAggregatesBigGroups() {
        this.checkGroupsSpilled = true;
        this.listAggs = Arrays.asList(4);
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT male, COUNT(nulls), COUNT(temperature), AVG(nulls), LISTAGG(temperature) FROM person GROUP BY male");
    }

    @Test
    public void groupByNullableAggregatesManySmallGroups() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT weight, age, COUNT(nulls), COUNT(temperature), AVG(temperature), SUM(temperature),  LISTAGG(name) FROM person GROUP BY age, weight");
    }

    @Test
    public void groupBySNullsAggregates() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT depId, age, COUNT(nulls), AVG(nulls), LISTAGG(nulls) FROM person GROUP BY age, depId");
    }

    @Test
    public void groupByAllSupportedDistinctAggregates() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT code, age, AVG(DISTINCT temperature), SUM(DISTINCT temperature), MAX(DISTINCT temperature), MIN(DISTINCT temperature)  FROM person GROUP BY age, code");
    }

    @Test
    public void groupByNullableDistinctAggregates() {
        this.checkGroupsSpilled = true;
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT age, code, COUNT(DISTINCT nulls), COUNT(DISTINCT temperature), AVG(DISTINCT nulls), SUM(DISTINCT temperature), MAX(DISTINCT nulls), LISTAGG(temperature) FROM person GROUP BY age, code");
    }

    @Test
    public void groupByValuesWithHaving() {
        this.checkGroupsSpilled = true;
        this.listAggs = Arrays.asList(2);
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT temperature, count(*), LISTAGG(name) FROM person GROUP BY temperature HAVING temperature > 38");
    }

    @Test
    public void simpleAggregate() {
        this.checkGroupsSpilled = true;
        this.listAggs = Arrays.asList(1, 2, 3, 4);
        this.assertInMemoryAndOnDiskSameResults(false, "SELECT count(*), LISTAGG(name), LISTAGG(name), LISTAGG(name), LISTAGG(name) FROM person");
    }
}

