/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assume;
import org.junit.Test;

public class DiskSpillingDmlTest
extends DiskSpillingAbstractTest {
    private static final String COLS = "id, name, depId,  code, male, age, height, salary, tax, weight, temperature,time,date,timestamp,uuid, nulls ";
    private static final String CREATE_NEW_TBL = "CREATE TABLE new_table (id BIGINT PRIMARY KEY, name VARCHAR, depId SMALLINT, code CHAR(3),male BOOLEAN,age TINYINT,height SMALLINT,salary INT,tax DECIMAL(4,4),weight DOUBLE,temperature REAL,time TIME,date DATE,timestamp TIMESTAMP,uuid UUID, nulls INT) WITH \"TEMPLATE=person\"";

    @Override
    protected void beforeTestsStarted() throws Exception {
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.initGrid();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.destroyGrid();
    }

    @Test
    public void testUpdatePlain() throws IOException {
        Assume.assumeFalse((boolean)((Boolean)GridTestUtils.getFieldValue(SqlFieldsQuery.class, (String[])new String[]{"DFLT_LAZY"})));
        this.testUpdate("UPDATE person SET age = age + 1 WHERE age > 0");
    }

    @Test
    public void testUpdateOrderBy() throws IOException {
        Assume.assumeFalse((boolean)((Boolean)GridTestUtils.getFieldValue(SqlFieldsQuery.class, (String[])new String[]{"DFLT_LAZY"})));
        this.testUpdate("UPDATE person SET age = age + 1 WHERE id > 500 ORDER BY age");
    }

    @Test
    public void testUpdateSubSelect() throws IOException {
        this.testUpdate("UPDATE person SET age = age + 1 WHERE age IN (SELECT age FROM person WHERE id < 200) AND age > 0");
    }

    @Test
    public void testUpdateDistinct() throws IOException {
        this.testUpdate("UPDATE person SET age = age + 1 WHERE age IN (SELECT DISTINCT age FROM person WHERE id > 800)");
    }

    private void testUpdate(String updateDml) throws IOException {
        DiskSpillingDmlTest.assertTrue((String)("Update DML should increment age by 1: " + updateDml), (boolean)updateDml.contains("SET age = age + 1"));
        List<List<?>> agesBefore = this.runSql("SELECT age FROM person");
        long affectedRows = this.runDmlAndCheckOffloading(updateDml);
        List<List<?>> agesAfter = this.runSql("SELECT age FROM person");
        DiskSpillingDmlTest.assertTrue((!agesBefore.isEmpty() ? 1 : 0) != 0);
        DiskSpillingDmlTest.assertEquals((int)agesBefore.size(), (int)agesAfter.size());
        int sumAgesBefore = this.sumAges(agesBefore);
        int sumAgesAfter = this.sumAges(agesAfter);
        DiskSpillingDmlTest.assertEquals((long)((long)sumAgesBefore + affectedRows), (long)sumAgesAfter);
        this.checkMemoryManagerState();
    }

    private Integer sumAges(List<List<?>> ages) {
        return ages.stream().map(l -> l.stream().mapToInt(e -> ((Byte)e).byteValue()).sum()).reduce(0, Integer::sum);
    }

    @Test
    public void testDeleteSimple() throws IOException {
        Assume.assumeFalse((boolean)((Boolean)GridTestUtils.getFieldValue(SqlFieldsQuery.class, (String[])new String[]{"DFLT_LAZY"})));
        this.testDelete("DELETE FROM person WHERE age > 10");
    }

    @Test
    public void testDeleteSubQuery() throws IOException {
        this.testDelete("DELETE FROM person WHERE age IN (SELECT age FROM person WHERE id < 150 AND age < 30 ORDER BY code)");
    }

    @Test
    public void testDeleteSubQueryDistinct() throws IOException {
        this.testDelete("DELETE FROM person WHERE age IN (SELECT DISTINCT age FROM person WHERE id > 900 AND age > 70)");
    }

    @Test
    public void testDeleteSubQueryUnion() throws IOException {
        this.testDelete("DELETE FROM person WHERE age IN ((SELECT age FROM person WHERE depId < 3) UNION ALL SELECT age FROM person WHERE age < 25  LIMIT 10000 OFFSET 20)");
    }

    private void testDelete(String deleteDml) throws IOException {
        Long cntBefore = (Long)this.runSql("SELECT COUNT(*) FROM person").get(0).get(0);
        long affectedRows = this.runDmlAndCheckOffloading(deleteDml);
        Long cntAfter = (Long)this.runSql("SELECT COUNT(*) FROM person").get(0).get(0);
        DiskSpillingDmlTest.assertTrue((String)("cntBefore=" + cntBefore + ", cntAfter=" + cntAfter), (cntBefore != null && cntAfter != null && cntBefore > 0L && cntAfter > 0L ? 1 : 0) != 0);
        DiskSpillingDmlTest.assertEquals((long)cntBefore, (long)(cntAfter + affectedRows));
        this.checkMemoryManagerState();
    }

    @Test
    public void testInsertSimple() throws IOException {
        Assume.assumeFalse((boolean)((Boolean)GridTestUtils.getFieldValue(SqlFieldsQuery.class, (String[])new String[]{"DFLT_LAZY"})));
        this.testInsert("INSERT INTO new_table (id, name, depId,  code, male, age, height, salary, tax, weight, temperature,time,date,timestamp,uuid, nulls )  SELECT * FROM person");
    }

    @Test
    public void testInsertSorted() throws IOException {
        this.testInsert("INSERT INTO new_table (id, name, depId,  code, male, age, height, salary, tax, weight, temperature,time,date,timestamp,uuid, nulls )  SELECT * FROM person WHERE id < 100 ORDER BY code");
    }

    @Test
    public void testInsertDistinct() throws IOException {
        this.testInsert("INSERT INTO new_table (id, name, depId,  code, male, age, height, salary, tax, weight, temperature,time,date,timestamp,uuid, nulls ) SELECT DISTINCT *  FROM person");
    }

    @Test
    public void testInsertUnion() throws IOException {
        this.testInsert("INSERT INTO new_table (id, name, depId,  code, male, age, height, salary, tax, weight, temperature,time,date,timestamp,uuid, nulls ) ((SELECT * FROM person WHERE depId > 95) UNION SELECT * FROM person WHERE age > 90  LIMIT 10000 OFFSET 20)");
    }

    private void testInsert(String insertDml) throws IOException {
        this.runSql(CREATE_NEW_TBL);
        long affectedRows = this.runDmlAndCheckOffloading(insertDml);
        Long newTblCnt = (Long)this.runSql("SELECT COUNT(*) FROM new_table").get(0).get(0);
        DiskSpillingDmlTest.assertTrue((String)("newTblCnt=" + newTblCnt), (newTblCnt != null && newTblCnt > 0L ? 1 : 0) != 0);
        DiskSpillingDmlTest.assertEquals((long)affectedRows, (long)newTblCnt);
        List<List<?>> newTblContent = this.runSql("SELECT * FROM new_table ORDER BY id");
        List<List<?>> oldTblCopiedContent = this.runSql("SELECT * FROM person WHERE id IN (SELECT id FROM new_table) ORDER BY id");
        DiskSpillingDmlTest.assertEqualsCollections(newTblContent, oldTblCopiedContent);
        this.checkMemoryManagerState();
    }

    private List<List<?>> runSql(String sql) {
        return this.grid(0).cache("default").query(new SqlFieldsQuery(sql)).getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long runDmlAndCheckOffloading(String dml) throws IOException {
        WatchService watchSvc = FileSystems.getDefault().newWatchService();
        try {
            Path workDir = this.getWorkDir();
            WatchKey watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            List res = this.grid(0).cache("default").query(new SqlFieldsQueryEx(dml, Boolean.valueOf(false)).setMaxMemory(4096L)).getAll();
            List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
            DiskSpillingDmlTest.assertFalse((String)"Disk spilling not happened.", (boolean)dirEvts.isEmpty());
            this.assertWorkDirClean();
            Long affectedRows = (Long)((List)res.get(0)).get(0);
            DiskSpillingDmlTest.assertNotNull((String)"No rows was updated", (Object)affectedRows);
            DiskSpillingDmlTest.assertTrue((String)("affectedRows=" + affectedRows), (affectedRows > 0L ? 1 : 0) != 0);
            long l = affectedRows;
            return l;
        }
        finally {
            U.closeQuiet((AutoCloseable)watchSvc);
        }
    }
}

