/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.internal.util.typedef.X;
import org.junit.Test;

public class DiskSpillingBasicTest
extends DiskSpillingAbstractTest {
    @Test
    public void testMultiThreaded() {
        int NUM_THREADS = Runtime.getRuntime().availableProcessors() + 1;
        final AtomicBoolean stop = new AtomicBoolean();
        final String[] qrys = new String[]{"(SELECT * FROM person WHERE depId < 40 INTERSECT SELECT * FROM person WHERE depId > 1 )UNION  SELECT * FROM person WHERE age > 50 ORDER BY id LIMIT 1000 OFFSET 50 ", "SELECT p.id, p.name, p.depId, d.title FROM person p, department d  WHERE p.depId > d.id", "SELECT  code, depId, salary, id  FROM person ORDER BY code, salary, id", "SELECT code, SUM(temperature), AVG(salary) FROM person WHERE age > 5 GROUP BY code", "SELECT DISTINCT code, salary, id  FROM person ORDER BY code, salary, id", "SELECT code, depId, salary, id  FROM person WHERE depId IN (SELECT id FROM department)"};
        final int qrysSize = qrys.length;
        final ArrayList<List> results = new ArrayList<List>(qrysSize);
        for (int i = 0; i < qrysSize; ++i) {
            results.add(i, this.grid(0).cache("default").query(new SqlFieldsQueryEx(qrys[i], Boolean.valueOf(true)).setMaxMemory(16384L)).getAll());
        }
        final AtomicReference err = new AtomicReference();
        final AtomicIntegerArray cntrs = new AtomicIntegerArray(NUM_THREADS);
        final AtomicInteger cntr = new AtomicInteger();
        final Thread testThread = Thread.currentThread();
        Runnable qryRunner = new Runnable(){

            @Override
            public void run() {
                int threadId = cntr.getAndIncrement();
                try {
                    while (!stop.get()) {
                        int qryNum = ThreadLocalRandom.current().nextInt(qrysSize);
                        List res = DiskSpillingBasicTest.this.grid(0).cache("default").query(new SqlFieldsQueryEx(qrys[qryNum], null).setMaxMemory(4096L).setLazy(true)).getAll();
                        DiskSpillingBasicTest.assertEqualsCollections((Collection)((Collection)results.get(qryNum)), (Collection)res);
                        cntrs.incrementAndGet(threadId);
                    }
                }
                catch (Throwable e) {
                    log.error("Error during query execution: " + X.getFullStackTrace((Throwable)e));
                    err.compareAndSet(null, e);
                    stop.set(true);
                    testThread.interrupt();
                }
            }
        };
        ArrayList<Thread> runners = new ArrayList<Thread>(NUM_THREADS);
        for (int i = 0; i < NUM_THREADS; ++i) {
            Thread runner = new Thread(qryRunner);
            runners.add(runner);
            runner.start();
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        stop.set(true);
        for (Thread runner : runners) {
            try {
                runner.join(60000L);
                DiskSpillingBasicTest.assertFalse((boolean)runner.isAlive());
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Can not stop thread:" + Arrays.toString(runner.getStackTrace()));
            }
        }
        DiskSpillingBasicTest.assertNull((String)X.getFullStackTrace((Throwable)((Throwable)err.get())), err.get());
        for (int i = 0; i < NUM_THREADS; ++i) {
            DiskSpillingBasicTest.assertTrue((String)"Thread with not executed queries found.", (cntrs.get(i) > 0 ? 1 : 0) != 0);
        }
        this.assertWorkDirClean();
        this.checkMemoryManagerState();
    }

    @Test
    public void testFilesDeletedOnError() throws IOException {
        String qry = "SELECT DISTINCT *, 1 / (p.id - 800) FROM person p, department d  WHERE p.depId = d.id";
        Path workDir = this.getWorkDir();
        WatchService watchSvc = FileSystems.getDefault().newWatchService();
        WatchKey watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        try {
            List res = this.grid(0).cache("default").query(new SqlFieldsQueryEx(qry, null).setMaxMemory(4096L).setLazy(true)).getAll();
            System.out.println("res=" + res);
            DiskSpillingBasicTest.fail((String)"Exception should be thrown.");
        }
        catch (Exception res) {
            // empty catch block
        }
        List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
        DiskSpillingBasicTest.assertFalse((boolean)dirEvts.isEmpty());
        this.assertWorkDirClean();
        this.checkMemoryManagerState();
    }

    @Test
    public void testNodeStartupDoesNotAffectRunningQueries() throws Exception {
        String query = "SELECT DISTINCT * FROM person p, department d WHERE p.depId = d.id";
        Path workDir = this.getWorkDir();
        WatchService watchSvc = FileSystems.getDefault().newWatchService();
        WatchKey watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        Iterator res = this.grid(0).cache("default").query(new SqlFieldsQueryEx(query, null).setMaxMemory(4096L).setLazy(true)).iterator();
        DiskSpillingBasicTest.assertFalse((boolean)((List)res.next()).isEmpty());
        this.startGrid();
        DiskSpillingBasicTest.assertFalse((boolean)((List)res.next()).isEmpty());
        while (res.hasNext()) {
            res.next();
        }
        List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
        DiskSpillingBasicTest.assertFalse((boolean)dirEvts.isEmpty());
        this.assertWorkDirClean();
        this.checkMemoryManagerState();
    }
}

