/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class ClientQueryQuotaTest
extends DiskSpillingAbstractTest {
    private static final String QUERY_512_TO_1024 = "SELECT DISTINCT id FROM person WHERE id < 5";
    private static final String QUERY_1024_TO_2048 = "SELECT DISTINCT id FROM person WHERE id < 10";
    private boolean client;
    private static String defaultQryQuota = "1024";

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(false).setSqlQueryMemoryQuota(defaultQryQuota).setSqlGlobalMemoryQuota("60%"));
        if (this.client) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    @Override
    protected boolean startClient() {
        return false;
    }

    @Test
    public void testClientQueryQuota() throws Exception {
        this.client = true;
        defaultQryQuota = "2048";
        this.startGrid(1);
        GridTestUtils.assertThrowsWithCause(() -> this.runQueryWithMemLimit(QUERY_512_TO_1024, 511L), SqlMemoryQuotaExceededException.class);
        this.runQueryWithMemLimit(QUERY_512_TO_1024, 1024L);
        GridTestUtils.assertThrowsWithCause(() -> this.runQueryWithMemLimit(QUERY_1024_TO_2048, 1023L), SqlMemoryQuotaExceededException.class);
        this.runQueryWithMemLimit(QUERY_1024_TO_2048, 2048L);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.runQueryFromClient(QUERY_1024_TO_2048, 1), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Query quota was exceeded.");
        defaultQryQuota = "512";
        this.startGrid(2);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.runQueryFromClient(QUERY_512_TO_1024, 2), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Query quota was exceeded.");
    }

    public void runQueryWithMemLimit(String sql, long qryQuota) {
        IgniteEx client = this.grid(1);
        client.cache("default").query(new SqlFieldsQueryEx(sql, Boolean.valueOf(true)).setMaxMemory(qryQuota)).getAll();
    }

    public void runQueryFromClient(String sql, int idx) {
        IgniteEx client = this.grid(idx);
        ClientQueryQuotaTest.assertTrue((boolean)client.cluster().node().isClient());
        client.cache("default").query(new SqlFieldsQuery(sql)).getAll();
    }
}

