/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class TableViewSubquerySelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 1;
    private static Ignite ignite;
    private static IgniteCache<?, ?> initCache;

    protected void beforeTestsStarted() throws Exception {
        ignite = this.startGridsMultiThreaded(1, false);
        initCache = ignite.getOrCreateCache(new CacheConfiguration("default").setSqlSchema("PUBLIC"));
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        ignite = null;
        initCache = null;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testSubqueryTableView() {
        List rows;
        String cacheName = "a1";
        String creationQry = "CREATE TABLE t1 ( id INT NOT NULL, int_col1 INT NOT NULL, PRIMARY KEY (id)) WITH \"TEMPLATE=partitioned, cache_name=%s\"";
        try (FieldsQueryCursor cur = initCache.query(new SqlFieldsQuery(String.format("CREATE TABLE t1 ( id INT NOT NULL, int_col1 INT NOT NULL, PRIMARY KEY (id)) WITH \"TEMPLATE=partitioned, cache_name=%s\"", "a1")));){
            TableViewSubquerySelfTest.assertNotNull((Object)cur);
            List rows2 = cur.getAll();
            TableViewSubquerySelfTest.assertEquals((int)1, (int)rows2.size());
            TableViewSubquerySelfTest.assertEquals((Object)0L, ((List)rows2.get(0)).get(0));
        }
        IgniteCache cache = ignite.getOrCreateCache("a1");
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery("INSERT INTO t1 (id,int_col1) VALUES (1,0),(2,2),(3,0),(4,2)"));){
            TableViewSubquerySelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            TableViewSubquerySelfTest.assertEquals((int)1, (int)rows.size());
            TableViewSubquerySelfTest.assertEquals((Object)4L, ((List)rows.get(0)).get(0));
        }
        cur = cache.query(new SqlFieldsQuery("SELECT * FROM ( SELECT * FROM t1 WHERE int_col1 > 0 ORDER BY id ) WHERE int_col1 = 1"));
        var5_5 = null;
        try {
            TableViewSubquerySelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            TableViewSubquerySelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable rows3) {
            var5_5 = rows3;
            throw rows3;
        }
        finally {
            if (cur != null) {
                if (var5_5 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable rows3) {
                        var5_5.addSuppressed(rows3);
                    }
                } else {
                    cur.close();
                }
            }
        }
        cur = cache.query(new SqlFieldsQuery("SELECT * FROM ( SELECT * FROM t1 WHERE int_col1 < 0 ORDER BY id ) WHERE int_col1 = 1"));
        var5_5 = null;
        try {
            TableViewSubquerySelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            TableViewSubquerySelfTest.assertEquals((int)0, (int)rows.size());
        }
        catch (Throwable rows4) {
            var5_5 = rows4;
            throw rows4;
        }
        finally {
            if (cur != null) {
                if (var5_5 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable rows4) {
                        var5_5.addSuppressed(rows4);
                    }
                } else {
                    cur.close();
                }
            }
        }
        cur = cache.query(new SqlFieldsQuery("SELECT * FROM ( SELECT * FROM t1 WHERE int_col1 > 0 ORDER BY id ) WHERE int_col1 = 2"));
        var5_5 = null;
        try {
            TableViewSubquerySelfTest.assertNotNull((Object)cur);
            rows = cur.getAll();
            TableViewSubquerySelfTest.assertEquals((int)2, (int)rows.size());
            TableViewSubquerySelfTest.assertEquals((Object)2, ((List)rows.get(0)).get(0));
            TableViewSubquerySelfTest.assertEquals((Object)2, ((List)rows.get(0)).get(1));
            TableViewSubquerySelfTest.assertEquals((Object)4, ((List)rows.get(1)).get(0));
            TableViewSubquerySelfTest.assertEquals((Object)2, ((List)rows.get(1)).get(1));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var5_5 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
    }
}

