/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservationKey;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservationManager;
import org.apache.ignite.internal.processors.query.h2.twostep.ReducePartitionMapResult;
import org.apache.ignite.internal.processors.query.h2.twostep.ReducePartitionMapper;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Ignore;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_SQL_RETRY_TIMEOUT", value="5000")
public class RetryCauseMessageSelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 2;
    private static final String ORG_SQL = "select * from Organization";
    static final String UPDATE_SQL = "UPDATE Person SET name=lower(?) ";
    private static final String ORG = "org";
    private IgniteCache<String, JoinSqlTestHelper.Person> personCache;
    private IgniteCache<String, JoinSqlTestHelper.Organization> orgCache;
    private IgniteH2Indexing h2Idx;

    protected long getTestTimeout() {
        return 600000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynthCacheWasNotFoundMessage() throws IgniteCheckedException {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(){

            @Override
            public void onQueryRequest(ClusterNode node, GridH2QueryRequest qryReq) throws IgniteCheckedException {
                qryReq.caches().add(Integer.MAX_VALUE);
                this.startedExecutor.onQueryRequest(node, qryReq);
                qryReq.caches().remove(qryReq.caches().size() - 1);
            }
        }.insertRealExecutor(mapQryExec, this.h2Idx)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Failed to reserve partitions for query (cache is not found on local node) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrpReservationFailureMessage() throws IgniteCheckedException {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final ConcurrentMap<PartitionReservationKey, GridReservable> reservations = RetryCauseMessageSelfTest.reservations(this.h2Idx);
        GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(){

            @Override
            public void onQueryRequest(ClusterNode node, GridH2QueryRequest qryReq) throws IgniteCheckedException {
                PartitionReservationKey grpKey = new PartitionReservationKey(RetryCauseMessageSelfTest.ORG, null);
                reservations.put(grpKey, new GridReservable(){

                    public boolean reserve() {
                        return false;
                    }

                    public void release() {
                    }
                });
                this.startedExecutor.onQueryRequest(node, qryReq);
            }
        }.insertRealExecutor(mapQryExec, this.h2Idx)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to reserve partitions for query (group reservation failed) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-7039")
    @Test
    public void testReplicatedCacheReserveFailureMessage() throws IgniteCheckedException {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final GridKernalContext ctx = (GridKernalContext)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"ctx");
        GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(){

            @Override
            public void onQueryRequest(ClusterNode node, GridH2QueryRequest qryReq) throws IgniteCheckedException {
                GridCacheContext cctx = ctx.cache().context().cacheContext(((Integer)qryReq.caches().get(0)).intValue());
                GridDhtLocalPartition part = cctx.topology().localPartition(0, AffinityTopologyVersion.NONE, false);
                AtomicLong aState = (AtomicLong)GridTestUtils.getFieldValue((Object)part, GridDhtLocalPartition.class, (String)"state");
                long stateVal = aState.getAndSet(2L);
                this.startedExecutor.onQueryRequest(node, qryReq);
                aState.getAndSet(stateVal);
            }
        }.insertRealExecutor(mapQryExec, this.h2Idx)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Organization.class, ORG_SQL);
        qry.setDistributedJoins(true);
        try {
            this.orgCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to reserve partitions for query (partition of REPLICATED cache is not in OWNING state) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionedCacheReserveFailureMessage() throws IgniteCheckedException {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final GridKernalContext ctx = (GridKernalContext)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"ctx");
        GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(){

            @Override
            public void onQueryRequest(ClusterNode node, GridH2QueryRequest qryReq) throws IgniteCheckedException {
                GridCacheContext cctx = ctx.cache().context().cacheContext(((Integer)qryReq.caches().get(0)).intValue());
                GridDhtLocalPartition part = cctx.topology().localPartition(0, AffinityTopologyVersion.NONE, false);
                AtomicLong aState = (AtomicLong)GridTestUtils.getFieldValue((Object)part, GridDhtLocalPartition.class, (String)"state");
                long stateVal = aState.getAndSet(2L);
                this.startedExecutor.onQueryRequest(node, qryReq);
                aState.getAndSet(stateVal);
            }
        }.insertRealExecutor(mapQryExec, this.h2Idx)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to reserve partitions for query (partition of PARTITIONED cache is not found or not in OWNING state) "));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonCollocatedFailureMessage() throws IgniteCheckedException {
        GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
        final ConcurrentMap<PartitionReservationKey, GridReservable> reservations = RetryCauseMessageSelfTest.reservations(this.h2Idx);
        GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)((Object)new MockGridMapQueryExecutor(){

            @Override
            public void onQueryRequest(ClusterNode node, GridH2QueryRequest qryReq) throws IgniteCheckedException {
                PartitionReservationKey grpKey = new PartitionReservationKey(RetryCauseMessageSelfTest.ORG, null);
                reservations.put(grpKey, new GridReservable(){

                    public boolean reserve() {
                        throw H2Utils.retryException((String)"test retry exception");
                    }

                    public void release() {
                    }
                });
                this.startedExecutor.onQueryRequest(node, qryReq);
            }
        }.insertRealExecutor(mapQryExec, this.h2Idx)));
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
        }
        catch (CacheException e) {
            RetryCauseMessageSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to execute non-collocated query (will retry) ["));
            return;
        }
        finally {
            GridTestUtils.setFieldValue((Object)this.h2Idx, (String)"mapQryExec", (Object)mapQryExec);
        }
        RetryCauseMessageSelfTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryMappingFailureMessage() {
        GridReduceQueryExecutor rdcQryExec = (GridReduceQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"rdcQryExec");
        ReducePartitionMapper mapper = (ReducePartitionMapper)GridTestUtils.getFieldValue((Object)rdcQryExec, GridReduceQueryExecutor.class, (String)"mapper");
        IgniteLogger logger = (IgniteLogger)GridTestUtils.getFieldValue((Object)rdcQryExec, GridReduceQueryExecutor.class, (String)"log");
        GridKernalContext ctx = (GridKernalContext)GridTestUtils.getFieldValue((Object)rdcQryExec, GridReduceQueryExecutor.class, (String)"ctx");
        GridTestUtils.setFieldValue((Object)rdcQryExec, (String)"mapper", (Object)new ReducePartitionMapper(ctx, logger){

            public ReducePartitionMapResult nodesForPartitions(List<Integer> cacheIds, AffinityTopologyVersion topVer, int[] parts, boolean isReplicatedOnly) {
                ReducePartitionMapResult res = super.nodesForPartitions(cacheIds, topVer, parts, isReplicatedOnly);
                return new ReducePartitionMapResult(Collections.emptyList(), res.partitionsMap(), res.queryPartitionsMap());
            }
        });
        try {
            SqlFieldsQuery qry = new SqlFieldsQuery("select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
            Throwable throwable = GridTestUtils.assertThrows((IgniteLogger)log, () -> this.personCache.query(qry).getAll(), CacheException.class, (String)"Failed to map SQL query to topology during timeout:");
            throwable.printStackTrace();
        }
        finally {
            GridTestUtils.setFieldValue((Object)rdcQryExec, (String)"mapper", (Object)mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateQueryMappingFailureMessage() {
        GridReduceQueryExecutor rdcQryExec = (GridReduceQueryExecutor)GridTestUtils.getFieldValue((Object)this.h2Idx, IgniteH2Indexing.class, (String)"rdcQryExec");
        ReducePartitionMapper mapper = (ReducePartitionMapper)GridTestUtils.getFieldValue((Object)rdcQryExec, GridReduceQueryExecutor.class, (String)"mapper");
        IgniteLogger logger = (IgniteLogger)GridTestUtils.getFieldValue((Object)rdcQryExec, GridReduceQueryExecutor.class, (String)"log");
        GridKernalContext ctx = (GridKernalContext)GridTestUtils.getFieldValue((Object)rdcQryExec, GridReduceQueryExecutor.class, (String)"ctx");
        GridTestUtils.setFieldValue((Object)rdcQryExec, (String)"mapper", (Object)new ReducePartitionMapper(ctx, logger){

            public ReducePartitionMapResult nodesForPartitions(List<Integer> cacheIds, AffinityTopologyVersion topVer, int[] parts, boolean isReplicatedOnly) {
                ReducePartitionMapResult res = super.nodesForPartitions(cacheIds, topVer, parts, isReplicatedOnly);
                return new ReducePartitionMapResult(Collections.emptyList(), res.partitionsMap(), res.queryPartitionsMap());
            }
        });
        try {
            SqlFieldsQuery qry = new SqlFieldsQuery(UPDATE_SQL).setArgs(new Object[]{"New Name"});
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.personCache.query(qry).getAll(), CacheException.class, (String)"Failed to map SQL query to topology during timeout");
            qry.setArgs(new Object[]{"Another Name"});
            qry.setSkipReducerOnUpdate(true);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> this.personCache.query(qry).getAll(), CacheException.class, (String)"Failed to determine nodes participating in the update. ");
        }
        finally {
            GridTestUtils.setFieldValue((Object)rdcQryExec, (String)"mapper", (Object)mapper);
        }
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
                assert (msg != null);
                super.sendMessage(node, msg, ackC);
            }
        });
        return cfg;
    }

    protected void beforeTest() throws Exception {
        Ignite ignite = this.startGridsMultiThreaded(2, false);
        GridQueryProcessor qryProc = this.grid(ignite.name()).context().query();
        this.h2Idx = (IgniteH2Indexing)GridTestUtils.getFieldValue((Object)qryProc, GridQueryProcessor.class, (String)"idx");
        this.personCache = this.ignite(0).getOrCreateCache(new CacheConfiguration("pers").setQueryEntities(JoinSqlTestHelper.personQueryEntity()));
        this.orgCache = this.ignite(0).getOrCreateCache(new CacheConfiguration(ORG).setCacheMode(CacheMode.REPLICATED).setQueryEntities(JoinSqlTestHelper.organizationQueryEntity()));
        this.awaitPartitionMapExchange();
        JoinSqlTestHelper.populateDataIntoOrg(this.orgCache);
        JoinSqlTestHelper.populateDataIntoPerson(this.personCache);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private static ConcurrentMap<PartitionReservationKey, GridReservable> reservations(IgniteH2Indexing h2Idx) {
        PartitionReservationManager partReservationMgr = h2Idx.partitionReservationManager();
        return (ConcurrentMap)GridTestUtils.getFieldValue((Object)partReservationMgr, PartitionReservationManager.class, (String)"reservations");
    }

    private static abstract class MockGridMapQueryExecutor
    extends GridMapQueryExecutor {
        GridMapQueryExecutor startedExecutor;

        private MockGridMapQueryExecutor() {
        }

        MockGridMapQueryExecutor insertRealExecutor(GridMapQueryExecutor startedExecutor, IgniteH2Indexing h2Idx) throws IgniteCheckedException {
            this.startedExecutor = startedExecutor;
            this.start(h2Idx.kernalContext(), h2Idx);
            return this;
        }

        public void onQueryRequest(ClusterNode node, GridH2QueryRequest req) throws IgniteCheckedException {
            this.startedExecutor.onQueryRequest(node, req);
        }
    }
}

