/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_SQL_RETRY_TIMEOUT", value="5000")
public class DisappearedCacheCauseRetryMessageSelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 2;
    private static final String ORG = "org";
    private IgniteCache<String, JoinSqlTestHelper.Person> personCache;
    private IgniteCache<String, JoinSqlTestHelper.Organization> orgCache;

    @Test
    public void testDisappearedCacheCauseRetryMessage() {
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            this.personCache.query((Query)qry).getAll();
            DisappearedCacheCauseRetryMessageSelfTest.fail((String)"No CacheException emitted.");
        }
        catch (CacheException e) {
            if (!e.getMessage().contains("Failed to reserve partitions for query (cache is not found on local node) [")) {
                e.printStackTrace();
            }
            DisappearedCacheCauseRetryMessageSelfTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Failed to reserve partitions for query (cache is not found on local node) ["));
        }
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){
            volatile long reqId = -1L;

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
                assert (msg != null);
                if (GridIoMessage.class.isAssignableFrom(msg.getClass())) {
                    GridQueryCancelRequest req;
                    GridIoMessage gridMsg = (GridIoMessage)msg;
                    if (GridH2QueryRequest.class.isAssignableFrom(gridMsg.message().getClass())) {
                        GridH2QueryRequest req2 = (GridH2QueryRequest)gridMsg.message();
                        this.reqId = req2.requestId();
                        DisappearedCacheCauseRetryMessageSelfTest.this.orgCache.destroy();
                    } else if (GridQueryCancelRequest.class.isAssignableFrom(gridMsg.message().getClass()) && this.reqId == (req = (GridQueryCancelRequest)gridMsg.message()).queryRequestId()) {
                        DisappearedCacheCauseRetryMessageSelfTest.this.orgCache = DisappearedCacheCauseRetryMessageSelfTest.this.ignite(0).getOrCreateCache(new CacheConfiguration(DisappearedCacheCauseRetryMessageSelfTest.ORG).setCacheMode(CacheMode.REPLICATED).setQueryEntities(JoinSqlTestHelper.organizationQueryEntity()));
                    }
                }
                super.sendMessage(node, msg, ackC);
            }
        });
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.startGridsMultiThreaded(2, false);
        this.personCache = this.ignite(0).getOrCreateCache(new CacheConfiguration("pers").setQueryEntities(JoinSqlTestHelper.personQueryEntity()));
        this.orgCache = this.ignite(0).getOrCreateCache(new CacheConfiguration(ORG).setCacheMode(CacheMode.REPLICATED).setQueryEntities(JoinSqlTestHelper.organizationQueryEntity()));
        this.awaitPartitionMapExchange();
        JoinSqlTestHelper.populateDataIntoOrg(this.orgCache);
        JoinSqlTestHelper.populateDataIntoPerson(this.personCache);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }
}

