/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.junit.Test;

public class AndOperationExtractPartitionSelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 8;
    private static IgniteCache<String, JoinSqlTestHelper.Organization> orgCache;
    private static LongAdder cnt;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
                GridIoMessage gridMsg;
                assert (msg != null);
                if (GridIoMessage.class.isAssignableFrom(msg.getClass()) && GridH2QueryRequest.class.isAssignableFrom((gridMsg = (GridIoMessage)msg).message().getClass())) {
                    cnt.increment();
                }
                super.sendMessage(node, msg, ackC);
            }
        });
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        List rows;
        this.startGridsMultiThreaded(8, false);
        orgCache = this.ignite(0).getOrCreateCache(new CacheConfiguration("org").setCacheMode(CacheMode.PARTITIONED).setQueryEntities(JoinSqlTestHelper.organizationQueryEntity()));
        this.awaitPartitionMapExchange();
        JoinSqlTestHelper.populateDataIntoOrg(orgCache);
        try (FieldsQueryCursor cur = orgCache.query(new SqlFieldsQuery("SELECT * FROM Organization org WHERE org.id = 'org0'"));){
            assert (cur != null);
            rows = cur.getAll();
            assert (rows.size() == 1);
        }
        cur = orgCache.query(new SqlFieldsQuery("SELECT * FROM Organization org WHERE org.id = ?").setArgs(new Object[]{"org0"}));
        var2_2 = null;
        try {
            assert (cur != null);
            rows = cur.getAll();
            assert (rows.size() == 1);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (cur != null) {
                if (var2_2 != null) {
                    try {
                        cur.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    cur.close();
                }
            }
        }
    }

    @Test
    public void testAlternativeUsageOfIn() {
        try (FieldsQueryCursor cur = orgCache.query(new SqlFieldsQuery("SELECT * FROM Organization org WHERE org._KEY = 'org1' AND org._KEY IN (SELECT subOrg._KEY FROM Organization subOrg)"));){
            AndOperationExtractPartitionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            AndOperationExtractPartitionSelfTest.assertEquals((int)1, (int)rows.size());
        }
    }

    @Test
    public void testEmptyList() {
        this.testAndOperator(Collections.emptyList(), null, 0L, 7);
    }

    @Test
    public void testSingleValueList() {
        this.testAndOperator(Collections.singletonList("org0"), null, 0L, 0);
        this.testAndOperator(Collections.singletonList("org1"), null, 1L, 1);
        this.testAndOperator(Collections.singletonList("ORG"), null, 0L, 0);
        this.testAndOperator(Collections.singletonList("?"), new String[]{"org0"}, 0L, 0);
        this.testAndOperator(Collections.singletonList("?"), new String[]{"org2"}, 1L, 1);
        this.testAndOperator(Collections.singletonList("?"), new String[]{"ORG"}, 0L, 0);
        this.testBothSidesParameterized(Collections.singletonList("?"), new String[]{"ORG", "org1"}, 0L, 0);
        this.testBothSidesParameterized(Collections.singletonList("?"), new String[]{"org2", "org1"}, 1L, 1);
    }

    @Test
    public void testMultipleValueList() {
        this.testAndOperator(Arrays.asList("org0", "org3", "org" + String.valueOf(99)), null, 1L, 1);
        this.testAndOperator(Arrays.asList("ORG", "org0", "org4", "org" + String.valueOf(99)), null, 0L, 0);
        this.testAndOperator(Arrays.asList("org0", "org2", "org" + String.valueOf(99), "ORG"), null, 1L, 1);
        this.testAndOperator(Arrays.asList("org0", "org1", "MID", "org" + String.valueOf(99), "org3"), null, 2L, 2);
        List<String> allArgs3 = Arrays.asList("?", "?", "?");
        List<String> allArgs4 = Arrays.asList("?", "?", "?", "?");
        this.testAndOperator(allArgs3, new String[]{"org0", "org1", "org" + String.valueOf(99)}, 1L, 1);
        this.testAndOperator(allArgs4, new String[]{"ORG", "org2", "org8", "org" + String.valueOf(99)}, 1L, 1);
        this.testAndOperator(allArgs4, new String[]{"org1", "org3", "org" + String.valueOf(99), "ORG"}, 2L, 2);
        this.testAndOperator(allArgs4, new String[]{"org0", "MID", "org" + String.valueOf(99), "ORG"}, 0L, 0);
        this.testAndOperator(Arrays.asList("?", "org2", "org" + String.valueOf(99), "?"), new String[]{"org1", "ORG"}, 2L, 2);
        this.testAndOperator(Arrays.asList("?", "org9", "org" + String.valueOf(99), "?"), new String[]{"org1", "ORG"}, 1L, 1);
        this.testAndOperator(Arrays.asList("?", "?", "org" + String.valueOf(99), "ORG"), new String[]{"org0", "MID"}, 0L, 0);
        this.testBothSidesParameterized(allArgs3, new String[]{"org0", "org1", "org" + String.valueOf(99), "org1"}, 1L, 1);
        this.testBothSidesParameterized(allArgs4, new String[]{"ORG", "org2", "org8", "org" + String.valueOf(99), "org1"}, 1L, 1);
        this.testBothSidesParameterized(allArgs4, new String[]{"org1", "org3", "org" + String.valueOf(99), "ORG", "org1"}, 2L, 2);
        this.testBothSidesParameterized(allArgs4, new String[]{"org0", "MID", "org" + String.valueOf(99), "ORG", "org1"}, 0L, 0);
        this.testAndOperator(Arrays.asList("?", "org10", "org" + String.valueOf(99), "?"), new String[]{"org1", "org2"}, 2L, 2);
        this.testBothSidesParameterized(Arrays.asList("?", "org9", "org" + String.valueOf(99), "?"), new String[]{"org2", "ORG", "org1"}, 1L, 1);
        this.testBothSidesParameterized(Arrays.asList("?", "?", "org" + String.valueOf(99), "ORG"), new String[]{"org0", "MID", "org1"}, 0L, 0);
    }

    private void testAndOperator(List<String> cnst, Object[] args, long expRes, int maxReq) {
        int curIdx = cnt.intValue();
        String toIn = cnst.isEmpty() ? "" : String.valueOf("'" + String.join((CharSequence)"','", cnst) + "'").replace("'?'", "?");
        try (FieldsQueryCursor cur = orgCache.query(new SqlFieldsQuery("SELECT * FROM Organization org WHERE org._KEY IN (" + toIn + ") AND org._KEY IN ('org1','org2','org3')").setArgs(args));){
            AndOperationExtractPartitionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            AndOperationExtractPartitionSelfTest.assertEquals((long)expRes, (long)rows.size());
            AndOperationExtractPartitionSelfTest.assertTrue((cnt.intValue() - curIdx <= maxReq ? 1 : 0) != 0);
        }
    }

    private void testBothSidesParameterized(List<String> cnst, Object[] args, long expRes, int maxReq) {
        int curIdx = cnt.intValue();
        String toIn = cnst.isEmpty() ? "" : String.valueOf("'" + String.join((CharSequence)"','", cnst) + "'").replace("'?'", "?");
        try (FieldsQueryCursor cur = orgCache.query(new SqlFieldsQuery("SELECT * FROM Organization org WHERE org._KEY IN (" + toIn + ") AND org._KEY IN (?,'org2','org3')").setArgs(args));){
            AndOperationExtractPartitionSelfTest.assertNotNull((Object)cur);
            List rows = cur.getAll();
            AndOperationExtractPartitionSelfTest.assertEquals((long)expRes, (long)rows.size());
            AndOperationExtractPartitionSelfTest.assertTrue((cnt.intValue() - curIdx <= maxReq ? 1 : 0) != 0);
        }
    }

    static {
        cnt = new LongAdder();
    }
}

