/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ObjectHashInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.StringInlineIndexColumn;
import org.apache.ignite.testframework.junits.GridTestBinaryMarshaller;
import org.apache.ignite.testframework.junits.GridTestKernalContext;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueByte;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueJavaObject;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueStringFixed;
import org.gridgain.internal.h2.value.ValueStringIgnoreCase;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueUuid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="h2.serializeJavaObject", value="false"), @WithSystemProperty(key="h2.objectCache", value="false")})
public class InlineIndexColumnTest
extends AbstractIndexingCommonTest {
    private static final int CACHE_ID = 42;
    private static final int PAGE_SIZE = 1024;
    private static final long MB = 1024L;
    private static final Comparator<Value> ALWAYS_FAILS_COMPARATOR = new AlwaysFailsComparator();
    private final GridTestBinaryMarshaller marsh = new GridTestBinaryMarshaller(log);
    private boolean inlineObjHash;

    @Before
    public void resetState() {
        this.inlineObjHash = false;
    }

    @Test
    public void testConvert() {
        byte[] bytes = StringInlineIndexColumn.trimUTF8((byte[])"00\u20ac\u20ac".getBytes(StandardCharsets.UTF_8), (int)7);
        InlineIndexColumnTest.assertEquals((int)5, (int)bytes.length);
        String s = new String(bytes);
        InlineIndexColumnTest.assertEquals((int)3, (int)s.length());
        bytes = StringInlineIndexColumn.trimUTF8((byte[])"aaaaaa".getBytes(StandardCharsets.UTF_8), (int)4);
        InlineIndexColumnTest.assertEquals((int)4, (int)bytes.length);
    }

    @Test
    public void testCompare1bytes() throws Exception {
        int maxSize = 5;
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare("aa", "aa", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("aa", "bb", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("aaa", "bbb", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("bbb", "aaa", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("aaa", "aa", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("aaa", "a", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("aaa", "aaa", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("aaa", "aab", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("aab", "aaa", String.class, maxSize));
    }

    @Test
    public void testCompare2bytes() throws Exception {
        int maxSize = 7;
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare("\u00a1\u00a1", "\u00a1\u00a1", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("\u00a1\u00a1", "\u00a2\u00a2", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a2\u00a2\u00a2", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\u00a2\u00a2\u00a2", "\u00a1\u00a1\u00a1", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1\u00a1", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1\u00a1\u00a1", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\u00a1\u00a1\u00a1", "\u00a1\u00a1\u00a2", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\u00a1\u00a1\u00a2", "\u00a1\u00a1\u00a1", String.class, maxSize));
    }

    @Test
    public void testCompare3bytes() throws Exception {
        int maxSize = 9;
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare("\u0904\u0904", "\u0904\u0904", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("\u0904\u0904", "\u0905\u0905", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0905\u0905\u0905", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\u0905\u0905\u0905", "\u0904\u0904\u0904", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904\u0904", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904\u0904\u0904", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\u0904\u0904\u0904", "\u0904\u0904\u0905", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\u0904\u0904\u0905", "\u0904\u0904\u0904", String.class, maxSize));
    }

    @Test
    public void testCompare4bytes() throws Exception {
        int maxSize = 11;
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare("\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20", "\ud802\udd21\ud802\udd21", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd21\ud802\udd21\ud802\udd21", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\ud802\udd21\ud802\udd21\ud802\udd21", "\ud802\udd20\ud802\udd20\ud802\udd20", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20\ud802\udd20", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd20", "\ud802\udd20\ud802\udd20\ud802\udd21", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\ud802\udd21", "\ud802\udd20\ud802\udd20\ud802\udd20", String.class, maxSize));
    }

    @Test
    public void testCompareMixed() throws Exception {
        int maxSize = 11;
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare("\ud802\udd20\u0904", "\ud802\udd20\u0904", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare("\ud802\udd20\u0904", "\ud802\udd20\u0905", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("\u0905\ud802\udd20", "\u0904\ud802\udd20", String.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("\ud802\udd20\ud802\udd20\u0905", "\ud802\udd20\ud802\udd20\u0904", String.class, maxSize));
    }

    @Test
    public void testCompareMixed2() throws Exception {
        int i;
        int strCnt = 1000;
        int symbCnt = 20;
        int inlineSize = symbCnt * 4 + 3;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        Object[] strings = new String[strCnt];
        for (i = 0; i < strings.length; ++i) {
            strings[i] = this.randomString(symbCnt);
        }
        Arrays.sort(strings);
        for (i = 0; i < 100; ++i) {
            int i1 = rnd.nextInt(strings.length);
            int i2 = rnd.nextInt(strings.length);
            InlineIndexColumnTest.assertEquals((int)Integer.compare(i1, i2), (int)this.putAndCompare(strings[i1], strings[i2], String.class, inlineSize));
        }
    }

    @Test
    public void compareDifferentTypes() throws Exception {
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare("1", 1, String.class, Integer.class, 5));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare("11", 11, String.class, Integer.class, 5));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare("222", 222, String.class, Integer.class, 5));
        UUID uuid = UUID.randomUUID();
        ValueUuid valUuid = ValueUuid.get((UUID)uuid);
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(valUuid.getBytes(), uuid, byte[].class, UUID.class, 100));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(valUuid.getBytes(), uuid, byte[].class, UUID.class, 5));
        this.inlineObjHash = true;
        TestPojo val = new TestPojo(0, 0L);
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(val, uuid, TestPojo.class, UUID.class, 5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <InlineT, ValueT> int putAndCompare(InlineT inlineVal, ValueT val, Class<InlineT> clsInline, Class<ValueT> clsVal, int maxSize) throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        DataRegionMetricsImpl dataRegionMetrics = new DataRegionMetricsImpl(plcCfg, (GridKernalContext)new GridTestKernalContext(this.log()));
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(log, (DirectMemoryProvider)new UnsafeMemoryProvider(log), 1024, plcCfg, dataRegionMetrics, false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            CompareMode cmpMode = CompareMode.getInstance((String)"OFF", (int)1);
            InlineIndexColumnFactory factory = new InlineIndexColumnFactory(cmpMode);
            InlineIndexColumn ih = factory.createInlineHelper(new Column("", this.wrap(inlineVal, clsInline).getValueType()), this.inlineObjHash);
            ih.put(pageAddr, off, this.wrap(inlineVal, clsInline), maxSize);
            int n = ih.compare(pageAddr, off, maxSize, this.wrap(val, clsVal), (v1, v2) -> v1.compareTo(v2, null, cmpMode));
            return n;
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> int putAndCompare(T v1, T v2, Class<T> cls, int maxSize) throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        DataRegionMetricsImpl dataRegionMetrics = new DataRegionMetricsImpl(plcCfg, (GridKernalContext)new GridTestKernalContext(this.log()));
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(log, (DirectMemoryProvider)new UnsafeMemoryProvider(log), 1024, plcCfg, dataRegionMetrics, false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexColumnFactory factory = new InlineIndexColumnFactory(CompareMode.getInstance((String)"OFF", (int)1));
            InlineIndexColumn ih = factory.createInlineHelper(new Column("", this.wrap(v1, cls).getValueType()), this.inlineObjHash);
            ih.put(pageAddr, off, this.wrap(v1, cls), maxSize);
            int n = ih.compare(pageAddr, off, maxSize, this.wrap(v2, cls), ALWAYS_FAILS_COMPARATOR);
            return n;
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    @Test
    public void testStringCut() {
        byte[] bytes = StringInlineIndexColumn.trimUTF8((byte[])"\u20ac\u20ac".getBytes(StandardCharsets.UTF_8), (int)2);
        InlineIndexColumnTest.assertNull((Object)bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStringTruncate() throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(log, (DirectMemoryProvider)new UnsafeMemoryProvider(log), 1024, plcCfg, new DataRegionMetricsImpl(plcCfg, (GridKernalContext)new GridTestKernalContext(this.log())), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexColumnFactory factory = new InlineIndexColumnFactory(CompareMode.getInstance((String)"DEFAULT_", (int)1));
            AbstractInlineIndexColumn ih = (AbstractInlineIndexColumn)factory.createInlineHelper(new Column("", 13), false);
            ih.put(pageAddr, off, ValueString.get((String)"aaaaaaa"), 8);
            InlineIndexColumnTest.assertEquals((String)"aaaaa", (String)ih.get(pageAddr, off, 8).getString());
            ih.put(pageAddr, off, ValueString.get((String)"aaa"), 8);
            InlineIndexColumnTest.assertEquals((String)"aaa", (String)ih.get(pageAddr, off, 8).getString());
            ih.put(pageAddr, off, ValueString.get((String)"\u20acaaa"), 5);
            InlineIndexColumnTest.assertNull((Object)ih.get(pageAddr, off, 5));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytes() throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(log, (DirectMemoryProvider)new UnsafeMemoryProvider(log), 1024, plcCfg, new DataRegionMetricsImpl(plcCfg, (GridKernalContext)new GridTestKernalContext(this.log())), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexColumnFactory factory = new InlineIndexColumnFactory(CompareMode.getInstance((String)"DEFAULT_", (int)1));
            AbstractInlineIndexColumn ih = (AbstractInlineIndexColumn)factory.createInlineHelper(new Column("", 12), false);
            int maxSize = 6;
            int savedBytesCnt = ih.put(pageAddr, off, (Value)ValueBytes.get((byte[])new byte[]{1, 2, 3, 4, 5}), maxSize);
            InlineIndexColumnTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexColumnTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            maxSize = 8;
            InlineIndexColumnTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, ih.get(pageAddr, off, maxSize).getBytes()));
            savedBytesCnt = ih.put(pageAddr, off, (Value)ValueBytes.get((byte[])new byte[]{1, 2, 3, 4, 5}), maxSize);
            InlineIndexColumnTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexColumnTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            InlineIndexColumnTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5}, ih.get(pageAddr, off, maxSize).getBytes()));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaObjectInlineBytes() throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        DataRegionMetricsImpl dataRegionMetrics = new DataRegionMetricsImpl(plcCfg, (GridKernalContext)new GridTestKernalContext(this.log()));
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(log, (DirectMemoryProvider)new UnsafeMemoryProvider(log), 1024, plcCfg, dataRegionMetrics, false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexColumnFactory factory = new InlineIndexColumnFactory(CompareMode.getInstance((String)"DEFAULT_", (int)1));
            AbstractInlineIndexColumn ih = (AbstractInlineIndexColumn)factory.createInlineHelper(new Column("", 19), false);
            ValueJavaObject exp = ValueJavaObject.getNoCopy((Object)new TestPojo(4, 3L), null, null);
            int maxSize = 6;
            int savedBytesCnt = ih.put(pageAddr, off, (Value)exp, maxSize);
            InlineIndexColumnTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexColumnTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            maxSize = 3 + exp.getBytesNoCopy().length;
            InlineIndexColumnTest.assertTrue((boolean)Arrays.equals(Arrays.copyOf(exp.getBytesNoCopy(), 3), ih.get(pageAddr, off, maxSize).getBytes()));
            savedBytesCnt = ih.put(pageAddr, off, (Value)ValueJavaObject.getNoCopy(null, (byte[])exp.getBytesNoCopy(), null), maxSize);
            InlineIndexColumnTest.assertTrue((savedBytesCnt > 0 ? 1 : 0) != 0);
            InlineIndexColumnTest.assertTrue((savedBytesCnt <= maxSize ? 1 : 0) != 0);
            InlineIndexColumnTest.assertTrue((boolean)Arrays.equals(exp.getBytesNoCopy(), ih.get(pageAddr, off, maxSize).getBytes()));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaObjectInlineHash() throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(log, (DirectMemoryProvider)new UnsafeMemoryProvider(log), 1024, plcCfg, new DataRegionMetricsImpl(plcCfg, (GridKernalContext)new GridTestKernalContext(this.log())), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexColumnFactory factory = new InlineIndexColumnFactory(CompareMode.getInstance((String)"DEFAULT_", (int)1));
            InlineIndexColumn ih = factory.createInlineHelper(new Column("", 19), true);
            Value exp = this.wrap(new TestPojo(4, 3L), TestPojo.class);
            int maxSize = 3;
            int savedBytesCnt = ih.put(pageAddr, off, exp, maxSize);
            Assert.assertEquals((long)0L, (long)savedBytesCnt);
            maxSize = 7;
            savedBytesCnt = ih.put(pageAddr, off, exp, maxSize);
            Assert.assertEquals((long)5L, (long)savedBytesCnt);
            Assert.assertEquals((long)exp.getObject().hashCode(), (long)((ObjectHashInlineIndexColumn)ih).inlinedValue(pageAddr, off).getInt());
            Assert.assertEquals((long)-2L, (long)ih.compare(pageAddr, off, maxSize, exp, null));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    @Test
    public void testDecimal() throws Exception {
        int maxSize = 5;
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(BigDecimal.valueOf(123456.703125), BigDecimal.valueOf(123456.703125), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(BigDecimal.valueOf(-123456.703125), BigDecimal.valueOf(123456.703125), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(BigDecimal.valueOf(-1.234566938017649E-22), BigDecimal.valueOf(1.234566938017649E-22), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(BigDecimal.valueOf(0.1234567f), BigDecimal.valueOf(-0.1234567f), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(BigDecimal.valueOf(123.4567f), BigDecimal.valueOf(123.4568f), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(BigDecimal.valueOf(1.234568f), BigDecimal.valueOf(1.234567f), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(BigDecimal.valueOf(1.0), null, BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(BigDecimal.valueOf(1.2345678901234568E29), BigDecimal.valueOf(1.2345678901234568E29), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(BigDecimal.valueOf(1.2345678901234568E29), BigDecimal.valueOf(-1.2345678901234568E29), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(BigDecimal.valueOf(-1.2345678901234567E19), BigDecimal.valueOf(1.2345678901234567E19), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(BigDecimal.valueOf(-1.2345678901234567E19), BigDecimal.valueOf(1.2345678901234567E19), BigDecimal.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(BigDecimal.valueOf(-1.2345678901234567E19), BigDecimal.valueOf(1.2345678901234567E19), BigDecimal.class, maxSize));
    }

    @Test
    public void testNull() throws Exception {
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueNull.INSTANCE, (Value)ValueInt.get((int)3));
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueNull.INSTANCE, (Value)ValueInt.get((int)3));
        int maxSize = 5;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare("aa", null, String.class, maxSize));
    }

    @Test
    public void testBoolean() throws Exception {
        this.testPutGet((Value)ValueBoolean.get((boolean)true), (Value)ValueBoolean.get((boolean)false), (Value)ValueBoolean.get((boolean)true));
        int maxSize = 2;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(true, null, Boolean.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(true, false, Boolean.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(false, true, Boolean.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(false, false, Boolean.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(true, true, Boolean.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(true, false, Boolean.class, maxSize - 1));
    }

    @Test
    public void testByte() throws Exception {
        this.testPutGet((Value)ValueByte.get((byte)-1), (Value)ValueByte.get((byte)2), (Value)ValueByte.get((byte)3));
        int maxSize = 2;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare((byte)42, null, Byte.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare((byte)42, (byte)16, Byte.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare((byte)16, (byte)42, Byte.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare((byte)42, (byte)42, Byte.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare((byte)127, (byte)127, Byte.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare((byte)127, (byte)-128, Byte.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare((byte)-128, (byte)127, Byte.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare((byte)42, (byte)16, Byte.class, maxSize - 1));
    }

    @Test
    public void testShort() throws Exception {
        this.testPutGet((Value)ValueShort.get((short)-32000), (Value)ValueShort.get((short)2), (Value)ValueShort.get((short)3));
        int maxSize = 3;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare((short)42, null, Short.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare((short)42, (short)16, Short.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare((short)16, (short)42, Short.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare((short)42, (short)42, Short.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare((short)Short.MAX_VALUE, (short)Short.MAX_VALUE, Short.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare((short)Short.MAX_VALUE, (short)Short.MIN_VALUE, Short.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, Short.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare((short)42, (short)16, Short.class, maxSize - 1));
    }

    @Test
    public void testInt() throws Exception {
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueInt.get((int)2), (Value)ValueInt.get((int)3));
        int maxSize = 5;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(42, null, Integer.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(42, 16, Integer.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(16, 42, Integer.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(42, 42, Integer.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(42, 16, Integer.class, maxSize - 1));
    }

    @Test
    public void testLong() throws Exception {
        this.testPutGet((Value)ValueLong.get((long)-1L), (Value)ValueLong.get((long)2L), (Value)ValueLong.get((long)3L));
        int maxSize = 9;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(42L, null, Long.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(42L, 16L, Long.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(16L, 42L, Long.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(42L, 42L, Long.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Long.MAX_VALUE, Long.MAX_VALUE, Long.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Long.MAX_VALUE, Long.MIN_VALUE, Long.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Long.MIN_VALUE, Long.MAX_VALUE, Long.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(42L, 16L, Long.class, maxSize - 1));
    }

    @Test
    public void testFloat() throws Exception {
        this.testPutGet((Value)ValueFloat.get((float)1.1f), (Value)ValueFloat.get((float)2.2f), (Value)ValueFloat.get((float)1.1f));
        int maxSize = 5;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(42.0f), null, Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(42.0f), Float.valueOf(16.0f), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(16.0f), Float.valueOf(42.0f), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Float.valueOf(42.0f), Float.valueOf(42.0f), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MAX_VALUE), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.MAX_VALUE), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(Float.NaN), Float.valueOf(16.0f), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(Float.NaN), Float.valueOf(Float.NEGATIVE_INFINITY), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Float.valueOf(Float.NaN), Float.valueOf(Float.POSITIVE_INFINITY), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Float.valueOf(Float.NaN), Float.valueOf(Float.NaN), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(16.0f), Float.valueOf(Float.NaN), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.NaN), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NaN), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.NaN), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.NaN), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.MAX_VALUE), Float.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(Float.valueOf(42.0f), Float.valueOf(16.0f), Float.class, maxSize - 1));
    }

    @Test
    public void testDouble() throws Exception {
        this.testPutGet((Value)ValueDouble.get((double)1.1f), (Value)ValueDouble.get((double)2.2f), (Value)ValueDouble.get((double)1.1f));
        int maxSize = 9;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(42.0, null, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(42.0, 16.0, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(16.0, 42.0, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(42.0, 42.0, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Double.MAX_VALUE, Double.MAX_VALUE, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Double.MAX_VALUE, Double.MIN_VALUE, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Double.MIN_VALUE, Double.MAX_VALUE, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Double.POSITIVE_INFINITY, Double.MAX_VALUE, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Double.NaN, 16.0, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Double.NaN, Double.NEGATIVE_INFINITY, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Double.NaN, Double.POSITIVE_INFINITY, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Double.NaN, Double.NaN, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(16.0, Double.NaN, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Double.NEGATIVE_INFINITY, Double.NaN, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Double.POSITIVE_INFINITY, Double.NaN, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Double.MAX_VALUE, Double.NaN, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Double.MIN_VALUE, Double.NaN, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Double.NEGATIVE_INFINITY, Double.MAX_VALUE, Double.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(42.0, 16.0, Double.class, maxSize - 1));
    }

    @Test
    public void testDate() throws Exception {
        this.testPutGet((Value)ValueDate.get((Date)Date.valueOf("2017-02-20")), (Value)ValueDate.get((Date)Date.valueOf("2017-02-21")), (Value)ValueDate.get((Date)Date.valueOf("2017-02-19")));
        int maxSize = 9;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Date.valueOf("2017-02-24"), null, Date.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Date.valueOf("2017-02-24"), Date.valueOf("2017-02-20"), Date.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Date.valueOf("2017-02-16"), Date.valueOf("2017-02-24"), Date.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Date.valueOf("2017-02-24"), Date.valueOf("2017-02-24"), Date.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(Date.valueOf("2017-02-24"), Date.valueOf("2017-02-20"), Date.class, maxSize - 1));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new Date(Long.MIN_VALUE - (long)DateTimeUtils.getTimeZoneOffset((long)Long.MIN_VALUE)), new Date(Long.MAX_VALUE - (long)DateTimeUtils.getTimeZoneOffset((long)Long.MAX_VALUE)), Date.class, maxSize));
    }

    @Test
    public void testTime() throws Exception {
        this.testPutGet((Value)ValueTime.get((Time)Time.valueOf("10:01:01")), (Value)ValueTime.get((Time)Time.valueOf("11:02:02")), (Value)ValueTime.get((Time)Time.valueOf("12:03:03")));
        int maxSize = 9;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Time.valueOf("4:20:00"), null, Time.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Time.valueOf("4:20:00"), Time.valueOf("4:19:59"), Time.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Time.valueOf("4:19:59"), Time.valueOf("4:20:00"), Time.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Time.valueOf("4:20:00"), Time.valueOf("4:20:00"), Time.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(Time.valueOf("4:19:59"), Time.valueOf("4:20:00"), Time.class, maxSize - 1));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Time.valueOf("00:00:00"), Time.valueOf("23:59:59"), Time.class, maxSize));
    }

    @Test
    public void testTimestamp() throws Exception {
        this.testPutGet((Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")), (Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")), (Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")));
        int maxSize = 17;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Timestamp.valueOf("2017-02-20 4:20:00"), null, Timestamp.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Timestamp.valueOf("2017-02-20 4:20:00"), Timestamp.valueOf("2017-02-19 4:20:00"), Timestamp.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Timestamp.valueOf("2017-02-19 4:20:00"), Timestamp.valueOf("2017-02-20 4:20:00"), Timestamp.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(Timestamp.valueOf("2017-02-20 4:20:00"), Timestamp.valueOf("2017-02-20 4:19:59"), Timestamp.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Timestamp.valueOf("2017-02-20 4:19:59"), Timestamp.valueOf("2017-02-20 4:20:00"), Timestamp.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(Timestamp.valueOf("2017-02-20 4:20:00"), Timestamp.valueOf("2017-02-20 4:20:00"), Timestamp.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(Timestamp.valueOf("2017-02-20 4:19:59"), Timestamp.valueOf("2017-02-20 4:20:00"), Timestamp.class, maxSize - 1));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(Timestamp.valueOf("2017-02-20 00:00:00"), Timestamp.valueOf("2017-02-20 23:59:59"), Timestamp.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new Timestamp(Long.MIN_VALUE - (long)DateTimeUtils.getTimeZoneOffset((long)Long.MIN_VALUE)), new Timestamp(Long.MAX_VALUE - (long)DateTimeUtils.getTimeZoneOffset((long)Long.MAX_VALUE)), Timestamp.class, maxSize));
    }

    @Test
    public void testUUID() throws Exception {
        this.testPutGet((Value)ValueUuid.get((String)UUID.randomUUID().toString()), (Value)ValueUuid.get((String)UUID.randomUUID().toString()), (Value)ValueUuid.get((String)UUID.randomUUID().toString()));
        int maxSize = 17;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new UUID(42L, 16L), null, UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new UUID(42L, 16L), new UUID(42L, 10L), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new UUID(42L, 10L), new UUID(42L, 16L), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)0, (int)this.putAndCompare(new UUID(42L, 16L), new UUID(42L, 16L), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new UUID(42L, 16L), new UUID(48L, 10L), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new UUID(48L, 10L), new UUID(42L, 16L), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new UUID(48L, Long.MAX_VALUE), new UUID(48L, Long.MIN_VALUE), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new UUID(48L, Long.MIN_VALUE), new UUID(48L, Long.MAX_VALUE), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new UUID(Long.MAX_VALUE, 10L), new UUID(Long.MIN_VALUE, 20L), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new UUID(Long.MIN_VALUE, 20L), new UUID(Long.MAX_VALUE, 10L), UUID.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(new UUID(42L, 16L), new UUID(42L, 10L), UUID.class, maxSize - 1));
    }

    @Test
    public void testJavaObjectHash() throws Exception {
        this.inlineObjHash = true;
        int maxSize = 5;
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new TestPojo(42, 16L), null, TestPojo.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new TestPojo(42, 16L), new TestPojo(16, 16L), TestPojo.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new TestPojo(16, 16L), new TestPojo(42, 16L), TestPojo.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(new TestPojo(42, 16L), new TestPojo(42, 16L), TestPojo.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)1, (int)this.putAndCompare(new TestPojo(Integer.MAX_VALUE, 16L), new TestPojo(Integer.MIN_VALUE, 16L), TestPojo.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-1, (int)this.putAndCompare(new TestPojo(Integer.MIN_VALUE, 16L), new TestPojo(Integer.MAX_VALUE, 16L), TestPojo.class, maxSize));
        InlineIndexColumnTest.assertEquals((int)-2, (int)this.putAndCompare(new TestPojo(42, 16L), new TestPojo(16, 16L), TestPojo.class, maxSize - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutGet(Value v1, Value v2, Value v3) throws Exception {
        DataRegionConfiguration plcCfg = new DataRegionConfiguration().setInitialSize(0x100000L).setMaxSize(0x100000L);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(log, (DirectMemoryProvider)new UnsafeMemoryProvider(log), 1024, plcCfg, new DataRegionMetricsImpl(plcCfg, (GridKernalContext)new GridTestKernalContext(this.log())), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            int max = 255;
            InlineIndexColumnFactory factory = new InlineIndexColumnFactory(CompareMode.getInstance((String)"DEFAULT_", (int)1));
            AbstractInlineIndexColumn ih = (AbstractInlineIndexColumn)factory.createInlineHelper(new Column("", v1.getValueType()), false);
            off += ih.put(pageAddr, off, v1, max - off);
            off += ih.put(pageAddr, off, v2, max - off);
            off += ih.put(pageAddr, off, v3, max - off);
            Value v11 = ih.get(pageAddr, 0, max);
            Value v22 = ih.get(pageAddr, ih.fullSize(pageAddr, 0), max);
            InlineIndexColumnTest.assertEquals((Object)v1.getObject(), (Object)v11.getObject());
            InlineIndexColumnTest.assertEquals((Object)v2.getObject(), (Object)v22.getObject());
            InlineIndexColumnTest.assertEquals((int)0, (int)ih.compare(pageAddr, 0, max, v1, ALWAYS_FAILS_COMPARATOR));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop(true);
        }
    }

    private String randomString(int cnt) {
        char[] buffer = new char[cnt];
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        while (cnt-- != 0) {
            char ch = rnd.nextInt(100) > 3 ? (char)(rnd.nextInt(95) + 32) : (char)(rnd.nextInt(65407) + 127);
            if (ch >= '\udc00' && ch <= '\udfff') {
                if (cnt == 0) {
                    ++cnt;
                    continue;
                }
                buffer[cnt] = ch;
                buffer[--cnt] = (char)(55296 + rnd.nextInt(128));
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udb7f') {
                if (cnt == 0) {
                    ++cnt;
                    continue;
                }
                buffer[cnt] = (char)(56320 + rnd.nextInt(128));
                buffer[--cnt] = ch;
                continue;
            }
            if (ch >= '\udb80' && ch <= '\udbff') {
                ++cnt;
                continue;
            }
            buffer[cnt] = ch;
        }
        return new String(buffer);
    }

    private <T> Value wrap(T val, Class<T> cls) throws IgniteCheckedException {
        if (val == null) {
            return ValueNull.INSTANCE;
        }
        int type = this.typeByClass(cls);
        switch (type) {
            case 1: {
                return ValueBoolean.get((boolean)((Boolean)val));
            }
            case 2: {
                return ValueByte.get((byte)((Byte)val));
            }
            case 3: {
                return ValueShort.get((short)((Short)val));
            }
            case 4: {
                return ValueInt.get((int)((Integer)val));
            }
            case 5: {
                return ValueLong.get((long)((Long)val));
            }
            case 8: {
                return ValueFloat.get((float)((Float)val).floatValue());
            }
            case 7: {
                return ValueDouble.get((double)((Double)val));
            }
            case 10: {
                return ValueDate.get((Date)((Date)val));
            }
            case 9: {
                return ValueTime.get((Time)((Time)val));
            }
            case 11: {
                return ValueTimestamp.get((Timestamp)((Timestamp)val));
            }
            case 20: {
                return ValueUuid.get((UUID)((UUID)val));
            }
            case 13: {
                return ValueString.get((String)((String)val));
            }
            case 21: {
                return ValueStringFixed.get((String)((FixedString)val).val);
            }
            case 14: {
                return ValueStringIgnoreCase.get((String)((IgnoreCaseString)val).val);
            }
            case 19: {
                return ValueJavaObject.getNoCopy((Object)this.marsh.marshal(val), null, null);
            }
            case 12: {
                return ValueBytes.getNoCopy((byte[])((byte[])val));
            }
            case 6: {
                return ValueDecimal.get((BigDecimal)((BigDecimal)val));
            }
        }
        throw new IllegalStateException("Unknown value type: type=" + type + ", cls=" + cls.getName());
    }

    private int typeByClass(Class<?> cls) {
        if (Boolean.class.isAssignableFrom(cls)) {
            return 1;
        }
        if (Byte.class.isAssignableFrom(cls)) {
            return 2;
        }
        if (Short.class.isAssignableFrom(cls)) {
            return 3;
        }
        if (Integer.class.isAssignableFrom(cls)) {
            return 4;
        }
        if (Long.class.isAssignableFrom(cls)) {
            return 5;
        }
        if (Float.class.isAssignableFrom(cls)) {
            return 8;
        }
        if (Double.class.isAssignableFrom(cls)) {
            return 7;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(cls)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(cls)) {
            return 11;
        }
        if (UUID.class.isAssignableFrom(cls)) {
            return 20;
        }
        if (String.class.isAssignableFrom(cls)) {
            return 13;
        }
        if (FixedString.class.isAssignableFrom(cls)) {
            return 21;
        }
        if (IgnoreCaseString.class.isAssignableFrom(cls)) {
            return 14;
        }
        if (BigDecimal.class.isAssignableFrom(cls)) {
            return 6;
        }
        if (byte[].class.isAssignableFrom(cls)) {
            return 12;
        }
        return 19;
    }

    private static class IgnoreCaseString {
        private final String val;

        public IgnoreCaseString(String val) {
            this.val = val;
        }
    }

    private static class FixedString {
        private final String val;

        public FixedString(String val) {
            this.val = val;
        }
    }

    private static class TestPojo
    implements Serializable {
        private final int a;
        private final long b;

        public TestPojo(int a, long b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestPojo pojo = (TestPojo)o;
            return this.a == pojo.a && this.b == pojo.b;
        }

        public int hashCode() {
            return this.a;
        }
    }

    private static class AlwaysFailsComparator
    implements Comparator<Value> {
        private AlwaysFailsComparator() {
        }

        @Override
        public int compare(Value o1, Value o2) {
            throw new AssertionError((Object)"Optimized algorithm should be used.");
        }
    }
}

