/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.BooleanInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ByteInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.BytesInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.DateInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.DecimalInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.DoubleInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.FixedStringInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.FloatInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.IntegerInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.LongInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ObjectHashInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.ShortInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.StringIgnoreCaseInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.StringInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.TimeInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.TimestampInlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.UuidInlineIndexColumn;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.TypeInfo;
import org.junit.Test;

public class H2ComputeInlineSizeTest
extends AbstractIndexingCommonTest {
    @Test
    public void testDefaultSizeForString() {
        Column c = new Column("c", new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        H2ComputeInlineSizeTest.assertEquals((int)10, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)-1, (IgniteLogger)log));
    }

    @Test
    public void testDefaultSizeForByteArray() {
        Column c = new Column("c", new TypeInfo(12, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        H2ComputeInlineSizeTest.assertEquals((int)10, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)-1, (IgniteLogger)log));
    }

    @Test
    public void testDefaultSizeForStringWithDefinedLength() {
        int LEN = 20;
        Column c = new Column("c", new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        c.setOriginalSQL("VARCHAR(20)");
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        H2ComputeInlineSizeTest.assertEquals((int)23, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)-1, (IgniteLogger)log));
    }

    @Test
    public void testDefaultSizeForBytesWithDefinedLength() {
        int LEN = 30;
        Column c = new Column("c", new TypeInfo(12, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        c.setOriginalSQL("BINARY(30)");
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        H2ComputeInlineSizeTest.assertEquals((int)33, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)-1, (IgniteLogger)log));
    }

    @Test
    public void testDefaultSizeForStringWithIncorrectSql() {
        Column c = new Column("c", new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        c.setOriginalSQL("CHAR()");
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        H2ComputeInlineSizeTest.assertEquals((int)10, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)-1, (IgniteLogger)log));
    }

    @Test
    public void testDefaultSizeForCompositeIndex() {
        int LEN = 9;
        Column c1 = new Column("c1", new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        Column c2 = new Column("c2", new TypeInfo(12, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        Column c3 = new Column("c3", new TypeInfo(5, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        Column c4 = new Column("c4", new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        c4.setOriginalSQL("VARCHAR(9)");
        LongInlineIndexColumn lCol = new LongInlineIndexColumn(c3);
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c1, false));
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c2, false));
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c3, false));
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c4, false));
        H2ComputeInlineSizeTest.assertEquals((int)(20 + lCol.size() + 1 + 9 + 3), (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)-1, (IgniteLogger)log));
    }

    @Test
    @WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="2147483647")
    public void testMaximumSizeUsedForLargeIndex() {
        Column c = new Column("c", new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        c.setOriginalSQL("VARCHAR(428)");
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        H2ComputeInlineSizeTest.assertEquals((int)427, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)-1, (IgniteLogger)log));
    }

    @Test
    @WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="2147483647")
    public void testConfiguredMaximumSizeUsedForLargeIndex() {
        int cfgMaxSize = 100;
        Column c = new Column("c", new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
        c.setOriginalSQL("VARCHAR(" + (cfgMaxSize + 1) + ")");
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        H2ComputeInlineSizeTest.assertEquals((int)cfgMaxSize, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)-1, (int)cfgMaxSize, (IgniteLogger)log));
    }

    @Test
    @WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="2147483647")
    public void testTooBigConfiguredInlineSizeNotUsed() {
        ArrayList valueTypes = Lists.newArrayList((Object[])new Integer[]{1, 3, 10, 10, 7, 8, 4, 2, 6, 9, 11, 20});
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        for (int i = 0; i < valueTypes.size(); ++i) {
            Integer valueType = (Integer)valueTypes.get(i);
            Column c = new Column("c" + i, new TypeInfo(valueType.intValue(), Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
            inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        }
        H2ComputeInlineSizeTest.assertEquals((int)92, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)427, (int)-1, (IgniteLogger)log));
    }

    @Test
    @WithSystemProperty(key="IGNITE_MAX_INDEX_PAYLOAD_SIZE", value="2147483647")
    public void testTooBigConfiguredInlineSizeUsedBecauseOneOfFieldsIsNotFixed() {
        ArrayList valueTypes = Lists.newArrayList((Object[])new Integer[]{1, 3, 10, 10, 7, 8, 4, 2, 6, 9, 11, 20, 13});
        ArrayList<InlineIndexColumn> inlineIdxs = new ArrayList<InlineIndexColumn>();
        for (int i = 0; i < valueTypes.size(); ++i) {
            Integer valueType = (Integer)valueTypes.get(i);
            Column c = new Column("c" + i, new TypeInfo(valueType.intValue(), Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null));
            inlineIdxs.add(H2ComputeInlineSizeTest.createHelper(c, false));
        }
        int cfgInlineSize = 426;
        H2ComputeInlineSizeTest.assertEquals((int)cfgInlineSize, (int)H2TreeIndexBase.computeInlineSize((String)"idx", inlineIdxs, (int)cfgInlineSize, (int)-1, (IgniteLogger)log));
    }

    private static InlineIndexColumn createHelper(Column col, boolean useOptimizedComp) {
        switch (col.getType().getValueType()) {
            case 1: {
                return new BooleanInlineIndexColumn(col);
            }
            case 2: {
                return new ByteInlineIndexColumn(col);
            }
            case 3: {
                return new ShortInlineIndexColumn(col);
            }
            case 4: {
                return new IntegerInlineIndexColumn(col);
            }
            case 5: {
                return new LongInlineIndexColumn(col);
            }
            case 8: {
                return new FloatInlineIndexColumn(col);
            }
            case 7: {
                return new DoubleInlineIndexColumn(col);
            }
            case 10: {
                return new DateInlineIndexColumn(col);
            }
            case 9: {
                return new TimeInlineIndexColumn(col);
            }
            case 11: {
                return new TimestampInlineIndexColumn(col);
            }
            case 20: {
                return new UuidInlineIndexColumn(col);
            }
            case 13: {
                return new StringInlineIndexColumn(col, useOptimizedComp);
            }
            case 21: {
                return new FixedStringInlineIndexColumn(col, useOptimizedComp);
            }
            case 14: {
                return new StringIgnoreCaseInlineIndexColumn(col, useOptimizedComp);
            }
            case 12: {
                return new BytesInlineIndexColumn(col, useOptimizedComp);
            }
            case 19: {
                return new ObjectHashInlineIndexColumn(col);
            }
            case 6: {
                return new DecimalInlineIndexColumn(col);
            }
        }
        throw new IllegalStateException("Unknown value type=" + col.getType().getValueType());
    }
}

