/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.math.BigInteger;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class IgniteSqlBigIntegerKeyTest
extends AbstractIndexingCommonTest {
    private static final String CACHE_NAME = "Mycache";
    private static final String SELECT_BY_KEY_SQL = "select _val from STUDENT where _key=?";
    private static final String SELECT_BY_ID_SQL = "select _val from STUDENT where id=?";
    private static final Student VALUE_OBJ = new Student(BigInteger.valueOf(42L), "John Doe");

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid("server");
        IgniteEx cli = this.startGrid(this.getConfiguration("client").setClientMode(true));
        IgniteCache cache = cli.getOrCreateCache(new CacheConfiguration().setIndexedTypes(new Class[]{BigInteger.class, Student.class}).setName(CACHE_NAME));
        cache.put((Object)IgniteSqlBigIntegerKeyTest.VALUE_OBJ.id, (Object)VALUE_OBJ);
    }

    private IgniteCache<Object, Object> getCache() {
        return this.grid("client").cache(CACHE_NAME);
    }

    @Test
    public void testBigIntegerKeyGet() {
        IgniteCache<Object, Object> cache = this.getCache();
        Object val = cache.get((Object)BigInteger.valueOf(42L));
        IgniteSqlBigIntegerKeyTest.assertNotNull((Object)val);
        IgniteSqlBigIntegerKeyTest.assertTrue((boolean)(val instanceof Student));
        IgniteSqlBigIntegerKeyTest.assertEquals((Object)VALUE_OBJ, (Object)val);
        val = cache.get((Object)new BigInteger("42"));
        IgniteSqlBigIntegerKeyTest.assertNotNull((Object)val);
        IgniteSqlBigIntegerKeyTest.assertTrue((boolean)(val instanceof Student));
        IgniteSqlBigIntegerKeyTest.assertEquals((Object)VALUE_OBJ, (Object)val);
    }

    @Test
    public void testBigIntegerKeyQuery() {
        IgniteCache<Object, Object> cache = this.getCache();
        this.checkQuery(cache, SELECT_BY_KEY_SQL, BigInteger.valueOf(42L));
        this.checkQuery(cache, SELECT_BY_KEY_SQL, new BigInteger("42"));
    }

    @Test
    public void testBigIntegerFieldQuery() {
        IgniteCache<Object, Object> cache = this.getCache();
        this.checkQuery(cache, SELECT_BY_ID_SQL, BigInteger.valueOf(42L));
        this.checkQuery(cache, SELECT_BY_ID_SQL, new BigInteger("42"));
    }

    private void checkQuery(IgniteCache<Object, Object> cache, String sql, Object arg) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(new Object[]{arg});
        FieldsQueryCursor query = cache.query(qry);
        List res = query.getAll();
        IgniteSqlBigIntegerKeyTest.assertEquals((int)1, (int)res.size());
        Object val = ((List)res.get(0)).get(0);
        IgniteSqlBigIntegerKeyTest.assertNotNull(val);
        IgniteSqlBigIntegerKeyTest.assertTrue((boolean)(val instanceof Student));
        IgniteSqlBigIntegerKeyTest.assertEquals((Object)VALUE_OBJ, val);
    }

    public static class Student {
        @QuerySqlField(index=true)
        BigInteger id;
        @QuerySqlField
        String name;

        Student(BigInteger id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Student student = (Student)o;
            if (!this.id.equals(student.id)) {
                return false;
            }
            return this.name.equals(student.name);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

