/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.h2.H2ResultSetIterator;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class H2ResultSetIteratorNullifyOnEndSelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 2;
    private static final int PERSON_COUNT = 20;
    private static final String SELECT_MAX_SAL_SQLF = "select max(salary) from Person";

    @Test
    public void testSqlFieldsQueryClose() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.iterator();
        qryCurs.close();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlFieldsQueryComplete() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.getAll();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlFieldsQueryLocalClose() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        qry.setLocal(true);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.iterator();
        qryCurs.close();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    @Test
    public void testSqlFieldsQueryLocalComplete() {
        SqlFieldsQuery qry = new SqlFieldsQuery(SELECT_MAX_SAL_SQLF);
        qry.setLocal(true);
        FieldsQueryCursor qryCurs = this.cache().query(qry);
        qryCurs.getAll();
        H2ResultSetIterator h2It = this.extractGridIteratorInnerH2ResultSetIterator((QueryCursor<List<?>>)qryCurs);
        this.checkIterator(h2It);
    }

    private void checkIterator(H2ResultSetIterator h2it) {
        if (Objects.nonNull(h2it)) {
            H2ResultSetIteratorNullifyOnEndSelfTest.assertNull((Object)GridTestUtils.getFieldValue((Object)h2it, H2ResultSetIterator.class, (String)"data"));
        } else {
            H2ResultSetIteratorNullifyOnEndSelfTest.fail();
        }
    }

    private H2ResultSetIterator extractGridIteratorInnerH2ResultSetIterator(QueryCursor<List<?>> qryCurs) {
        if (QueryCursorImpl.class.isAssignableFrom(qryCurs.getClass())) {
            Iterator h2RsIt;
            Object it = GridTestUtils.getFieldValue(qryCurs, QueryCursorImpl.class, (String)"iter");
            if (it instanceof QueryCursorImpl.LazyIterator) {
                it = GridTestUtils.getFieldValue((Object)it, QueryCursorImpl.LazyIterator.class, (String)"delegate");
            }
            if (H2ResultSetIterator.class.isAssignableFrom((h2RsIt = (Iterator)GridTestUtils.getFieldValue((Object)it, GridQueryCacheObjectsIterator.class, (String)"iter")).getClass())) {
                return (H2ResultSetIterator)h2RsIt;
            }
        }
        return null;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
        this.ignite(0).createCache(new CacheConfiguration("pers").setIndexedTypes(new Class[]{String.class, Person.class}));
        this.awaitPartitionMapExchange();
        this.populateDataIntoPerson();
    }

    private IgniteCache<String, Person> cache() {
        return this.grid(0).cache("pers");
    }

    private void populateDataIntoPerson() {
        IgniteCache<String, Person> cache = this.cache();
        int personId = 0;
        for (int j = 0; j < 20; ++j) {
            Person prsn = new Person();
            prsn.setId("pers" + personId);
            prsn.setName("Person name #" + personId);
            cache.put((Object)prsn.getId(), (Object)prsn);
            ++personId;
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String name;
        @QuerySqlField(index=true)
        private int salary;

        private Person() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getSalary() {
            return this.salary;
        }

        public void setSalary(int salary) {
            this.salary = salary;
        }
    }
}

