/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Ignore;
import org.junit.Test;

public class CacheQueryEntityWithDateTimeApiFieldsTest
extends AbstractIndexingCommonTest {
    private static final long DAYS_BEFORE_NOW = 10L;
    private static final LocalTime SAMPLE_TIME = LocalTime.now().minusHours(10L).withNano(1);
    private static final LocalDate SAMPLE_DATE = LocalDate.now().minusDays(10L);
    private static final LocalDateTime SAMPLE_DATE_TIME = LocalDateTime.of(SAMPLE_DATE, LocalTime.MIDNIGHT.withNano(1));
    private IgniteCache<Long, EntityWithDateTimeFields> cache;
    private final EntityWithDateTimeFields entity = new EntityWithDateTimeFields(1L, SAMPLE_TIME, SAMPLE_DATE, SAMPLE_DATE_TIME);

    protected static <K, V> CacheConfiguration<K, V> createCacheConfig(String cacheName, Class<?> ... indexedTypes) {
        return new CacheConfiguration(cacheName).setCacheMode(CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setIndexedTypes((Class[])indexedTypes);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private static CacheConfiguration<Long, EntityWithDateTimeFields> createCacheConfig() {
        return CacheQueryEntityWithDateTimeApiFieldsTest.createCacheConfig("entityWithJava8DataTimeFields", Long.class, EntityWithDateTimeFields.class);
    }

    protected void beforeTest() throws Exception {
        Ignite ignite = this.startGridsMultiThreaded(1, true);
        this.cache = ignite.getOrCreateCache(CacheQueryEntityWithDateTimeApiFieldsTest.createCacheConfig());
        this.cache.put((Object)this.entity.getId(), (Object)this.entity);
    }

    @Test
    public void testInsertEntityFields() throws Exception {
        this.cache.remove((Object)this.entity.getId());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
        SqlFieldsQuery qry = new SqlFieldsQuery("insert into EntityWithDateTimeFields(_key, id, locTime, locDate, locDateTime) values(?, ?, ?, ?, ?)").setArgs(new Object[]{this.entity.getId(), this.entity.getId(), this.entity.getLocalTime(), this.entity.getLocalDate(), this.entity.getLocalDateTime()});
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)1L, ((List)qryResults.get(0)).get(0));
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)this.cache.size(new CachePeekMode[0]));
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)this.entity, (Object)this.cache.get((Object)this.entity.getId()));
    }

    @Test
    public void testMergeEntityFields() throws Exception {
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)this.cache.size(new CachePeekMode[0]));
        SqlFieldsQuery qry = new SqlFieldsQuery("merge into EntityWithDateTimeFields(_key, id, locTime, locDate, locDateTime) values(?, ?, ?, ?, ?)").setArgs(new Object[]{this.entity.getId(), this.entity.getId(), this.entity.getLocalTime(), this.entity.getLocalDate(), this.entity.getLocalDateTime()});
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)1L, ((List)qryResults.get(0)).get(0));
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)this.cache.size(new CachePeekMode[0]));
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)this.entity, (Object)this.cache.get((Object)this.entity.getId()));
    }

    @Test
    public void testDateDiffForLocalDateTimeFieldAtMidnight() throws Exception {
        SqlFieldsQuery qry = new SqlFieldsQuery("select DATEDIFF('DAY', locDateTime, CURRENT_DATE ()) from EntityWithDateTimeFields");
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertTrue(((Long)((List)qryResults.get(0)).get(0) >= 10L ? 1 : 0) != 0);
    }

    @Test
    public void testSelectLocalTimeFieldReturnsTime() throws Exception {
        SqlFieldsQuery qry = new SqlFieldsQuery("select locTime from EntityWithDateTimeFields");
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals(Time.class, ((List)qryResults.get(0)).get(0).getClass());
    }

    @Test
    public void testSelectLocalDateFieldReturnsDate() throws Exception {
        SqlFieldsQuery qry = new SqlFieldsQuery("select locDate from EntityWithDateTimeFields");
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals(Date.class, ((List)qryResults.get(0)).get(0).getClass());
    }

    @Test
    public void testSelectLocalDateTimeFieldReturnsTimestamp() throws Exception {
        SqlFieldsQuery qry = new SqlFieldsQuery("select locDateTime from EntityWithDateTimeFields");
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals(Timestamp.class, ((List)qryResults.get(0)).get(0).getClass());
    }

    @Test
    public void testSelectByAllFields() {
        SqlFieldsQuery qry = new SqlFieldsQuery("select locDate from EntityWithDateTimeFields where locTime = ? and locDate = ? and locDateTime = ?").setArgs(new Object[]{this.entity.getLocalTime(), this.entity.getLocalDate(), this.entity.getLocalDateTime()});
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)Date.valueOf(this.entity.getLocalDate()), ((List)qryResults.get(0)).get(0));
    }

    @Test
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-12009")
    public void testUpdateAllFields() {
        EntityWithDateTimeFields expEntity = new EntityWithDateTimeFields(this.entity);
        expEntity.setLocalTime(expEntity.getLocalTime().plusHours(1L));
        expEntity.setLocalDate(expEntity.getLocalDate().plusDays(1L));
        expEntity.setLocalDateTime(LocalDateTime.of(expEntity.getLocalDate(), expEntity.getLocalTime()));
        SqlFieldsQuery qry = new SqlFieldsQuery("update EntityWithDateTimeFields set locTime = ?, locDate = ?, locDateTime = ? where id = ?").setArgs(new Object[]{expEntity.getLocalTime(), expEntity.getLocalDate(), expEntity.getLocalDateTime(), this.entity.getId()});
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)1L, ((List)qryResults.get(0)).get(0));
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)expEntity, (Object)this.cache.get((Object)expEntity.getId()));
    }

    @Test
    public void testUpdateAllFieldsMillisTimePrecision() {
        EntityWithDateTimeFields expEntity = new EntityWithDateTimeFields(this.entity);
        expEntity.setLocalTime(expEntity.getLocalTime().plusHours(1L).withNano(0).plus(123L, ChronoUnit.MILLIS));
        expEntity.setLocalDate(expEntity.getLocalDate().plusDays(1L));
        expEntity.setLocalDateTime(LocalDateTime.of(expEntity.getLocalDate(), expEntity.getLocalTime()));
        SqlFieldsQuery qry = new SqlFieldsQuery("update EntityWithDateTimeFields set locTime = ?, locDate = ?, locDateTime = ? where id = ?").setArgs(new Object[]{expEntity.getLocalTime(), expEntity.getLocalDate(), expEntity.getLocalDateTime(), this.entity.getId()});
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)1L, ((List)qryResults.get(0)).get(0));
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)expEntity, (Object)this.cache.get((Object)expEntity.getId()));
    }

    @Test
    public void testDeleteByAllFields() {
        SqlFieldsQuery qry = new SqlFieldsQuery("delete from EntityWithDateTimeFields where locTime = ? and locDate = ? and locDateTime = ?").setArgs(new Object[]{this.entity.getLocalTime(), this.entity.getLocalDate(), this.entity.getLocalDateTime()});
        List qryResults = this.cache.query(qry).getAll();
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)1, (int)qryResults.size());
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((Object)1L, ((List)qryResults.get(0)).get(0));
        CacheQueryEntityWithDateTimeApiFieldsTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
    }

    private static class EntityWithDateTimeFields
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @QuerySqlField(index=true)
        private Long id;
        @QuerySqlField(index=true)
        private LocalTime locTime;
        @QuerySqlField(index=true)
        private LocalDate locDate;
        @QuerySqlField(index=true)
        private LocalDateTime locDateTime;

        EntityWithDateTimeFields() {
        }

        EntityWithDateTimeFields(EntityWithDateTimeFields entity) {
            this.id = entity.id;
            this.locTime = LocalTime.from(entity.locTime);
            this.locDate = LocalDate.from(entity.locDate);
            this.locDateTime = LocalDateTime.from(entity.locDateTime);
        }

        EntityWithDateTimeFields(Long id, LocalTime locTime, LocalDate locDate, LocalDateTime locDateTime) {
            this.id = id;
            this.locTime = locTime;
            this.locDate = locDate;
            this.locDateTime = locDateTime;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public LocalDateTime getLocalDateTime() {
            return this.locDateTime;
        }

        public void setLocalDateTime(LocalDateTime locDateTime) {
            this.locDateTime = locDateTime;
        }

        public LocalDate getLocalDate() {
            return this.locDate;
        }

        public void setLocalDate(LocalDate locDate) {
            this.locDate = locDate;
        }

        public LocalTime getLocalTime() {
            return this.locTime;
        }

        public void setLocalTime(LocalTime locTime) {
            this.locTime = locTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityWithDateTimeFields fields = (EntityWithDateTimeFields)o;
            return Objects.equals(this.id, fields.id) && Objects.equals(this.locDateTime, fields.locDateTime) && Objects.equals(this.locDate, fields.locDate) && Objects.equals(this.locTime, fields.locTime);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.locDateTime, this.locDate, this.locTime);
        }

        public String toString() {
            return "EntityWithDateTimeFields{id=" + this.id + ", locDateTime=" + this.locDateTime + ", locDate=" + this.locDate + ", locTime=" + this.locTime + '}';
        }
    }
}

