/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SqlTwoCachesInGroupWithSameEntryTest
extends AbstractIndexingCommonTest {
    private static final int KEYS = 50000;
    @Parameterized.Parameter(value=0)
    public boolean persistenceEnabled;
    @Parameterized.Parameter(value=1)
    public boolean useOnlyPkHashIndex;

    @Parameterized.Parameters(name="persistence={0}, useOnlyPkHash={1}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        if (this.persistenceEnabled) {
            this.cleanPersistenceDir();
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(this.persistenceEnabled)));
    }

    @Test
    public void test() throws Exception {
        IgniteEx ign = this.startGrid(0);
        ign.cluster().active(true);
        IgniteCache cache0 = ign.createCache(new CacheConfiguration("cache0").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setGroupName("grp0").setSqlSchema("CACHE0").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        IgniteCache cache1 = ign.createCache(new CacheConfiguration("cache1").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setGroupName("grp0").setSqlSchema("CACHE1").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        for (int i = 0; i < 50000; ++i) {
            cache0.put((Object)i, (Object)i);
            cache1.put((Object)i, (Object)i);
        }
        if (this.useOnlyPkHashIndex) {
            for (GridH2Table t : ((IgniteH2Indexing)this.grid(0).context().query().getIndexing()).schemaManager().dataTables()) {
                GridTestUtils.setFieldValue((Object)t, (String)"rebuildFromHashInProgress", (Object)1);
            }
        }
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)50000, (int)cache0.size(new CachePeekMode[0]));
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)50000, (int)cache1.size(new CachePeekMode[0]));
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)50000, (int)this.sql("select * FROM cache0.Integer", new Object[0]).getAll().size());
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)50000, (int)this.sql("select * FROM cache1.Integer", new Object[0]).getAll().size());
        cache0.clear();
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)0, (int)cache0.size(new CachePeekMode[0]));
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)50000, (int)cache1.size(new CachePeekMode[0]));
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)0, (int)this.sql("select * FROM cache0.Integer", new Object[0]).getAll().size());
        SqlTwoCachesInGroupWithSameEntryTest.assertEquals((int)50000, (int)this.sql("select * FROM cache1.Integer", new Object[0]).getAll().size());
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false);
    }
}

